/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.level.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import team.creative.creativecore.common.level.IOrientatedLevel;
import team.creative.creativecore.common.level.ISubLevel;
import team.creative.creativecore.common.util.math.box.OBBVoxelShape;
import team.creative.creativecore.common.util.math.matrix.IVecOrigin;
import team.creative.littletiles.common.entity.LittleEntity;
import team.creative.littletiles.common.entity.LittleEntityPhysic;
import team.creative.littletiles.common.level.handler.LevelHandler;
import team.creative.littletiles.common.math.vec.LittleHitResult;

public abstract class LittleAnimationHandler
extends LevelHandler {
    public Set<LittleEntity> entities = new CopyOnWriteArraySet<LittleEntity>();

    public LittleAnimationHandler(Level level) {
        super(level);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void unload() {
        super.unload();
        this.entities.clear();
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    protected void tickEntity(LittleEntity entity) {
        if (entity.f_19853_ != this.level || entity.f_19853_ instanceof IOrientatedLevel) {
            return;
        }
        entity.performTick();
    }

    public void tick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            for (LittleEntity entity : this.entities) {
                this.tickEntity(entity);
            }
        }
    }

    public List<LittleEntity> find(AABB bb) {
        if (this.entities.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<LittleEntity> found = new ArrayList<LittleEntity>();
        for (LittleEntity entity : this.entities) {
            if (!entity.hasLoaded() || !entity.m_20191_().m_82381_(bb)) continue;
            found.add(entity);
        }
        return found;
    }

    public LittleEntity find(UUID uuid) {
        for (LittleEntity entity : this.entities) {
            if (!entity.m_20148_().equals(uuid)) continue;
            return entity;
        }
        return null;
    }

    public void add(LittleEntity entity) {
        this.entities.add(entity);
    }

    public void remove(LittleEntity entity) {
        this.entities.remove(entity);
    }

    public Iterable<VoxelShape> collisionExcept(@Nullable Entity colliding, AABB box, Level level) {
        if (level instanceof ISubLevel) {
            return null;
        }
        ArrayList<OBBVoxelShape> shapes = null;
        for (LittleEntity entity : this.find(box)) {
            if (!((LittleEntityPhysic)entity.physic).shouldPush()) continue;
            for (VoxelShape shape : entity.getSubLevel().m_186434_(colliding, entity.getOrigin().getOBB(box))) {
                for (AABB bb : shape.m_83299_()) {
                    if (!bb.m_82381_(box)) continue;
                    if (shapes == null) {
                        shapes = new ArrayList<OBBVoxelShape>();
                    }
                    shapes.add(OBBVoxelShape.create((AABB)bb, (IVecOrigin)entity.getOrigin()));
                }
            }
        }
        return shapes;
    }

    public LittleHitResult getHit(Vec3 pos, Vec3 look, double reach) {
        AABB box = new AABB(pos, look);
        LittleHitResult newHit = null;
        double distance = reach;
        for (LittleEntity entity : this.find(box)) {
            LittleHitResult tempResult;
            if (!entity.hasLoaded() || (tempResult = entity.rayTrace(pos, look)) == null || !(tempResult.hit instanceof BlockHitResult)) continue;
            double tempDistance = pos.m_82554_(entity.getOrigin().transformPointToWorld(tempResult.hit.m_82450_()));
            if (newHit != null && !(tempDistance < distance)) continue;
            newHit = tempResult;
            distance = tempDistance;
        }
        return newHit;
    }
}

