/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.math.face;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.renderer.FaceInfo;
import net.minecraft.core.Direction;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.geo.VectorFan;
import team.creative.creativecore.common.util.math.vec.Vec3f;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.box.LittleBoxCombiner;
import team.creative.littletiles.common.math.face.ILittleFace;

public class LittleFace
implements ILittleFace {
    public LittleGrid grid;
    public LittleBox box;
    public final Axis one;
    public final Axis two;
    public final Facing facing;
    public int minOne;
    public int minTwo;
    public int maxOne;
    public int maxTwo;
    public int origin;
    public int oldOrigin;
    public boolean[][] filled;
    private List<VectorFan> toCut = null;
    private List<VectorFan> cachedFans = null;
    private List<VectorFan> faceFans = null;
    private Iterable<VectorFan> tiltedFans = null;

    public LittleFace(LittleBox box, List<VectorFan> faceFans, Iterable<VectorFan> tiltedFans, LittleGrid grid, Facing facing, int minOne, int minTwo, int maxOne, int maxTwo, int origin) {
        this.box = box;
        this.faceFans = faceFans;
        this.tiltedFans = tiltedFans;
        this.grid = grid;
        this.facing = facing;
        this.one = facing.one();
        this.two = facing.two();
        this.minOne = minOne;
        this.minTwo = minTwo;
        this.maxOne = maxOne;
        this.maxTwo = maxTwo;
        this.origin = origin;
        this.oldOrigin = origin;
        this.filled = new boolean[maxOne - minOne][maxTwo - minTwo];
    }

    @Override
    public LittleGrid getGrid() {
        return this.grid;
    }

    @Override
    public void ensureGrid(LittleGrid context) {
        if (context == this.grid || this.grid.count > this.grid.count) {
            return;
        }
        int ratio = context.count / this.grid.count;
        this.minOne *= ratio;
        this.minTwo *= ratio;
        this.maxOne *= ratio;
        this.maxTwo *= ratio;
        this.origin *= ratio;
        this.oldOrigin *= ratio;
        this.box = this.box.copy();
        this.box.convertTo(this.grid, context);
        this.grid = context;
        this.filled = new boolean[this.maxOne - this.minOne][this.maxTwo - this.minTwo];
        if (this.faceFans != null) {
            ArrayList<VectorFan> newFans = new ArrayList<VectorFan>(this.faceFans.size());
            for (VectorFan fan : this.faceFans) {
                fan = fan.copy();
                fan.scale((float)ratio);
                newFans.add(fan);
            }
            if (this.tiltedFans != null) {
                ArrayList<VectorFan> tiledFansNew = new ArrayList<VectorFan>();
                for (VectorFan fan : this.tiltedFans) {
                    fan = fan.copy();
                    fan.scale((float)ratio);
                    tiledFansNew.add(fan);
                }
                this.tiltedFans = tiledFansNew;
            }
            this.faceFans = newFans;
        }
    }

    public boolean isPartiallyFilled() {
        if (this.toCut != null) {
            return true;
        }
        for (int one = 0; one < this.filled.length; ++one) {
            for (int two = 0; two < this.filled[one].length; ++two) {
                if (!this.filled[one][two]) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isFilled(boolean important) {
        if (important && this.toCut != null) {
            return this.generateFans().isEmpty();
        }
        for (int one = 0; one < this.filled.length; ++one) {
            for (int two = 0; two < this.filled[one].length; ++two) {
                if (this.filled[one][two]) continue;
                return false;
            }
        }
        return true;
    }

    private float get(LittleBox box, int index) {
        Facing direction = Facing.get((int)index);
        if (direction.axis == this.one) {
            return (direction.positive ? box.maxX : box.minX) + this.minOne;
        }
        if (direction.axis == this.two) {
            return (direction.positive ? box.maxY : box.minY) + this.minTwo;
        }
        return this.oldOrigin;
    }

    @Override
    public void setPartiallyFilled() {
    }

    @Override
    public boolean supportsCutting() {
        return true;
    }

    @Override
    public void cut(List<VectorFan> fans) {
        if (this.toCut == null) {
            this.toCut = new ArrayList<VectorFan>();
        }
        Axis axis = Axis.third((Axis)this.one, (Axis)this.two);
        for (VectorFan fan : fans) {
            fan = fan.copy();
            for (int i = 0; i < fan.count(); ++i) {
                fan.get(i).set(axis, (float)this.oldOrigin);
            }
            this.toCut.add(fan);
        }
    }

    public List<VectorFan> generateFans() {
        if (this.cachedFans != null) {
            return this.cachedFans;
        }
        ArrayList<LittleBox> boxes = new ArrayList<LittleBox>();
        int startOne = 0;
        int startTwo = 0;
        boolean toAdd = false;
        for (int one = 0; one < this.filled.length; ++one) {
            for (int two = 0; two < this.filled[one].length; ++two) {
                if (this.filled[one][two]) {
                    if (toAdd) {
                        boxes.add(new LittleBox(startOne, startTwo, 0, one + 1, two, 0));
                        toAdd = false;
                    }
                    startOne = one;
                    startTwo = two;
                    continue;
                }
                if (toAdd) continue;
                startOne = one;
                startTwo = two;
                toAdd = true;
            }
            if (!toAdd) continue;
            boxes.add(new LittleBox(startOne, startTwo, 0, one + 1, this.filled[one].length, 0));
            toAdd = false;
        }
        LittleBoxCombiner.combine(boxes);
        Object fans = new ArrayList<VectorFan>(boxes.size());
        for (LittleBox iterator : boxes) {
            FaceInfo face = FaceInfo.m_108984_((Direction)this.facing.toVanilla());
            Vec3f[] coords = new Vec3f[4];
            for (int i = 0; i < coords.length; ++i) {
                FaceInfo.VertexInfo info = face.m_108982_(i);
                Vec3f vec = new Vec3f();
                vec.x = this.get(iterator, info.f_108998_);
                vec.y = this.get(iterator, info.f_108999_);
                vec.z = this.get(iterator, info.f_109000_);
                coords[i] = vec;
            }
            fans.add(new VectorFan(coords));
        }
        if (this.faceFans != null) {
            ArrayList newFans = new ArrayList();
            Iterator iterator = fans.iterator();
            while (iterator.hasNext()) {
                VectorFan fan3 = (VectorFan)iterator.next();
                newFans.addAll(fan3.cut2d(this.faceFans, this.one, this.two, this.facing.positive, true));
            }
            fans = newFans;
        }
        if (this.toCut == null) {
            if (this.tiltedFans != null) {
                for (VectorFan vectorFan : this.tiltedFans) {
                    fans.add(vectorFan);
                }
            }
            return fans;
        }
        ArrayList<VectorFan> result = new ArrayList<VectorFan>();
        Iterator iterator = fans.iterator();
        while (iterator.hasNext()) {
            VectorFan fan = (VectorFan)iterator.next();
            result.addAll(fan.cut2d(this.toCut, this.one, this.two, !this.facing.positive, false));
        }
        if (this.tiltedFans != null) {
            for (VectorFan fan : this.tiltedFans) {
                result.add(fan);
            }
        }
        this.cachedFans = result;
        return result;
    }

    public LittleBox getBox() {
        return this.box;
    }

    public boolean isFaceInsideBlock() {
        return this.origin > 0 && this.origin < this.grid.count;
    }

    public void move(Facing facing) {
        this.origin = facing.positive ? 0 : this.grid.count;
    }

    @Override
    public Facing facing() {
        return this.facing;
    }

    @Override
    public Axis one() {
        return this.one;
    }

    @Override
    public Axis two() {
        return this.two;
    }

    @Override
    public int origin() {
        return this.origin;
    }

    @Override
    public int minOne() {
        return this.minOne;
    }

    @Override
    public int minTwo() {
        return this.minTwo;
    }

    @Override
    public int maxOne() {
        return this.maxOne;
    }

    @Override
    public int maxTwo() {
        return this.maxTwo;
    }

    @Override
    public void set(int one, int two, boolean value) {
        this.filled[one][two] = value;
    }
}

