/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.math.location;

import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import team.creative.littletiles.common.action.LittleActionException;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.little.tile.parent.IStructureParentCollection;
import team.creative.littletiles.common.structure.LittleStructure;

public class LocalStructureLocation {
    public final BlockPos pos;
    public final int index;

    public LocalStructureLocation(BlockPos pos, int index) {
        this.pos = pos;
        this.index = index;
    }

    public LocalStructureLocation(LittleStructure structure) {
        this(structure.getPos(), structure.getIndex());
    }

    public LocalStructureLocation(CompoundTag nbt) {
        int[] posArray = nbt.m_128465_("pos");
        if (posArray.length != 3) {
            throw new IllegalArgumentException("Invalid pos array length " + Arrays.toString(posArray));
        }
        this.pos = new BlockPos(posArray[0], posArray[1], posArray[2]);
        this.index = nbt.m_128451_("index");
    }

    public CompoundTag write() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128385_("pos", new int[]{this.pos.m_123341_(), this.pos.m_123342_(), this.pos.m_123343_()});
        nbt.m_128405_("index", this.index);
        return nbt;
    }

    public LittleStructure find(Level level) throws LittleActionException {
        BlockEntity te = level.m_7702_(this.pos);
        if (te instanceof BETiles) {
            IStructureParentCollection structure = ((BETiles)te).getStructure(this.index);
            if (structure != null) {
                return structure.getStructure();
            }
            throw new LittleActionException.StructureNotFoundException();
        }
        throw new LittleActionException.TileEntityNotFoundException();
    }
}

