/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.packet.action;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import team.creative.creativecore.common.level.ISubLevel;
import team.creative.creativecore.common.network.CanBeNull;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.mc.PlayerUtils;
import team.creative.creativecore.common.util.mc.TickUtils;
import team.creative.creativecore.common.util.type.itr.FunctionIterator;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.action.LittleAction;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.little.element.LittleElement;
import team.creative.littletiles.common.block.little.tile.LittleTileContext;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.block.little.tile.parent.IParentCollection;
import team.creative.littletiles.common.entity.LittleEntity;
import team.creative.littletiles.common.item.ItemLittleChisel;
import team.creative.littletiles.common.item.ItemLittleGlove;
import team.creative.littletiles.common.item.ItemLittlePaintBrush;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;

public class BlockPacket
extends CreativePacket {
    public BlockPos blockPos;
    public Vec3 pos;
    public Vec3 look;
    public BlockPacketAction action;
    public CompoundTag nbt;
    @CanBeNull
    public UUID uuid;

    public BlockPacket() {
    }

    public BlockPacket(Level level, BlockPos blockPos, Player player, BlockPacketAction action) {
        this(level, blockPos, player, action, new CompoundTag());
    }

    public BlockPacket(Level level, BlockPos blockPos, Player player, BlockPacketAction action, CompoundTag nbt) {
        this.blockPos = blockPos;
        this.action = action;
        float partialTickTime = TickUtils.getFrameTime((LevelAccessor)level);
        this.pos = player.m_20318_(partialTickTime);
        double distance = PlayerUtils.getReach((Player)player);
        Vec3 view = player.m_20252_(partialTickTime);
        this.look = this.pos.m_82520_(view.f_82479_ * distance, view.f_82480_ * distance, view.f_82481_ * distance);
        this.nbt = nbt;
        if (level instanceof ISubLevel) {
            ISubLevel subLevel = (ISubLevel)level;
            this.uuid = subLevel.getHolder().m_20148_();
        }
    }

    public void executeClient(Player player) {
    }

    public void executeServer(ServerPlayer player) {
        BlockEntity blockEntity;
        Object level = player.f_19853_;
        if (this.uuid != null) {
            LittleEntity entity = LittleTiles.ANIMATION_HANDLERS.find(false, this.uuid);
            if (entity == null) {
                return;
            }
            if (!LittleAction.isAllowedToInteract((Player)player, entity, this.action.rightClick)) {
                return;
            }
            level = entity.getSubLevel();
            this.pos = entity.getOrigin().transformPointToFakeWorld(this.pos);
            this.look = entity.getOrigin().transformPointToFakeWorld(this.look);
        }
        if ((blockEntity = level.m_7702_(this.blockPos)) instanceof BETiles) {
            BETiles be = (BETiles)blockEntity;
            LittleTileContext context = be.getFocusedTile(this.pos, this.look);
            if (!LittleAction.isAllowedToInteract((LevelAccessor)level, (Player)player, this.blockPos, this.action.rightClick, Facing.EAST)) {
                LittleAction.sendBlockResetToClient((LevelAccessor)level, (Player)player, (BlockEntity)be);
                return;
            }
            if (context.isComplete()) {
                ItemStack stack = player.m_21205_();
                this.action.action((Level)level, be, context, stack, (Player)player, be.rayTrace(this.pos, this.look), this.blockPos, this.nbt);
                player.f_36095_.m_38946_();
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum BlockPacketAction {
        COLOR_TUBE(true){

            @Override
            public void action(Level level, BETiles be, LittleTileContext context, ItemStack stack, Player player, BlockHitResult moving, BlockPos pos, CompoundTag nbt) {
                if (context.parent.isStructure()) {
                    try {
                        LittleStructure structure = context.parent.getStructure();
                        if (structure.hasStructureColor()) {
                            ItemLittlePaintBrush.setColor(player.m_21205_(), structure.getStructureColor());
                            return;
                        }
                    }
                    catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                        // empty catch block
                    }
                }
                ItemLittlePaintBrush.setColor(player.m_21205_(), context.tile.color);
            }
        }
        ,
        CHISEL(false){

            @Override
            public void action(Level level, BETiles be, LittleTileContext context, ItemStack stack, Player player, BlockHitResult moving, BlockPos pos, CompoundTag nbt) {
                if (LittleAction.isBlockValid(context.tile.getState())) {
                    ItemLittleChisel.setElement(stack, new LittleElement(context.tile.getState(), -1));
                }
            }
        }
        ,
        GRABBER(false){

            @Override
            public void action(Level level, BETiles be, LittleTileContext context, ItemStack stack, Player player, BlockHitResult moving, BlockPos pos, CompoundTag nbt) {
                ItemLittleGlove.getMode(stack).littleBlockAction(level, be, context, stack, pos, nbt);
            }
        }
        ,
        WRENCH(true){

            @Override
            public void action(Level level, BETiles be, LittleTileContext context, ItemStack stack, Player player, BlockHitResult moving, BlockPos pos, CompoundTag nbt) {
                player.m_213846_((Component)Component.m_237113_((String)("grid:" + be.getGrid())));
                be.combineTiles();
                be.convertBlockToVanilla();
                be.updateTiles();
            }
        }
        ,
        WRENCH_INFO(true){

            @Override
            public void action(Level level, BETiles be, LittleTileContext context, ItemStack stack, Player player, BlockHitResult moving, BlockPos pos, CompoundTag nbt) {
                if (context.parent.isStructure()) {
                    try {
                        String info = context.parent.getStructure().info();
                        if (!info.isEmpty()) {
                            player.m_213846_((Component)Component.m_237113_((String)info));
                        }
                    }
                    catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                        // empty catch block
                    }
                }
            }
        }
        ,
        RECIPE(false){

            @Override
            public void action(Level level, BETiles be, LittleTileContext context, ItemStack stack, Player player, BlockHitResult moving, BlockPos pos, CompoundTag nbt) {
                LittleGroup previews;
                if (context.parent.isStructure()) {
                    if (nbt.m_128471_("secondMode")) {
                        try {
                            previews = context.parent.getStructure().getPreviews(pos);
                        }
                        catch (CorruptedConnectionException | NotYetConnectedException e) {
                            return;
                        }
                    } else {
                        try {
                            previews = context.parent.getStructure().findTopStructure().getPreviews(pos);
                        }
                        catch (CorruptedConnectionException | NotYetConnectedException e) {
                            return;
                        }
                    }
                } else {
                    previews = new LittleGroup();
                    if (nbt.m_128471_("secondMode")) {
                        for (IParentCollection collection : be.groups()) {
                            previews.addAll(be.getGrid(), () -> new FunctionIterator((Iterable)collection, x -> x.copy()));
                        }
                    } else {
                        previews.addTile(be.getGrid(), context.tile.copy());
                    }
                }
                stack.m_41784_().m_128365_("c", (Tag)LittleGroup.save(previews));
            }
        };

        public final boolean rightClick;

        private BlockPacketAction(boolean rightClick) {
            this.rightClick = rightClick;
        }

        public abstract void action(Level var1, BETiles var2, LittleTileContext var3, ItemStack var4, Player var5, BlockHitResult var6, BlockPos var7, CompoundTag var8);
    }
}

