/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.placement.shape.type;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.simple.GuiCheckBox;
import team.creative.creativecore.common.gui.controls.simple.GuiStateButton;
import team.creative.creativecore.common.gui.controls.simple.GuiSteppedSlider;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.transformation.Rotation;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.box.collection.LittleBoxes;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.common.placement.shape.LittleShape;
import team.creative.littletiles.common.placement.shape.ShapeSelection;

public class LittleShapeCylinder
extends LittleShape {
    public LittleShapeCylinder() {
        super(2);
    }

    @Override
    protected void addBoxes(LittleBoxes boxes, ShapeSelection selection, boolean lowResolution) {
        LittleBox box = selection.getOverallBox();
        boolean hollow = selection.getNBT().m_128471_("hollow");
        int direction = selection.getNBT().m_128451_("direction");
        LittleVec size = box.getSize();
        int sizeA = size.x;
        int sizeB = size.z;
        if (direction == 1) {
            sizeA = size.y;
            sizeB = size.z;
        } else if (direction == 2) {
            sizeA = size.x;
            sizeB = size.y;
        }
        double a = Math.pow(Math.max(1.0, (double)sizeA / 2.0), 2.0);
        double b = Math.pow(Math.max(1.0, (double)sizeB / 2.0), 2.0);
        double a2 = 1.0;
        double b2 = 1.0;
        int thickness = selection.getNBT().m_128451_("thickness");
        if (hollow && sizeA > thickness * 2 && sizeB > thickness * 2) {
            int sizeAValue = sizeA - thickness - 1;
            int sizeBValue = sizeB - thickness - 1;
            a2 = Math.pow(Math.max(1.0, (double)sizeAValue / 2.0), 2.0);
            b2 = Math.pow(Math.max(1.0, (double)sizeBValue / 2.0), 2.0);
        } else {
            hollow = false;
        }
        boolean stretchedA = sizeA % 2 == 0;
        boolean stretchedB = sizeB % 2 == 0;
        double centerA = sizeA / 2;
        double centerB = sizeB / 2;
        LittleVec min = box.getMinVec();
        LittleVec max = box.getMaxVec();
        for (int incA = 0; incA < sizeA; ++incA) {
            for (int incB = 0; incB < sizeB; ++incB) {
                double valueB;
                double posA = (double)incA - centerA + (stretchedA ? 0.5 : 0.0);
                double posB = (double)incB - centerB + (stretchedB ? 0.5 : 0.0);
                double valueA = Math.pow(posA, 2.0) / a;
                if (!(valueA + (valueB = Math.pow(posB, 2.0) / b) <= 1.0)) continue;
                LittleBox toAdd = null;
                switch (direction) {
                    case 0: {
                        toAdd = new LittleBox(min.x + incA, min.y, min.z + incB, min.x + incA + 1, max.y, min.z + incB + 1);
                        break;
                    }
                    case 1: {
                        toAdd = new LittleBox(min.x, min.y + incA, min.z + incB, max.x, min.y + incA + 1, min.z + incB + 1);
                        break;
                    }
                    case 2: {
                        toAdd = new LittleBox(min.x + incA, min.y + incB, min.z, min.x + incA + 1, min.y + incB + 1, max.z);
                    }
                }
                if (hollow) {
                    double valueB2;
                    double valueA2 = Math.pow(posA, 2.0) / a2;
                    if (valueA2 + (valueB2 = Math.pow(posB, 2.0) / b2) <= 1.0) continue;
                    boxes.add(toAdd);
                    continue;
                }
                boxes.add(toAdd);
            }
        }
        boxes.combineBoxesBlocks();
    }

    @Override
    public void addExtraInformation(CompoundTag nbt, List<Component> list) {
        if (nbt.m_128471_("hollow")) {
            list.add((Component)Component.m_237115_((String)"gui.type").m_130946_(": ").m_7220_((Component)Component.m_237115_((String)"gui.hollow")));
            list.add((Component)Component.m_237115_((String)"gui.thickness").m_130946_(": " + nbt.m_128451_("thickness")).m_7220_((Component)Component.m_237115_((String)"gui.pixel.length")));
        } else {
            list.add((Component)Component.m_237115_((String)"gui.type").m_130946_(": ").m_7220_((Component)Component.m_237115_((String)"gui.solid")));
        }
        int facing = nbt.m_128451_("direction");
        list.add((Component)Component.m_237115_((String)"gui.facing").m_130946_(": ").m_7220_((Component)Component.m_237115_((String)("gui.axis." + (switch (facing) {
            case 1 -> "x";
            case 2 -> "z";
            default -> "y";
        })))));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<GuiControl> getCustomSettings(CompoundTag nbt, LittleGrid grid) {
        ArrayList<GuiControl> controls = new ArrayList<GuiControl>();
        controls.add((GuiControl)new GuiCheckBox("hollow", nbt.m_128471_("hollow")));
        controls.add((GuiControl)new GuiSteppedSlider("thickness", nbt.m_128451_("thickness"), 1, grid.count));
        controls.add((GuiControl)new GuiStateButton("direction", nbt.m_128451_("direction"), new String[]{"facing: y", "facing: x", "facing: z"}));
        return controls;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void saveCustomSettings(GuiParent gui, CompoundTag nbt, LittleGrid grid) {
        GuiCheckBox box = (GuiCheckBox)gui.get("hollow");
        nbt.m_128379_("hollow", box.value);
        GuiSteppedSlider slider = (GuiSteppedSlider)gui.get("thickness");
        nbt.m_128405_("thickness", (int)slider.value);
        GuiStateButton state = (GuiStateButton)gui.get("direction");
        nbt.m_128405_("direction", state.getState());
    }

    @Override
    public void rotate(CompoundTag nbt, Rotation rotation) {
        int direction = nbt.m_128451_("direction");
        direction = rotation.axis != Axis.Y ? 0 : (direction == 1 ? 2 : 1);
        nbt.m_128405_("direction", direction);
    }

    @Override
    public void mirror(CompoundTag nbt, Axis axis) {
    }
}

