/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.placement.shape.type;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.simple.GuiStateButton;
import team.creative.creativecore.common.gui.controls.simple.GuiSteppedSlider;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.BoxCorner;
import team.creative.creativecore.common.util.math.transformation.Rotation;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.box.LittleTransformableBox;
import team.creative.littletiles.common.math.box.collection.LittleBoxes;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.common.placement.PlacementPosition;
import team.creative.littletiles.common.placement.shape.LittleShape;
import team.creative.littletiles.common.placement.shape.ShapeSelection;

public class LittleShapeWall
extends LittleShape {
    public LittleShapeWall() {
        super(2);
    }

    public void shrinkEdge(LittleTransformableBox.CornerCache cache, Axis axis, Axis one, Axis two, boolean positive, LittleBox box) {
        Facing facing = Facing.get((Axis)axis, (boolean)positive);
        BoxCorner[] corners = BoxCorner.faceCorners((Facing)facing);
        for (int i = 0; i < corners.length; ++i) {
            BoxCorner corner;
            cache.setAbsolute(corner, one, (corner = corners[i]).isFacingPositive(one) ? box.getMax(one) : box.getMin(one));
            cache.setAbsolute(corner, two, corner.isFacingPositive(two) ? box.getMax(two) : box.getMin(two));
        }
    }

    public void shrinkEdge(LittleTransformableBox.CornerCache cache, Axis axis, Axis one, Axis two, boolean positive, Facing targetFace, LittleBox box) {
        Facing facing = Facing.get((Axis)axis, (boolean)positive);
        if (targetFace == null) {
            targetFace = facing;
        } else if (targetFace == facing.opposite()) {
            targetFace = facing;
        }
        Axis targetAxis = targetFace.axis;
        BoxCorner[] corners = BoxCorner.faceCorners((Facing)facing);
        for (int i = 0; i < corners.length; ++i) {
            BoxCorner corner;
            cache.setAbsolute(corner, one, (corner = corners[i]).isFacingPositive(one) ? box.getMax(one) : box.getMin(one));
            cache.setAbsolute(corner, two, corner.isFacingPositive(two) ? box.getMax(two) : box.getMin(two));
            if (facing == targetFace) continue;
            if (corner.isFacingPositive(targetAxis) != targetFace.positive) {
                cache.setAbsolute(corner, axis, positive ? box.getMin(axis) : box.getMax(axis));
                continue;
            }
            cache.setAbsolute(corner, targetAxis, targetFace.positive ? box.getMin(targetAxis) : box.getMax(targetAxis));
        }
    }

    @Override
    protected void addBoxes(LittleBoxes boxes, ShapeSelection selection, boolean lowResolution) {
        int direction = selection.getNBT().m_128451_("direction");
        PlacementPosition originalMin = selection.getFirst().pos.copy();
        PlacementPosition originalMax = selection.getLast().pos.copy();
        originalMin.convertTo(boxes.getGrid());
        originalMax.convertTo(boxes.getGrid());
        int thickness = Math.max(0, selection.getNBT().m_128451_("thickness") - 1);
        LittleTransformableBox box = new LittleTransformableBox(selection.getOverallBox(), new int[1]);
        Axis toIgnore = direction == 0 ? Axis.Y : (direction == 1 ? Axis.X : Axis.Z);
        Axis oneIgnore = toIgnore.one();
        Axis twoIgnore = toIgnore.two();
        Axis axis = box.getSize(oneIgnore) > box.getSize(twoIgnore) ? oneIgnore : twoIgnore;
        LittleTransformableBox littleTransformableBox = box;
        Objects.requireNonNull(littleTransformableBox);
        LittleTransformableBox.CornerCache cache = littleTransformableBox.new LittleTransformableBox.CornerCache(false);
        LittleVec originalMinVec = originalMin.getRelative(boxes.pos);
        LittleVec originalMaxVec = originalMax.getRelative(boxes.pos);
        Axis one = axis.one();
        Axis two = axis.two();
        LittleBox minBox = new LittleBox(originalMinVec);
        LittleBox maxBox = new LittleBox(originalMaxVec);
        Facing minFacing = originalMin.facing;
        Facing maxFacing = originalMax.facing;
        if (minFacing.axis == toIgnore || box.getSize(minFacing.axis) == 1) {
            minFacing = null;
        }
        if (maxFacing.axis == toIgnore || box.getSize(maxFacing.axis) == 1) {
            maxFacing = null;
        }
        if (minFacing != null && minFacing == maxFacing) {
            if (originalMinVec.get(axis) <= originalMaxVec.get(axis)) {
                minFacing = Facing.get((Axis)axis, (boolean)false);
                maxFacing = minFacing.opposite();
            } else {
                minFacing = Facing.get((Axis)axis, (boolean)true);
                maxFacing = minFacing.opposite();
            }
        }
        int invSize = thickness / 2;
        int size = thickness - invSize;
        minBox.growCentered(thickness);
        LittleVec vec = new LittleVec(originalMin.facing);
        if (originalMin.facing.positive) {
            vec.scale(size);
        } else {
            vec.scale(-invSize);
        }
        minBox.add(vec);
        maxBox.growCentered(thickness);
        vec = new LittleVec(originalMax.facing);
        if (originalMax.facing.positive) {
            vec.scale(size);
        } else {
            vec.scale(-invSize);
        }
        maxBox.add(vec);
        box.growToInclude(minBox);
        box.growToInclude(maxBox);
        minBox.setMin(toIgnore, box.getMin(toIgnore));
        maxBox.setMin(toIgnore, box.getMin(toIgnore));
        minBox.setMax(toIgnore, box.getMax(toIgnore));
        maxBox.setMax(toIgnore, box.getMax(toIgnore));
        boolean facingPositive = originalMinVec.get(axis) > originalMaxVec.get(axis);
        this.shrinkEdge(cache, axis, one, two, facingPositive, minFacing, minBox);
        this.shrinkEdge(cache, axis, one, two, !facingPositive, maxFacing, maxBox);
        box.setData(cache.getData());
        boxes.add(box);
    }

    @Override
    public void addExtraInformation(CompoundTag nbt, List<Component> list) {
        list.add((Component)Component.m_237115_((String)"gui.thickness").m_130946_(": " + nbt.m_128451_("thickness")).m_7220_((Component)Component.m_237115_((String)"gui.pixel.length")));
        int facing = nbt.m_128451_("direction");
        list.add((Component)Component.m_237115_((String)"gui.facing").m_130946_(": ").m_7220_((Component)Component.m_237115_((String)("gui.axis." + (switch (facing) {
            case 1 -> "x";
            case 2 -> "z";
            default -> "y";
        })))));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<GuiControl> getCustomSettings(CompoundTag nbt, LittleGrid grid) {
        ArrayList<GuiControl> controls = new ArrayList<GuiControl>();
        controls.add((GuiControl)new GuiSteppedSlider("thickness", nbt.m_128451_("thickness"), 1, grid.count));
        controls.add((GuiControl)new GuiStateButton("direction", nbt.m_128451_("direction"), new String[]{"facing: y", "facing: x", "facing: z"}));
        return controls;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void saveCustomSettings(GuiParent gui, CompoundTag nbt, LittleGrid grid) {
        GuiSteppedSlider slider = (GuiSteppedSlider)gui.get("thickness");
        nbt.m_128405_("thickness", (int)slider.value);
        GuiStateButton state = (GuiStateButton)gui.get("direction");
        nbt.m_128405_("direction", state.getState());
    }

    @Override
    public void rotate(CompoundTag nbt, Rotation rotation) {
        int direction = nbt.m_128451_("direction");
        direction = rotation.axis != Axis.Y ? 0 : (direction == 1 ? 2 : 1);
        nbt.m_128405_("direction", direction);
    }

    @Override
    public void mirror(CompoundTag nbt, Axis axis) {
    }
}

