/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.animation;

import net.minecraft.nbt.CompoundTag;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.transformation.Rotation;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.littletiles.common.structure.animation.PhysicalPart;

public class PhysicalState {
    private Vec3d offset;
    private Vec3d rotation;

    public PhysicalState() {
        this.offset = new Vec3d();
        this.rotation = new Vec3d();
    }

    public PhysicalState(CompoundTag nbt) {
        this.offset = new Vec3d(nbt.m_128459_("oX"), nbt.m_128459_("oY"), nbt.m_128459_("oZ"));
        this.rotation = new Vec3d(nbt.m_128459_("rX"), nbt.m_128459_("rY"), nbt.m_128459_("rZ"));
    }

    public boolean isAligned() {
        return this.offset.x == 0.0 && this.offset.y == 0.0 && this.offset.z == 0.0 && this.rotation.x % 360.0 == 0.0 && this.rotation.y % 360.0 == 0.0 && this.rotation.z % 360.0 == 0.0;
    }

    public double get(PhysicalPart part) {
        return switch (part) {
            default -> throw new IncompatibleClassChangeError();
            case PhysicalPart.OFFX -> this.offset.x;
            case PhysicalPart.OFFY -> this.offset.y;
            case PhysicalPart.OFFZ -> this.offset.z;
            case PhysicalPart.ROTX -> this.rotation.x;
            case PhysicalPart.ROTY -> this.rotation.y;
            case PhysicalPart.ROTZ -> this.rotation.z;
        };
    }

    public void set(PhysicalPart part, double value) {
        switch (part) {
            case OFFX: {
                this.offset.x = value;
                break;
            }
            case OFFY: {
                this.offset.y = value;
                break;
            }
            case OFFZ: {
                this.offset.z = value;
                break;
            }
            case ROTX: {
                this.rotation.x = value;
                break;
            }
            case ROTY: {
                this.rotation.y = value;
                break;
            }
            case ROTZ: {
                this.rotation.z = value;
            }
        }
    }

    public void set(PhysicalState state) {
        this.offset.set(state.offset);
        this.rotation.set(state.rotation);
    }

    public CompoundTag save() {
        CompoundTag nbt = new CompoundTag();
        if (this.offset.x != 0.0) {
            nbt.m_128347_("oX", this.offset.x);
        }
        if (this.offset.y != 0.0) {
            nbt.m_128347_("oY", this.offset.y);
        }
        if (this.offset.z != 0.0) {
            nbt.m_128347_("oZ", this.offset.z);
        }
        if (this.rotation.x != 0.0) {
            nbt.m_128347_("rX", this.rotation.x);
        }
        if (this.rotation.y != 0.0) {
            nbt.m_128347_("rY", this.rotation.y);
        }
        if (this.rotation.z != 0.0) {
            nbt.m_128347_("rZ", this.rotation.z);
        }
        return nbt;
    }

    public double offX() {
        return this.offset.x;
    }

    public double offY() {
        return this.offset.y;
    }

    public double offZ() {
        return this.offset.z;
    }

    public double rotX() {
        return this.rotation.x;
    }

    public double rotY() {
        return this.rotation.y;
    }

    public double rotZ() {
        return this.rotation.z;
    }

    public void off(Facing facing, double value) {
        this.offset.set(facing.axis, (double)facing.offset() * value);
    }

    public void off(double x, double y, double z) {
        this.offset.x = x;
        this.offset.y = y;
        this.offset.z = z;
    }

    public void offX(double value) {
        this.offset.x = value;
    }

    public void offY(double value) {
        this.offset.y = value;
    }

    public void offZ(double value) {
        this.offset.z = value;
    }

    public void rot(double x, double y, double z) {
        this.rotation.x = x;
        this.rotation.y = y;
        this.rotation.z = z;
    }

    public void rotX(double value) {
        this.rotation.x = value;
    }

    public void rotY(double value) {
        this.rotation.y = value;
    }

    public void rotZ(double value) {
        this.rotation.z = value;
    }

    public Vec3d rotation() {
        return this.rotation.copy();
    }

    public Vec3d offset() {
        return this.offset.copy();
    }

    public double rot(Axis axis) {
        return this.rotation.get(axis);
    }

    public void rot(Axis axis, double value) {
        this.rotation.set(axis, value);
    }

    public double off(Axis axis) {
        return this.offset.get(axis);
    }

    public void off(Axis axis, double value) {
        this.offset.set(axis, value);
    }

    public void mirror(Axis axis) {
        axis.mirror(this.offset);
        axis.mirror(this.rotation);
    }

    public void rotate(Rotation rotation) {
        rotation.transform(this.offset);
        rotation.transform(this.rotation);
    }

    public String toString() {
        return "off" + this.offset + ",rot" + this.rotation;
    }

    public PhysicalState copy() {
        PhysicalState state = new PhysicalState();
        state.offset.set(this.offset);
        state.rotation.set(this.rotation);
        return state;
    }

    public void setZero() {
        this.offset.set(0.0, 0.0, 0.0);
        this.rotation.set(0.0, 0.0, 0.0);
    }
}

