/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.animation.curve;

import java.util.Iterator;
import net.minecraft.nbt.CompoundTag;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.interpolation.HermiteInterpolation;
import team.creative.creativecore.common.util.math.transformation.Rotation;
import team.creative.creativecore.common.util.math.vec.Vec1d;
import team.creative.creativecore.common.util.math.vec.Vec2d;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.math.vec.VecNd;
import team.creative.creativecore.common.util.type.list.Pair;
import team.creative.creativecore.common.util.type.list.PairList;
import team.creative.littletiles.common.structure.animation.curve.ValueCurve;

public abstract class ValueCurveInterpolation<T extends VecNd>
extends ValueCurve<T>
implements Iterable<Pair<Integer, T>> {
    protected PairList<Integer, T> points = new PairList();

    protected ValueCurveInterpolation() {
    }

    public ValueCurveInterpolation(CompoundTag nbt) {
        int[] timestamps = nbt.m_128465_("time");
        long[] data = nbt.m_128467_("data");
        int dimension = timestamps.length == data.length ? 1 : (timestamps.length * 2 == data.length ? 2 : 3);
        int j = 0;
        for (int i = 0; i < timestamps.length; ++i) {
            if (dimension == 1) {
                this.points.add((Object)timestamps[i], (Object)new Vec1d(Double.longBitsToDouble(data[j])));
            } else if (dimension == 2) {
                this.points.add((Object)timestamps[i], (Object)new Vec2d(Double.longBitsToDouble(data[j]), Double.longBitsToDouble(data[j + 1])));
            } else {
                this.points.add((Object)timestamps[i], (Object)new Vec3d(Double.longBitsToDouble(data[j]), Double.longBitsToDouble(data[j + 1]), Double.longBitsToDouble(data[j + 2])));
            }
            j += dimension;
        }
    }

    @Override
    public Iterator<Pair<Integer, T>> iterator() {
        return this.points.iterator();
    }

    public void add(int key, T vec) {
        for (int i = 0; i < this.points.size(); ++i) {
            Pair other = (Pair)this.points.get(i);
            if ((Integer)other.key == key) {
                this.points.set((Object)key, vec);
                return;
            }
            if ((Integer)other.key <= key) continue;
            this.points.add(i, new Pair((Object)key, vec));
            return;
        }
        this.points.add((Object)key, vec);
    }

    @Override
    public void start(T start, T end, int duration) {
        this.points.add(0, new Pair((Object)0, start));
        this.points.add(new Pair((Object)duration, end));
    }

    @Override
    public void end() {
        this.points.remove(0);
        this.points.remove(this.points.size() - 1);
    }

    @Override
    public T value(int tick) {
        int higher = this.points.size();
        for (int i = 0; i < this.points.size(); ++i) {
            int otherTick = (Integer)((Pair)this.points.get((int)i)).key;
            if (otherTick == tick) {
                return (T)((VecNd)((Pair)this.points.get((int)i)).value);
            }
            if (otherTick <= tick) continue;
            higher = i;
            break;
        }
        if (higher == 0 || higher == this.points.size()) {
            return (T)((VecNd)((Pair)this.points.get((int)(higher == 0 ? 0 : this.points.size() - 1))).value);
        }
        Pair before = (Pair)this.points.get(higher - 1);
        Pair after = (Pair)this.points.get(higher);
        double percentage = (double)(tick - (Integer)before.key) / (double)((Integer)after.key - (Integer)before.key);
        VecNd vec = ((VecNd)before.value).copy();
        for (int dim = 0; dim < vec.dimensions(); ++dim) {
            vec.set(dim, this.valueAt(percentage, ((VecNd)before.value).get(dim), higher - 1, ((VecNd)after.value).get(dim), higher, dim));
        }
        return (T)vec;
    }

    public abstract double valueAt(double var1, double var3, int var5, double var6, int var8, int var9);

    @Override
    public void saveExtra(CompoundTag nbt) {
        if (this.points.isEmpty()) {
            return;
        }
        int[] timestamps = new int[this.points.size()];
        int dimension = ((VecNd)this.points.getFirst().value).dimensions();
        long[] data = new long[timestamps.length * dimension];
        int j = 0;
        for (int i = 0; i < timestamps.length; ++i) {
            Pair pair = (Pair)this.points.get(i);
            timestamps[i] = (Integer)pair.key;
            if (dimension == 1) {
                data[j] = Double.doubleToRawLongBits(((Vec1d)pair.value).x);
            } else if (dimension == 2) {
                data[j] = Double.doubleToRawLongBits(((Vec2d)pair.value).x);
                data[j + 1] = Double.doubleToRawLongBits(((Vec2d)pair.value).y);
            } else if (dimension == 3) {
                data[j] = Double.doubleToRawLongBits(((Vec3d)pair.value).x);
                data[j + 1] = Double.doubleToRawLongBits(((Vec3d)pair.value).y);
                data[j + 2] = Double.doubleToRawLongBits(((Vec3d)pair.value).z);
            }
            j += dimension;
        }
        nbt.m_128385_("time", timestamps);
        nbt.m_128388_("data", data);
    }

    @Override
    public void rotate(Rotation rotation) {
        VecNd vec;
        Iterator iterator = this.points.values().iterator();
        while (iterator.hasNext() && (vec = (VecNd)iterator.next()) instanceof Vec3d) {
            rotation.transform((Vec3d)vec);
        }
    }

    @Override
    public void mirror(Axis axis) {
        if (this.points.getFirst().value instanceof Vec3d) {
            for (VecNd vec : this.points.values()) {
                axis.mirror((Vec3d)vec);
            }
        } else {
            for (VecNd vec : this.points.values()) {
                vec.invert();
            }
        }
    }

    public T getFirst() {
        return (T)((VecNd)this.points.getFirst().value);
    }

    public T getLast() {
        return (T)((VecNd)this.points.getLast().value);
    }

    public void remove(int index) {
        this.points.remove(index);
    }

    public Pair<Integer, T> getFirstPair() {
        return this.points.getFirst();
    }

    public Pair<Integer, T> getLastPair() {
        return this.points.getLast();
    }

    public int size() {
        return this.points.size();
    }

    @Override
    public void reverse(int duration) {
        PairList newPoints = new PairList();
        for (int i = this.points.size() - 1; i >= 0; --i) {
            newPoints.add((Object)(duration - (Integer)((Pair)this.points.get((int)i)).key), (Object)((VecNd)((Pair)this.points.get((int)i)).value));
        }
        this.points = newPoints;
    }

    @Override
    public boolean isEmpty() {
        return this.points.isEmpty();
    }

    public static class HermiteCurve<T extends VecNd>
    extends AdvancedValue<T> {
        public static final HermiteInterpolation.Tension TENSION = HermiteInterpolation.Tension.Normal;
        public static final double BIAS = 0.0;

        public HermiteCurve(CompoundTag nbt) {
            super(nbt);
        }

        public HermiteCurve() {
        }

        @Override
        public double valueAt(double mu, double before, int pointIndex, double after, int pointIndexNext, int dim) {
            double v0 = this.get(pointIndex - 1, dim);
            double v1 = this.get(pointIndex, dim);
            double v2 = this.get(pointIndexNext, dim);
            double v3 = this.get(pointIndexNext + 1, dim);
            double mu2 = mu * mu;
            double mu3 = mu2 * mu;
            double m0 = (v1 - v0) * 1.0 * (double)(1 - HermiteCurve.TENSION.value) / 2.0;
            m0 += (v2 - v1) * 1.0 * (double)(1 - HermiteCurve.TENSION.value) / 2.0;
            double m1 = (v2 - v1) * 1.0 * (double)(1 - HermiteCurve.TENSION.value) / 2.0;
            double a0 = 2.0 * mu3 - 3.0 * mu2 + 1.0;
            double a1 = mu3 - 2.0 * mu2 + mu;
            double a2 = mu3 - mu2;
            double a3 = -2.0 * mu3 + 3.0 * mu2;
            return a0 * v1 + a1 * m0 + a2 * (m1 += (v3 - v2) * 1.0 * (double)(1 - HermiteCurve.TENSION.value) / 2.0) + a3 * v2;
        }

        @Override
        public HermiteCurve<T> copy() {
            HermiteCurve<T> copy = new HermiteCurve<T>();
            for (Pair pair : this.points) {
                copy.points.add((Object)((Integer)pair.key), (Object)((VecNd)pair.value).copy());
            }
            return copy;
        }
    }

    public static class CubicCurve<T extends VecNd>
    extends AdvancedValue<T> {
        public CubicCurve(CompoundTag nbt) {
            super(nbt);
        }

        public CubicCurve() {
        }

        @Override
        public double valueAt(double mu, double before, int pointIndex, double after, int pointIndexNext, int dim) {
            double v0 = this.get(pointIndex - 1, dim);
            double v1 = this.get(pointIndex, dim);
            double v2 = this.get(pointIndexNext, dim);
            double v3 = this.get(pointIndexNext + 1, dim);
            double mu2 = mu * mu;
            double a0 = v3 - v2 - v0 + v1;
            double a1 = v0 - v1 - a0;
            double a2 = v2 - v0;
            double a3 = v1;
            return a0 * mu * mu2 + a1 * mu2 + a2 * mu + a3;
        }

        @Override
        public CubicCurve<T> copy() {
            CubicCurve<T> copy = new CubicCurve<T>();
            for (Pair pair : this.points) {
                copy.points.add((Object)((Integer)pair.key), (Object)((VecNd)pair.value).copy());
            }
            return copy;
        }
    }

    public static abstract class AdvancedValue<T extends VecNd>
    extends ValueCurveInterpolation<T> {
        public AdvancedValue(CompoundTag nbt) {
            super(nbt);
        }

        public AdvancedValue() {
        }

        protected double get(int index, int dim) {
            if (index < 0) {
                return ((VecNd)this.points.getFirst().value).get(dim);
            }
            if (index >= this.points.size()) {
                return ((VecNd)this.points.getLast().value).get(dim);
            }
            return ((VecNd)((Pair)this.points.get((int)index)).value).get(dim);
        }
    }

    public static class CosineCurve<T extends VecNd>
    extends ValueCurveInterpolation<T> {
        public CosineCurve(CompoundTag nbt) {
            super(nbt);
        }

        public CosineCurve() {
        }

        @Override
        public double valueAt(double mu, double before, int pointIndex, double after, int pointIndexNext, int dim) {
            double mu2 = (1.0 - Math.cos(mu * Math.PI)) / 2.0;
            return before * (1.0 - mu2) + after * mu2;
        }

        @Override
        public CosineCurve<T> copy() {
            CosineCurve<T> copy = new CosineCurve<T>();
            for (Pair pair : this.points) {
                copy.points.add((Object)((Integer)pair.key), (Object)((VecNd)pair.value).copy());
            }
            return copy;
        }
    }

    public static class LinearCurve<T extends VecNd>
    extends ValueCurveInterpolation<T> {
        public LinearCurve(CompoundTag nbt) {
            super(nbt);
        }

        public LinearCurve() {
        }

        @Override
        public double valueAt(double mu, double before, int pointIndex, double after, int pointIndexNext, int dim) {
            return (after - before) * mu + before;
        }

        @Override
        public LinearCurve<T> copy() {
            LinearCurve<T> copy = new LinearCurve<T>();
            for (Pair pair : this.points) {
                copy.points.add((Object)((Integer)pair.key), (Object)((VecNd)pair.value).copy());
            }
            return copy;
        }
    }
}

