/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.animation.event;

import net.minecraft.nbt.IntTag;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.animation.context.AnimationContext;
import team.creative.littletiles.common.structure.animation.event.AnimationEvent;
import team.creative.littletiles.common.structure.type.animation.LittleDoor;

public class ChildDoorEvent
extends AnimationEvent<IntTag> {
    public final int childId;

    public ChildDoorEvent(IntTag tag) {
        this.childId = tag.m_7047_();
    }

    public ChildDoorEvent(int childId) {
        this.childId = childId;
    }

    @Override
    public IntTag save() {
        return IntTag.m_128679_((int)this.childId);
    }

    @Override
    public void start(AnimationContext context) {
        if (context.isGui() || context.isClient()) {
            return;
        }
        LittleDoor door = this.getDoor(context);
        if (door == null || door.isChanging()) {
            return;
        }
        door.toggleState();
    }

    @Override
    public boolean isDone(int ticksActive, AnimationContext context) {
        LittleDoor door = this.getDoor(context);
        if (door == null) {
            return true;
        }
        return !door.isChanging();
    }

    public LittleDoor getDoor(AnimationContext context) {
        LittleStructure structure = context.getChildStructure(this.childId);
        if (structure instanceof LittleDoor) {
            LittleDoor door = (LittleDoor)structure;
            return door;
        }
        return null;
    }

    public ChildDoorEvent copy() {
        return new ChildDoorEvent(this.childId);
    }

    @Override
    public int reverseTick(int start, int duration, AnimationContext context) {
        LittleDoor door = this.getDoor(context);
        if (door == null) {
            return start;
        }
        return duration - (start + door.duration);
    }
}

