/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.signal.component;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.LittleStructureType;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;
import team.creative.littletiles.common.structure.signal.SignalState;
import team.creative.littletiles.common.structure.signal.component.ISignalComponent;

public abstract class InternalSignal<T extends LittleStructureType.InternalComponent>
implements ISignalComponent {
    public final LittleStructure parent;
    public final T component;
    private SignalState state;

    public InternalSignal(LittleStructure parent, T component) {
        this.parent = parent;
        this.component = component;
        this.state = SignalState.create(((LittleStructureType.InternalComponent)component).bandwidth);
    }

    public abstract void load(CompoundTag var1);

    @Override
    public SignalState getState() {
        return this.state;
    }

    protected void overwrite(SignalState state) {
        this.state = state;
    }

    @Override
    public void overwriteState(SignalState state) throws CorruptedConnectionException, NotYetConnectedException {
        this.state = this.state.overwrite(state);
        this.state.shrinkTo(this.getBandwidth());
    }

    public abstract CompoundTag save(boolean var1, CompoundTag var2);

    @Override
    public int getBandwidth() {
        return ((LittleStructureType.InternalComponent)this.component).bandwidth;
    }

    @Override
    public LittleStructure getStructure() {
        return this.parent;
    }

    @Override
    public Level getStructureLevel() {
        if (this.parent.mainBlock != null) {
            return this.parent.getLevel();
        }
        return null;
    }

    public String toString() {
        return ((LittleStructureType.InternalComponent)this.component).identifier;
    }
}

