/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.signal.logic;

import java.text.ParseException;
import java.util.Iterator;
import team.creative.creativecore.common.util.type.itr.ArrayIterator;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.signal.SignalState;
import team.creative.littletiles.common.structure.signal.input.SignalInputCondition;
import team.creative.littletiles.common.structure.signal.logic.SignalPatternParser;
import team.creative.littletiles.common.structure.signal.logic.SignalTarget;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum SignalLogicOperator {
    AND('\n', false, "and", ""){

        @Override
        public SignalLogicOperator lower() {
            return null;
        }

        @Override
        public boolean perform(boolean first, boolean second) {
            return first && second;
        }

        @Override
        public int perform(int first, int second) {
            return first & second;
        }

        @Override
        public long perform(long first, long second) {
            return first & second;
        }

        @Override
        public SignalInputCondition create(SignalInputCondition[] conditions) {
            return new SignalInputConditionOperatorStackable(conditions){

                @Override
                public SignalLogicOperator operator() {
                    return AND;
                }

                @Override
                public boolean needsBrackets() {
                    return false;
                }

                @Override
                public float getModifier() {
                    return 0.1f;
                }
            };
        }
    }
    ,
    OR('+', false, "or"){

        @Override
        public SignalLogicOperator lower() {
            return AND;
        }

        @Override
        public boolean perform(boolean first, boolean second) {
            return first || second;
        }

        @Override
        public int perform(int first, int second) {
            return first | second;
        }

        @Override
        public long perform(long first, long second) {
            return first | second;
        }

        @Override
        public SignalInputCondition create(SignalInputCondition[] conditions) {
            return new SignalInputConditionOperatorStackable(conditions){

                @Override
                public SignalLogicOperator operator() {
                    return OR;
                }

                @Override
                public boolean needsBrackets() {
                    return true;
                }

                @Override
                public float getModifier() {
                    return 0.01f;
                }
            };
        }
    }
    ,
    XOR('V', false, "xor"){

        @Override
        public SignalLogicOperator lower() {
            return OR;
        }

        @Override
        public boolean perform(boolean first, boolean second) {
            return first ^ second;
        }

        @Override
        public int perform(int first, int second) {
            return first ^ second;
        }

        @Override
        public long perform(long first, long second) {
            return first ^ second;
        }

        @Override
        public SignalInputCondition create(SignalInputCondition[] conditions) {
            return new SignalInputConditionOperatorStackable(conditions){

                @Override
                public SignalLogicOperator operator() {
                    return XOR;
                }

                @Override
                public boolean needsBrackets() {
                    return true;
                }

                @Override
                public float getModifier() {
                    return 0.2f;
                }
            };
        }
    }
    ,
    BITWISE_AND('&', true, "b-and"){

        @Override
        public SignalLogicOperator lower() {
            return XOR;
        }

        @Override
        public boolean perform(boolean first, boolean second) {
            return first && second;
        }

        @Override
        public int perform(int first, int second) {
            return first & second;
        }

        @Override
        public long perform(long first, long second) {
            return first & second;
        }

        @Override
        public SignalInputCondition create(SignalInputCondition[] conditions) {
            return new SignalInputConditionOperatorStackableBitwise(conditions){

                @Override
                public SignalLogicOperator operator() {
                    return BITWISE_AND;
                }

                @Override
                public float getModifier() {
                    return 0.2f;
                }
            };
        }
    }
    ,
    BITWISE_OR('|', true, "b-or"){

        @Override
        public SignalLogicOperator lower() {
            return BITWISE_AND;
        }

        @Override
        public boolean perform(boolean first, boolean second) {
            return first || second;
        }

        @Override
        public int perform(int first, int second) {
            return first | second;
        }

        @Override
        public long perform(long first, long second) {
            return first | second;
        }

        @Override
        public SignalInputCondition create(SignalInputCondition[] conditions) {
            return new SignalInputConditionOperatorStackableBitwise(conditions){

                @Override
                public SignalLogicOperator operator() {
                    return BITWISE_OR;
                }

                @Override
                public float getModifier() {
                    return 0.02f;
                }
            };
        }
    }
    ,
    BITWISE_XOR('^', true, "b-xor"){

        @Override
        public SignalLogicOperator lower() {
            return BITWISE_OR;
        }

        @Override
        public boolean perform(boolean first, boolean second) {
            return first ^ second;
        }

        @Override
        public int perform(int first, int second) {
            return first ^ second;
        }

        @Override
        public long perform(long first, long second) {
            return first ^ second;
        }

        @Override
        public SignalInputCondition create(SignalInputCondition[] conditions) {
            return new SignalInputConditionOperatorStackableBitwise(conditions){

                @Override
                public SignalLogicOperator operator() {
                    return BITWISE_XOR;
                }

                @Override
                public float getModifier() {
                    return 0.4f;
                }
            };
        }
    }
    ,
    ADD('#', true, "add"){

        @Override
        public SignalLogicOperator lower() {
            return BITWISE_XOR;
        }

        @Override
        public boolean perform(boolean first, boolean second) {
            return first | second;
        }

        @Override
        public int perform(int first, int second) {
            return first + second;
        }

        @Override
        public long perform(long first, long second) {
            return first + second;
        }

        @Override
        public SignalInputCondition create(SignalInputCondition[] conditions) {
            return new SignalInputConditionOperatorStackableMath(conditions){

                @Override
                public SignalLogicOperator operator() {
                    return ADD;
                }

                @Override
                public float getModifier() {
                    return 0.5f;
                }
            };
        }
    }
    ,
    SUB('-', true, "sub"){

        @Override
        public SignalLogicOperator lower() {
            return ADD;
        }

        @Override
        public boolean perform(boolean first, boolean second) {
            return first && !second;
        }

        @Override
        public int perform(int first, int second) {
            return first - second;
        }

        @Override
        public long perform(long first, long second) {
            return first - second;
        }

        @Override
        public SignalInputCondition create(SignalInputCondition[] conditions) {
            return new SignalInputConditionOperatorStackableMath(conditions){

                @Override
                public SignalLogicOperator operator() {
                    return SUB;
                }

                @Override
                public float getModifier() {
                    return 0.5f;
                }
            };
        }
    }
    ,
    MUL('*', true, "mul"){

        @Override
        public SignalLogicOperator lower() {
            return SUB;
        }

        @Override
        public boolean perform(boolean first, boolean second) {
            return first && second;
        }

        @Override
        public int perform(int first, int second) {
            return first * second;
        }

        @Override
        public long perform(long first, long second) {
            return first * second;
        }

        @Override
        public SignalInputCondition create(SignalInputCondition[] conditions) {
            return new SignalInputConditionOperatorStackableMath(conditions){

                @Override
                public SignalLogicOperator operator() {
                    return MUL;
                }

                @Override
                public float getModifier() {
                    return 0.5f;
                }
            };
        }
    }
    ,
    DIV('/', true, "div"){

        @Override
        public SignalLogicOperator lower() {
            return MUL;
        }

        @Override
        public boolean perform(boolean first, boolean second) {
            return first && !second;
        }

        @Override
        public int perform(int first, int second) {
            try {
                return first / second;
            }
            catch (ArithmeticException e) {
                if (second == 0 && first != 0) {
                    return 1;
                }
                return 0;
            }
        }

        @Override
        public long perform(long first, long second) {
            try {
                return first / second;
            }
            catch (ArithmeticException e) {
                if (second == 0L && first != 0L) {
                    return 1L;
                }
                return 0L;
            }
        }

        @Override
        public SignalInputCondition create(SignalInputCondition[] conditions) {
            return new SignalInputConditionOperatorStackableMath(conditions){

                @Override
                public SignalLogicOperator operator() {
                    return DIV;
                }

                @Override
                public float getModifier() {
                    return 5.0f;
                }
            };
        }
    };

    public static final SignalLogicOperator HIGHEST_GENERAL;
    public static final SignalLogicOperator HIGHEST;
    public final char operator;
    public final boolean bitwise;
    public final String display;
    public final String seperator;

    public static SignalLogicOperator getHighest(boolean includeBitwise) {
        if (includeBitwise) {
            return HIGHEST;
        }
        return HIGHEST_GENERAL;
    }

    public static SignalLogicOperator getOperator(char character) {
        switch (character) {
            case '&': {
                return BITWISE_AND;
            }
            case '+': {
                return OR;
            }
            case '|': {
                return BITWISE_OR;
            }
            case 'V': {
                return XOR;
            }
            case '^': {
                return BITWISE_XOR;
            }
            case '#': {
                return ADD;
            }
            case '-': {
                return SUB;
            }
            case '*': {
                return MUL;
            }
            case '/': {
                return DIV;
            }
        }
        return null;
    }

    private SignalLogicOperator(char operator, boolean bitwise, String display) {
        this(operator, bitwise, display, "" + operator);
    }

    private SignalLogicOperator(char operator, boolean bitwise, String display, String seperator) {
        this.operator = operator;
        this.bitwise = bitwise;
        this.display = display;
        this.seperator = seperator;
    }

    public abstract SignalLogicOperator lower();

    public boolean goOn(SignalPatternParser parser) throws ParseException {
        if (parser.hasNext()) {
            if (this == AND) {
                char next = parser.lookForNext(true);
                return next == '(' || next == '!' || next <= 'z' & next >= 'a';
            }
            if (parser.lookForNext(true) == this.operator) {
                parser.next(true);
                return true;
            }
        }
        return false;
    }

    public abstract boolean perform(boolean var1, boolean var2);

    public abstract int perform(int var1, int var2);

    public abstract long perform(long var1, long var3);

    public abstract SignalInputCondition create(SignalInputCondition[] var1);

    static {
        HIGHEST_GENERAL = XOR;
        HIGHEST = DIV;
    }

    public static abstract class SignalInputConditionOperatorStackableMath
    extends SignalInputConditionOperatorStackable {
        public SignalInputConditionOperatorStackableMath(SignalInputCondition[] conditions) {
            super(conditions);
        }

        @Override
        public SignalState test(LittleStructure structure) {
            SignalState[] state = new SignalState[this.conditions.length];
            SignalState.SignalStateSize size = SignalState.SignalStateSize.SINGLE;
            for (int i = 0; i < this.conditions.length; ++i) {
                state[i] = this.conditions[i].test(structure, true);
                size = size.max(state[i].size());
            }
            SignalState result = size.create();
            switch (size) {
                case SINGLE: {
                    for (int i = 0; i < state.length; ++i) {
                        result = i == 0 ? result.set(0, state[i].any()) : result.set(0, this.operator().perform(result.any(), state[i].any()));
                    }
                    break;
                }
                case INT: {
                    for (int i = 0; i < state.length; ++i) {
                        result = i == 0 ? result.setNumber(state[i].number()) : result.setNumber(this.operator().perform(result.number(), state[i].number()));
                    }
                    break;
                }
                case LONG: {
                    for (int i = 0; i < state.length; ++i) {
                        result = i == 0 ? result.setLongNumber(state[i].longNumber()) : result.setLongNumber(this.operator().perform(result.longNumber(), state[i].longNumber()));
                    }
                    break;
                }
            }
            return result;
        }

        @Override
        public boolean needsBrackets() {
            return true;
        }
    }

    public static abstract class SignalInputConditionOperatorStackableBitwise
    extends SignalInputConditionOperatorStackable {
        public SignalInputConditionOperatorStackableBitwise(SignalInputCondition[] conditions) {
            super(conditions);
        }

        @Override
        public SignalState test(LittleStructure structure) {
            SignalState[] state = new SignalState[this.conditions.length];
            SignalState.SignalStateSize size = SignalState.SignalStateSize.SINGLE;
            for (int i = 0; i < this.conditions.length; ++i) {
                state[i] = this.conditions[i].test(structure, true);
                size = size.max(state[i].size());
            }
            SignalState result = size.create();
            block6: for (int i = 0; i < state.length; ++i) {
                switch (size) {
                    case SINGLE: {
                        result = result.set(0, this.operator().perform(result.any(), state[i].any()));
                        continue block6;
                    }
                    case INT: {
                        result = result.setNumber(this.operator().perform(result.number(), state[i].number()));
                        continue block6;
                    }
                    case LONG: {
                        result = result.setLongNumber(this.operator().perform(result.longNumber(), state[i].longNumber()));
                    }
                }
            }
            return result;
        }

        @Override
        public boolean needsBrackets() {
            return true;
        }
    }

    public static abstract class SignalInputConditionOperatorStackable
    extends SignalInputCondition.SignalInputConditionOperator {
        public SignalInputCondition[] conditions;

        public SignalInputConditionOperatorStackable(SignalInputCondition[] conditions) {
            this.conditions = conditions;
        }

        @Override
        public SignalState test(LittleStructure structure) {
            SignalState[] state = new SignalState[this.conditions.length];
            SignalState.SignalStateSize size = SignalState.SignalStateSize.SINGLE;
            for (int i = 0; i < this.conditions.length; ++i) {
                state[i] = this.conditions[i].test(structure, false);
                size = size.max(state[i].size());
            }
            SignalState result = size.create();
            block6: for (int i = 0; i < state.length; ++i) {
                switch (size) {
                    case SINGLE: {
                        result = result.set(0, this.operator().perform(result.any(), state[i].any()));
                        continue block6;
                    }
                    case INT: {
                        result = result.setNumber(this.operator().perform(result.number(), state[i].size() == SignalState.SignalStateSize.SINGLE ? -1 : state[i].number()));
                        continue block6;
                    }
                    case LONG: {
                        result = result.setLongNumber(this.operator().perform(result.longNumber(), state[i].size() == SignalState.SignalStateSize.SINGLE ? -1L : state[i].longNumber()));
                    }
                }
            }
            return result;
        }

        @Override
        public boolean testIndex(SignalState state) {
            boolean result = false;
            for (int i = 0; i < this.conditions.length; ++i) {
                result = i == 0 ? this.conditions[i].testIndex(state) : this.operator().perform(result, this.conditions[i].testIndex(state));
            }
            return result;
        }

        public abstract boolean needsBrackets();

        public abstract SignalLogicOperator operator();

        @Override
        public String write() {
            if (this.needsBrackets()) {
                Object result = "(";
                for (int i = 0; i < this.conditions.length; ++i) {
                    if (i > 0) {
                        result = (String)result + this.operator().seperator;
                    }
                    result = (String)result + this.conditions[i].write();
                }
                return (String)result + ")";
            }
            Object result = "";
            for (int i = 0; i < this.conditions.length; ++i) {
                if (i > 0) {
                    result = (String)result + this.operator().seperator;
                }
                result = (String)result + this.conditions[i].write();
            }
            return result;
        }

        @Override
        public float calculateDelay() {
            float delay = (float)this.conditions.length * this.getModifier();
            for (SignalInputCondition condition : this.conditions) {
                delay += condition.calculateDelay();
            }
            return delay;
        }

        public abstract float getModifier();

        @Override
        public Iterator<SignalInputCondition> nested() {
            return new ArrayIterator((Object[])this.conditions);
        }

        @Override
        public SignalTarget target() {
            return null;
        }
    }
}

