/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.type.animation;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import team.creative.littletiles.common.block.little.tile.LittleTileContext;
import team.creative.littletiles.common.block.little.tile.parent.IStructureParentCollection;
import team.creative.littletiles.common.structure.LittleStructureType;
import team.creative.littletiles.common.structure.animation.AnimationState;
import team.creative.littletiles.common.structure.animation.AnimationTimeline;
import team.creative.littletiles.common.structure.animation.AnimationTransition;
import team.creative.littletiles.common.structure.directional.StructureDirectional;
import team.creative.littletiles.common.structure.signal.output.InternalSignalOutput;
import team.creative.littletiles.common.structure.type.animation.LittleStateStructure;

public abstract class LittleUndirectedStateStructure
extends LittleStateStructure<AnimationState> {
    private static final AnimationState EMPTY = new AnimationState("");
    @StructureDirectional
    private List<AnimationTransition> transitions = new ArrayList<AnimationTransition>();

    public LittleUndirectedStateStructure(LittleStateStructure.LittleStateStructureType type, IStructureParentCollection mainBlock) {
        super(type, mainBlock);
    }

    @Override
    protected void loadExtra(CompoundTag nbt) {
        super.loadExtra(nbt);
        ListTag transitionList = nbt.m_128437_("t", 10);
        this.transitions = new ArrayList<AnimationTransition>(transitionList.size());
        for (int i = 0; i < transitionList.size(); ++i) {
            this.transitions.add(new AnimationTransition(transitionList.m_128728_(i)));
        }
    }

    @Override
    protected void saveExtra(CompoundTag nbt) {
        super.saveExtra(nbt);
        ListTag transitionList = new ListTag();
        for (int i = 0; i < this.transitions.size(); ++i) {
            transitionList.add((Object)this.transitions.get(i).save());
        }
        nbt.m_128365_("t", (Tag)transitionList);
    }

    @Override
    protected AnimationState createState(CompoundTag nbt) {
        return new AnimationState(nbt);
    }

    @Override
    protected AnimationState getEmptyState() {
        return EMPTY;
    }

    @Override
    protected boolean shouldStayAnimatedAfterTransitionEnd() {
        return this.startTransitionIfNecessary(this.getOutput(0));
    }

    public void putTransition(AnimationState start, AnimationState end, String name, AnimationTimeline timeline) {
        this.putTransition(start.name, end.name, name, timeline);
    }

    public void putTransition(String start, String end, String name, AnimationTimeline timeline) {
        this.putTransition(this.indexOfState(start), this.indexOfState(end), name, timeline);
    }

    public void putTransition(int start, int end, String name, AnimationTimeline timeline) {
        if (!this.hasState(start) || !this.hasState(end)) {
            return;
        }
        this.transitions.add(new AnimationTransition(name, start, end, timeline));
    }

    public AnimationTimeline getTransition(String start, String end) {
        return this.getTransition(this.indexOfState(start), this.indexOfState(end));
    }

    public AnimationTimeline getTransition(String name) {
        for (AnimationTransition transition : this.transitions) {
            if (!transition.name.equals(name)) continue;
            return transition.timeline;
        }
        return null;
    }

    public AnimationTimeline getTransition(int start, int end) {
        for (AnimationTransition transition : this.transitions) {
            if (transition.start != start || transition.end != end) continue;
            return transition.timeline;
        }
        return null;
    }

    protected boolean startTransitionIfNecessary(InternalSignalOutput output) {
        return this.startTransitionIfNecessary(output.getState().number());
    }

    protected boolean startTransitionIfNecessary(int aimed) {
        if (!this.isChanging() && this.hasState(aimed) && aimed != this.currentIndex()) {
            this.startTransition(this.currentIndex(), aimed, this.getTransition(this.currentIndex(), aimed));
            return true;
        }
        return false;
    }

    @Override
    public void performInternalOutputChange(InternalSignalOutput output) {
        if (((LittleStructureType.InternalComponentOutput)output.component).is("state")) {
            this.startTransitionIfNecessary(output);
        }
    }

    @Override
    public boolean canInteract() {
        return this.canRightClick();
    }

    @Override
    public InteractionResult use(Level level, LittleTileContext context, BlockPos pos, Player player, BlockHitResult result) {
        if (this.canRightClick()) {
            if (!this.isClient()) {
                this.getOutput(0).toggle();
            }
            return InteractionResult.SUCCESS;
        }
        return super.use(level, context, pos, player, result);
    }
}

