/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.mixin.server.level;

import com.mojang.datafixers.DataFixer;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import team.creative.creativecore.common.util.math.box.AABBVoxelShape;
import team.creative.littletiles.server.level.little.LittleServerChunkCache;
import team.creative.littletiles.server.level.little.LittleServerLevel;

@Mixin(value={ServerLevel.class})
public abstract class ServerLevelMixin
extends Level {
    protected ServerLevelMixin(WritableLevelData data, ResourceKey<Level> key, RegistryAccess access, Holder<DimensionType> dim, Supplier<ProfilerFiller> prof, boolean p_220356_, boolean p_220357_, long p_220358_, int p_220359_) {
        super(data, key, access, dim, prof, p_220356_, p_220357_, p_220358_, p_220359_);
    }

    @Redirect(at=@At(value="NEW", target="net/minecraft/server/level/ServerChunkCache"), method={"<init>"}, require=1)
    public ServerChunkCache newServerChunkCache(ServerLevel level, LevelStorageSource.LevelStorageAccess storageAccess, DataFixer dataFixer, StructureTemplateManager structureTemplate, Executor exe, ChunkGenerator generator, int viewDistance, int simulationDistance, boolean sync, ChunkProgressListener progress, ChunkStatusUpdateListener status, Supplier<DimensionDataStorage> supplier) {
        if (level instanceof LittleServerLevel) {
            return new LittleServerChunkCache((LittleServerLevel)level, storageAccess, dataFixer, structureTemplate, exe, generator, viewDistance, simulationDistance, sync, progress, status, supplier);
        }
        return new ServerChunkCache(level, storageAccess, dataFixer, structureTemplate, exe, generator, viewDistance, simulationDistance, sync, progress, status, supplier);
    }

    @Unique
    private ServerLevel as() {
        return (ServerLevel)this;
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/ChunkGeneratorStructureState;ensureStructuresGenerated()V"), method={"<init>"}, require=1)
    public void callEnsureStructuresGenerated(ChunkGeneratorStructureState state) {
        if (this.as() instanceof LittleServerLevel) {
            return;
        }
        state.m_254958_();
    }

    public boolean m_45756_(@Nullable Entity entity, AABB bb) {
        for (VoxelShape voxelshape : this.m_186434_(entity, bb)) {
            if (voxelshape instanceof AABBVoxelShape || voxelshape.m_83281_()) continue;
            return false;
        }
        if (!this.m_183134_(entity, bb).isEmpty()) {
            return false;
        }
        if (entity == null) {
            return true;
        }
        VoxelShape voxelshape1 = this.m_186440_(entity, bb);
        return voxelshape1 == null || !Shapes.m_83157_((VoxelShape)voxelshape1, (VoxelShape)Shapes.m_83064_((AABB)bb), (BooleanOp)BooleanOp.f_82689_);
    }

    public VoxelShape m_186440_(Entity entity, AABB bb) {
        WorldBorder worldborder = this.m_6857_();
        return worldborder.m_187566_(entity, bb) ? worldborder.m_61946_() : null;
    }
}

