/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.server.level.handler;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.client.action.ActionEvent;
import team.creative.littletiles.common.action.LittleAction;
import team.creative.littletiles.common.action.LittleActionException;
import team.creative.littletiles.common.packet.action.ActionMessagePacket;

public class LittleActionHandlerServer {
    public static void handleException(ServerPlayer player, LittleActionException e) {
        if (e.isHidden()) {
            return;
        }
        List<Component> message = e.getActionMessage();
        if (message != null) {
            LittleTiles.NETWORK.sendToClient((CreativePacket)new ActionMessagePacket(message), player);
        } else {
            player.m_213846_((Component)Component.m_237113_((String)e.getLocalizedMessage()));
        }
    }

    public static <T> T execute(ServerPlayer player, LittleAction<T> action) {
        try {
            T result = action.action((Player)player);
            if (action.wasSuccessful(result)) {
                MinecraftForge.EVENT_BUS.post((Event)new ActionEvent(action, ActionEvent.ActionType.normal, (Player)player));
                return result;
            }
        }
        catch (LittleActionException e) {
            LittleActionHandlerServer.handleException(player, e);
        }
        return action.failed();
    }
}

