/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.server.level.little;

import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Either;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelStorageSource;
import team.creative.creativecore.common.util.type.itr.FunctionIterator;
import team.creative.littletiles.mixin.server.level.ServerChunkCacheAccessor;
import team.creative.littletiles.server.level.little.LittleChunkHolder;
import team.creative.littletiles.server.level.little.LittleChunkMap;
import team.creative.littletiles.server.level.little.LittleDistanceManager;
import team.creative.littletiles.server.level.little.LittleServerLevel;

public class LittleServerChunkCache
extends ServerChunkCache
implements Iterable<LevelChunk> {
    private final HashMap<Long, LittleChunkHolder> chunks = new HashMap();
    private final MainThreadExecutor mainThreadProcessor;

    public LittleServerChunkCache(LittleServerLevel level, LevelStorageSource.LevelStorageAccess storageAccess, DataFixer dataFixer, StructureTemplateManager structureTemplate, Executor exe, ChunkGenerator generator, int viewDistance, int simulationDistance, boolean sync, ChunkProgressListener progress, ChunkStatusUpdateListener status, Supplier<DimensionDataStorage> supplier) {
        super((ServerLevel)level, storageAccess, dataFixer, structureTemplate, exe, generator, viewDistance, simulationDistance, sync, progress, status, supplier);
        this.mainThreadProcessor = new MainThreadExecutor((Level)level);
    }

    public int m_8427_() {
        return this.f_8325_.m_140368_();
    }

    private Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure> getChunkMainThread(int x, int z, boolean create) {
        LittleChunkHolder holder = this.chunks.get(ChunkPos.m_45589_((int)x, (int)z));
        if (holder == null && create) {
            holder = ((LittleChunkMap)this.f_8325_).createHolder(new ChunkPos(x, z));
            this.chunks.put(ChunkPos.m_45589_((int)x, (int)z), holder);
        }
        return Either.left((Object)holder.chunk);
    }

    @Nullable
    public ChunkAccess m_7587_(int x, int z, ChunkStatus status, boolean create) {
        if (Thread.currentThread() != ((ServerChunkCacheAccessor)((Object)this)).getMainThread()) {
            return CompletableFuture.supplyAsync(() -> this.m_7587_(x, z, status, create), (Executor)((Object)this.mainThreadProcessor)).join();
        }
        LittleChunkHolder holder = this.chunks.get(ChunkPos.m_45589_((int)x, (int)z));
        if (holder == null && create) {
            holder = ((LittleChunkMap)this.f_8325_).createHolder(new ChunkPos(x, z));
            this.chunks.put(ChunkPos.m_45589_((int)x, (int)z), holder);
        }
        return holder == null ? null : holder.chunk;
    }

    @Nullable
    public LevelChunk m_7131_(int x, int z) {
        if (Thread.currentThread() != ((ServerChunkCacheAccessor)((Object)this)).getMainThread()) {
            return null;
        }
        return this.m_62227_(x, z, true);
    }

    public CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>> m_8431_(int x, int z, ChunkStatus status, boolean create) {
        CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>> completablefuture;
        if (Thread.currentThread() == ((ServerChunkCacheAccessor)((Object)this)).getMainThread()) {
            completablefuture = CompletableFuture.supplyAsync(() -> this.getChunkMainThread(x, z, create));
            this.mainThreadProcessor.m_18701_(completablefuture::isDone);
        } else {
            completablefuture = CompletableFuture.supplyAsync(() -> this.getChunkMainThread(x, z, create), (Executor)((Object)this.mainThreadProcessor));
        }
        return completablefuture;
    }

    public boolean m_5563_(int x, int z) {
        return this.chunks.containsKey(ChunkPos.m_45589_((int)x, (int)z));
    }

    public BlockGetter m_6196_(int x, int z) {
        return this.m_7587_(x, z, ChunkStatus.f_62314_, false);
    }

    public boolean m_8466_() {
        return this.mainThreadProcessor.m_7245_();
    }

    public boolean m_143239_(long pos) {
        if (!this.f_8329_.m_183438_(pos)) {
            return false;
        }
        return this.chunks.containsKey(pos);
    }

    public void m_8419_(boolean all) {
    }

    public void close() throws IOException {
    }

    public void m_201698_(BooleanSupplier running, boolean chunks) {
        this.f_8329_.m_46473_().m_6180_("purge");
        ((LittleDistanceManager)this.f_8325_.m_143145_()).m_140776_();
        this.runDistanceManagerUpdates2();
        this.f_8329_.m_46473_().m_6182_("chunks");
        if (chunks) {
            this.tickChunks();
        }
        this.f_8329_.m_46473_().m_7238_();
    }

    private void tickChunks() {
        if (this.f_8329_.m_46659_()) {
            ((LittleChunkMap)this.f_8325_).m_140421_();
            return;
        }
        ProfilerFiller profilerfiller = this.f_8329_.m_46473_();
        profilerfiller.m_6180_("pollingChunks");
        int k = this.f_8329_.m_46469_().m_46215_(GameRules.f_46143_);
        profilerfiller.m_6182_("tick");
        for (Map.Entry<Long, LittleChunkHolder> entry : this.chunks.entrySet()) {
            if (!this.f_8329_.m_183438_(entry.getKey().longValue())) continue;
            this.f_8329_.m_8714_(entry.getValue().chunk, k);
        }
        for (LittleChunkHolder holder : this.chunks.values()) {
            holder.broadcastChanges();
        }
        profilerfiller.m_7238_();
        ((LittleChunkMap)this.f_8325_).m_140421_();
    }

    public int m_8480_() {
        return this.mainThreadProcessor.m_18696_();
    }

    public ChunkGenerator m_8481_() {
        return null;
    }

    public RandomState m_214994_() {
        return null;
    }

    public int m_8482_() {
        return this.chunks.size();
    }

    public void m_8450_(BlockPos pos) {
        LittleChunkHolder chunkholder = this.chunks.get(ChunkPos.m_151388_((BlockPos)pos));
        if (chunkholder != null) {
            chunkholder.blockChanged(pos);
        }
    }

    public void m_6506_(LightLayer layer, SectionPos pos) {
        this.mainThreadProcessor.execute(() -> {
            LittleChunkHolder chunkholder = this.chunks.get(ChunkPos.m_45589_((int)pos.m_123170_(), (int)pos.m_123222_()));
            if (chunkholder != null) {
                chunkholder.sectionLightChanged(layer, pos.m_123206_());
            }
        });
    }

    public <T> void m_8387_(TicketType<T> type, ChunkPos pos, int level, T key) {
        this.f_8325_.m_143145_().m_140840_(type, pos, level, key);
    }

    public <T> void addRegionTicket(TicketType<T> type, ChunkPos pos, int level, T key, boolean forceTicks) {
        this.f_8325_.m_143145_().addRegionTicket(type, pos, level, key, forceTicks);
    }

    public <T> void m_8438_(TicketType<T> type, ChunkPos pos, int level, T key) {
        this.f_8325_.m_143145_().m_140849_(type, pos, level, key);
    }

    public <T> void removeRegionTicket(TicketType<T> type, ChunkPos pos, int level, T key, boolean forceTicks) {
        this.f_8325_.m_143145_().removeRegionTicket(type, pos, level, key, forceTicks);
    }

    public void m_6692_(ChunkPos pos, boolean added) {
        ((LittleDistanceManager)this.f_8325_.m_143145_()).m_140799_(pos, added);
    }

    public void m_8385_(ServerPlayer player) {
        ((LittleChunkMap)this.f_8325_).m_140184_(player);
    }

    public void m_8443_(Entity entity) {
        ((LittleChunkMap)this.f_8325_).m_140331_(entity);
    }

    public void m_8463_(Entity entity) {
        ((LittleChunkMap)this.f_8325_).m_140199_(entity);
    }

    public void m_8394_(Entity entity, Packet<?> packet) {
        ((LittleChunkMap)this.f_8325_).m_140333_(entity, packet);
    }

    public void m_8445_(Entity entity, Packet<?> packet) {
        ((LittleChunkMap)this.f_8325_).m_140201_(entity, packet);
    }

    public void m_8354_(int distance) {
    }

    public void m_184026_(int distance) {
    }

    public void m_6707_(boolean spawnEnemies, boolean spawnFriendlies) {
    }

    public String m_8448_(ChunkPos pos) {
        return "";
    }

    public ChunkScanAccess m_196555_() {
        return this.f_8325_.m_196922_();
    }

    @Nullable
    @VisibleForDebug
    public NaturalSpawner.SpawnState m_8485_() {
        return null;
    }

    public void m_201915_() {
        this.f_8325_.m_143145_().m_201910_();
    }

    public void loadLevelChunk(ChunkPos pos, CompoundTag tag) {
        this.chunks.put(pos.m_45588_(), ((LittleChunkMap)this.f_8325_).createHolder(pos, tag));
    }

    public Iterable<LevelChunk> all() {
        return this;
    }

    @Override
    public Iterator<LevelChunk> iterator() {
        return new FunctionIterator(this.chunks.values().iterator(), x -> x.chunk);
    }

    public boolean runDistanceManagerUpdates2() {
        this.f_8325_.m_143145_().m_140805_(this.f_8325_);
        return false;
    }

    public ChunkGeneratorStructureState m_255415_() {
        return null;
    }

    public final class MainThreadExecutor
    extends BlockableEventLoop<Runnable> {
        public MainThreadExecutor(Level level) {
            super("Chunk source main thread executor for " + level.m_46472_().m_135782_());
        }

        protected Runnable m_6681_(Runnable p_8506_) {
            return p_8506_;
        }

        protected boolean m_6362_(Runnable p_8504_) {
            return true;
        }

        protected boolean m_5660_() {
            return true;
        }

        protected Thread m_6304_() {
            return ((ServerChunkCacheAccessor)((Object)LittleServerChunkCache.this)).getMainThread();
        }

        protected void m_6367_(Runnable run) {
            LittleServerChunkCache.this.f_8329_.m_46473_().m_6174_("runTask");
            super.m_6367_(run);
        }

        public boolean m_7245_() {
            if (LittleServerChunkCache.this.runDistanceManagerUpdates2()) {
                return true;
            }
            LittleServerChunkCache.this.m_7827_().m_9409_();
            return super.m_7245_();
        }
    }
}

