/*
 * Decompiled with CFR 0.152.
 */
package com.branders.spawnermod.config;

import com.branders.spawnermod.SpawnerMod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import net.minecraftforge.registries.ForgeRegistries;

public class ConfigValues {
    private static HashMap<String, Integer> CONFIG_SPEC = new HashMap();
    private static ArrayList<String> ITEM_ID_BLACKLIST = new ArrayList();

    public static void setDefaultConfigValues() {
        CONFIG_SPEC.put("monster_egg_drop_chance", 4);
        CONFIG_SPEC.put("disable_silk_touch", 0);
        CONFIG_SPEC.put("disable_spawner_config", 0);
        CONFIG_SPEC.put("disable_count", 0);
        CONFIG_SPEC.put("disable_range", 0);
        CONFIG_SPEC.put("disable_speed", 0);
        CONFIG_SPEC.put("limited_spawns_enabled", 0);
        CONFIG_SPEC.put("limited_spawns_amount", 32);
        CONFIG_SPEC.put("disable_egg_removal_from_spawner", 0);
        CONFIG_SPEC.put("monster_egg_only_drop_when_killed_by_player", 0);
        CONFIG_SPEC.put("default_spawner_range_enabled", 0);
        CONFIG_SPEC.put("default_spawner_range", 52);
        CONFIG_SPEC.put("spawner_hardness", 5);
        ForgeRegistries.ITEMS.getKeys().stream().forEach(i -> {
            String s = i.toString();
            if (i.toString().contains("spawn_egg")) {
                s = s.substring(0, s.length() - 10);
                CONFIG_SPEC.put(s, 0);
            }
        });
        CONFIG_SPEC.put("display_item_id_from_right_click_in_log", 0);
    }

    public static void put(String key, int value) {
        CONFIG_SPEC.put(key, value);
    }

    public static int get(String key) {
        if (CONFIG_SPEC.containsKey(key)) {
            return CONFIG_SPEC.get(key);
        }
        SpawnerMod.LOGGER.warn("Key=" + key + " was not found when trying to access it! Returning 0");
        return 0;
    }

    public static Set<String> getKeys() {
        return CONFIG_SPEC.keySet();
    }

    public static boolean isEggDisabled(String identifier) {
        return ConfigValues.get(identifier) != 0;
    }

    public static boolean isItemIdBlacklisted(String registryName) {
        return ITEM_ID_BLACKLIST.contains(registryName);
    }

    public static void blacklistItem(String registryName) {
        ITEM_ID_BLACKLIST.add(registryName);
    }

    public static Iterator<String> getBlacklistIds() {
        return ITEM_ID_BLACKLIST.iterator();
    }

    public static void sync(int config, int count, int speed, int range, int limitedSpawns, int limitedSpawnsAmount, int isCustomRange, int customRange) {
        ConfigValues.put("disable_spawner_config", config);
        ConfigValues.put("disable_count", count);
        ConfigValues.put("disable_speed", speed);
        ConfigValues.put("disable_range", range);
        ConfigValues.put("limited_spawns_enabled", limitedSpawns);
        ConfigValues.put("limited_spawns_amount", limitedSpawnsAmount);
        ConfigValues.put("default_spawner_range_enabled", isCustomRange);
        ConfigValues.put("default_spawner_range", customRange);
        SpawnerMod.LOGGER.info("Recieved config from server.");
    }
}

