/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.util;

import com.google.common.base.Preconditions;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import xfacthd.framedblocks.api.block.FramedBlockEntity;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.camo.CamoContainer;
import xfacthd.framedblocks.api.camo.EmptyCamoContainer;
import xfacthd.framedblocks.api.util.ClientUtils;

public final class Utils {
    private static final Direction[] DIRECTIONS = Direction.values();
    public static final TagKey<Block> FRAMEABLE = Utils.blockTag("frameable");
    public static final TagKey<Block> BLACKLIST = Utils.blockTag("blacklisted");
    public static final TagKey<Block> BE_WHITELIST = Utils.blockTag("blockentity_whitelisted");
    public static final TagKey<Block> CAMO_SUSTAIN_PLANT = Utils.blockTag("camo_sustain_plant");
    public static final TagKey<Item> WRENCH = Utils.itemTag("forge", "tools/wrench");
    public static final TagKey<Item> DISABLE_INTANGIBLE = Utils.itemTag("disable_intangible");
    public static final RegistryObject<Item> FRAMED_HAMMER = RegistryObject.create((ResourceLocation)Utils.rl("framed_hammer"), (IForgeRegistry)ForgeRegistries.ITEMS);
    public static final RegistryObject<Item> FRAMED_WRENCH = RegistryObject.create((ResourceLocation)Utils.rl("framed_wrench"), (IForgeRegistry)ForgeRegistries.ITEMS);
    public static final RegistryObject<Item> FRAMED_KEY = RegistryObject.create((ResourceLocation)Utils.rl("framed_key"), (IForgeRegistry)ForgeRegistries.ITEMS);
    public static final RegistryObject<Item> FRAMED_SCREWDRIVER = RegistryObject.create((ResourceLocation)Utils.rl("framed_screwdriver"), (IForgeRegistry)ForgeRegistries.ITEMS);
    public static final RegistryObject<Item> FRAMED_REINFORCEMENT = RegistryObject.create((ResourceLocation)Utils.rl("framed_reinforcement"), (IForgeRegistry)ForgeRegistries.ITEMS);

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        if (Utils.isY(from) || Utils.isY(to)) {
            throw new IllegalArgumentException("Invalid Direction!");
        }
        if (from == to) {
            return shape;
        }
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (to.m_122416_() - from.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    public static Vec3 fraction(Vec3 vec) {
        return new Vec3(vec.m_7096_() - Math.floor(vec.m_7096_()), vec.m_7098_() - Math.floor(vec.m_7098_()), vec.m_7094_() - Math.floor(vec.m_7094_()));
    }

    public static double fractionInDir(Vec3 vec, Direction dir) {
        vec = Utils.fraction(vec);
        double coord = switch (dir.m_122434_()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> vec.f_82479_;
            case Direction.Axis.Y -> vec.f_82480_;
            case Direction.Axis.Z -> vec.f_82481_;
        };
        return Utils.isPositive(dir) ? coord : 1.0 - coord;
    }

    public static boolean isLower(float lhs, float rhs) {
        if (Mth.m_14033_((float)lhs, (float)rhs)) {
            return false;
        }
        return lhs < rhs;
    }

    public static boolean isHigher(float lhs, float rhs) {
        if (Mth.m_14033_((float)lhs, (float)rhs)) {
            return false;
        }
        return lhs > rhs;
    }

    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createBlockEntityTicker(BlockEntityType<A> type, BlockEntityType<E> actualType, BlockEntityTicker<? super E> ticker) {
        return actualType == type ? ticker : null;
    }

    public static MutableComponent translate(String prefix, String postfix, Object ... arguments) {
        return Component.m_237110_((String)Utils.translationKey(prefix, postfix), (Object[])arguments);
    }

    public static MutableComponent translate(String prefix, String postfix) {
        return Component.m_237115_((String)Utils.translationKey(prefix, postfix));
    }

    public static String translationKey(String prefix, String postfix) {
        Object key = "";
        if (prefix != null) {
            key = prefix + ".";
        }
        key = (String)key + "framedblocks";
        if (postfix != null) {
            key = (String)key + "." + postfix;
        }
        return key;
    }

    public static String translateConfig(String type, String key) {
        return Utils.translationKey("config", type + "." + key);
    }

    public static <T extends Enum<T>> Component[] buildEnumTranslations(String prefix, String postfix, T[] values, ChatFormatting ... formatting) {
        return (Component[])Arrays.stream(values).map(v -> Utils.translate(prefix, postfix + "." + ((StringRepresentable)v).m_7912_())).map(c -> c.m_130944_(formatting)).toArray(Component[]::new);
    }

    public static <T extends Enum<T>> Component[] bindEnumTranslation(String key, T[] values, Component[] valueTranslations) {
        Preconditions.checkArgument((values.length == valueTranslations.length ? 1 : 0) != 0, (Object)"Value and translation arrays must have the same length");
        Component[] components = new Component[values.length];
        for (T v : values) {
            components[((Enum)v).ordinal()] = Component.m_237110_((String)key, (Object[])new Object[]{valueTranslations[((Enum)v).ordinal()]});
        }
        return components;
    }

    public static BlockEntity getBlockEntitySafe(BlockGetter blockGetter, BlockPos pos) {
        if (blockGetter instanceof Level) {
            Level level = (Level)blockGetter;
            return level.m_46745_(pos).m_5685_(pos, LevelChunk.EntityCreationType.CHECK);
        }
        if (blockGetter instanceof LevelChunk) {
            LevelChunk chunk = (LevelChunk)blockGetter;
            return chunk.m_5685_(pos, LevelChunk.EntityCreationType.CHECK);
        }
        if (FMLEnvironment.dist.isClient()) {
            return ClientUtils.getBlockEntitySafe(blockGetter, pos);
        }
        return null;
    }

    public static boolean isPositive(Direction dir) {
        return dir.m_122421_() == Direction.AxisDirection.POSITIVE;
    }

    public static boolean isX(Direction dir) {
        return dir.m_122434_() == Direction.Axis.X;
    }

    public static boolean isY(Direction dir) {
        return dir.m_122434_() == Direction.Axis.Y;
    }

    public static boolean isZ(Direction dir) {
        return dir.m_122434_() == Direction.Axis.Z;
    }

    public static Direction.Axis nextAxisNotEqualTo(Direction.Axis axis, Direction.Axis except) {
        Direction.Axis[] axes = Direction.Axis.f_122448_;
        while ((axis = axes[(axis.ordinal() + 1) % axes.length]) == except) {
        }
        return axis;
    }

    public static BlockState mirrorFaceBlock(BlockState state, Mirror mirror) {
        return Utils.mirrorFaceBlock(state, FramedProperties.FACING_HOR, mirror);
    }

    public static BlockState mirrorFaceBlock(BlockState state, DirectionProperty property, Mirror mirror) {
        if (mirror == Mirror.NONE) {
            return state;
        }
        Direction dir = (Direction)state.m_61143_((Property)property);
        if (mirror == Mirror.FRONT_BACK && Utils.isX(dir) || mirror == Mirror.LEFT_RIGHT && Utils.isZ(dir)) {
            return (BlockState)state.m_61124_((Property)property, (Comparable)dir.m_122424_());
        }
        return state;
    }

    public static BlockState mirrorCornerBlock(BlockState state, Mirror mirror) {
        return Utils.mirrorCornerBlock(state, FramedProperties.FACING_HOR, mirror);
    }

    public static BlockState mirrorCornerBlock(BlockState state, DirectionProperty property, Mirror mirror) {
        if (mirror == Mirror.NONE) {
            return state;
        }
        Direction dir = (Direction)state.m_61143_((Property)property);
        if (Utils.isY(dir)) {
            return state;
        }
        if (mirror == Mirror.LEFT_RIGHT) {
            dir = switch (dir) {
                case Direction.NORTH -> Direction.WEST;
                case Direction.EAST -> Direction.SOUTH;
                case Direction.SOUTH -> Direction.EAST;
                case Direction.WEST -> Direction.NORTH;
                default -> throw new IllegalArgumentException("Unreachable!");
            };
        } else {
            dir = switch (dir) {
                case Direction.NORTH -> Direction.EAST;
                case Direction.EAST -> Direction.NORTH;
                case Direction.SOUTH -> Direction.WEST;
                case Direction.WEST -> Direction.SOUTH;
                default -> throw new IllegalArgumentException("Unreachable!");
            };
        }
        return (BlockState)state.m_61124_((Property)property, (Comparable)dir);
    }

    public static TagKey<Block> blockTag(String name) {
        return Utils.blockTag("framedblocks", name);
    }

    public static TagKey<Block> blockTag(String modid, String name) {
        return BlockTags.create((ResourceLocation)new ResourceLocation(modid, name));
    }

    public static TagKey<Item> itemTag(String name) {
        return Utils.itemTag("framedblocks", name);
    }

    public static TagKey<Item> itemTag(String modid, String name) {
        return ItemTags.create((ResourceLocation)new ResourceLocation(modid, name));
    }

    public static FluidState readFluidStateFromNbt(CompoundTag tag) {
        if (!tag.m_128425_("Name", 8)) {
            return Fluids.f_76191_.m_76145_();
        }
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(tag.m_128461_("Name")));
        Preconditions.checkNotNull((Object)fluid);
        FluidState fluidState = fluid.m_76145_();
        if (tag.m_128425_("Properties", 10)) {
            CompoundTag compoundtag = tag.m_128469_("Properties");
            StateDefinition statedefinition = fluid.m_76144_();
            for (String s : compoundtag.m_128431_()) {
                Property property = statedefinition.m_61081_(s);
                if (property == null) continue;
                fluidState = (FluidState)NbtUtils.m_129204_((StateHolder)fluidState, (Property)property, (String)s, (CompoundTag)compoundtag, (CompoundTag)tag);
            }
        }
        return fluidState;
    }

    public static Property<?> getRotatableProperty(BlockState state) {
        for (Property prop : state.m_61147_()) {
            if (prop.m_61709_() == Direction.Axis.class) {
                return prop;
            }
            if (!(prop instanceof DirectionProperty)) continue;
            return prop;
        }
        return null;
    }

    public static void forAllDirections(Consumer<Direction> consumer) {
        consumer.accept(null);
        for (Direction dir : DIRECTIONS) {
            consumer.accept(dir);
        }
    }

    public static void wrapInStateCopy(LevelAccessor level, BlockPos pos, Player player, ItemStack stack, boolean writeToCamoTwo, boolean consumeItem, Runnable action) {
        FramedBlockEntity be;
        CamoContainer camo = EmptyCamoContainer.EMPTY;
        boolean glowing = false;
        boolean intangible = false;
        boolean reinforced = false;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity) {
            be = (FramedBlockEntity)blockEntity;
            camo = be.getCamo();
            glowing = be.isGlowing();
            intangible = be.isIntangible(null);
            reinforced = be.isReinforced();
        }
        action.run();
        if (consumeItem && !player.m_7500_()) {
            stack.m_41774_(1);
            player.m_150109_().m_6596_();
        }
        if ((blockEntity = level.m_7702_(pos)) instanceof FramedBlockEntity) {
            be = (FramedBlockEntity)blockEntity;
            be.setCamo(camo, writeToCamoTwo);
            be.setGlowing(glowing);
            be.setIntangible(intangible);
            be.setReinforced(reinforced);
        }
    }

    public static HolderLookup<Block> getBlockHolderLookup(Level level) {
        if (level != null) {
            return level.m_246945_(Registries.f_256747_);
        }
        return BuiltInRegistries.f_256975_.m_255303_();
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation("framedblocks", path);
    }

    public static MethodHandle unreflectMethod(Class<?> clazz, String srgMethodName, Class<?> ... paramTypes) {
        Method method = ObfuscationReflectionHelper.findMethod(clazz, (String)srgMethodName, (Class[])paramTypes);
        try {
            return MethodHandles.publicLookup().unreflect(method);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to unreflect method '%s#%s()'".formatted(clazz.getName(), srgMethodName), e);
        }
    }

    public static MethodHandle unreflectField(Class<?> clazz, String srgFieldName) {
        Field field = ObfuscationReflectionHelper.findField(clazz, (String)srgFieldName);
        try {
            return MethodHandles.publicLookup().unreflectGetter(field);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to unreflect field '%s#%s'".formatted(clazz.getName(), srgFieldName), e);
        }
    }

    public static MethodHandle unreflectFieldSetter(Class<?> clazz, String srgFieldName) {
        Field field = ObfuscationReflectionHelper.findField(clazz, (String)srgFieldName);
        try {
            return MethodHandles.publicLookup().unreflectSetter(field);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to unreflect field '%s#%s'".formatted(clazz.getName(), srgFieldName), e);
        }
    }

    private Utils() {
    }
}

