/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.render.outline;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Quaternionf;
import xfacthd.framedblocks.api.render.OutlineRenderer;
import xfacthd.framedblocks.api.render.Quaternions;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.DirectionAxis;

public class PrismOutlineRenderer
implements OutlineRenderer {
    protected static final Quaternionf[] YN_DIR = PrismOutlineRenderer.makeQuaternionArray();

    @Override
    public void draw(BlockState state, PoseStack pstack, VertexConsumer builder) {
        OutlineRenderer.drawLine(builder, pstack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        OutlineRenderer.drawLine(builder, pstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
        OutlineRenderer.drawLine(builder, pstack, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
        OutlineRenderer.drawLine(builder, pstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
        OutlineRenderer.drawLine(builder, pstack, 0.0, 0.0, 1.0, 0.5, 0.5, 1.0);
        OutlineRenderer.drawLine(builder, pstack, 0.5, 0.5, 1.0, 1.0, 0.0, 1.0);
        this.drawCenterAndTriangle(pstack, builder);
    }

    protected void drawCenterAndTriangle(PoseStack pstack, VertexConsumer builder) {
        OutlineRenderer.drawLine(builder, pstack, 0.5, 0.5, 0.0, 0.5, 0.5, 1.0);
        OutlineRenderer.drawLine(builder, pstack, 0.0, 0.0, 0.0, 0.5, 0.5, 0.0);
        OutlineRenderer.drawLine(builder, pstack, 0.5, 0.5, 0.0, 1.0, 0.0, 0.0);
    }

    @Override
    public void rotateMatrix(PoseStack pstack, BlockState state) {
        DirectionAxis dirAxis = (DirectionAxis)((Object)state.m_61143_(PropertyHolder.FACING_AXIS));
        Direction facing = dirAxis.direction();
        Direction.Axis axis = dirAxis.axis();
        if (Utils.isY(facing)) {
            if (facing == Direction.DOWN) {
                pstack.m_252781_(Quaternions.ZP_180);
            }
            if (axis == Direction.Axis.X) {
                pstack.m_252781_(Quaternions.YP_90);
            }
        } else {
            if (facing != Direction.SOUTH) {
                pstack.m_252781_(YN_DIR[facing.m_122416_()]);
            }
            if (axis != Direction.Axis.Y) {
                pstack.m_252781_(Quaternions.ZP_90);
            }
            pstack.m_252781_(Quaternions.XP_90);
        }
    }

    private static Quaternionf[] makeQuaternionArray() {
        Quaternionf[] array = new Quaternionf[4];
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            array[dir.m_122416_()] = Axis.f_252392_.m_252961_(1.5707964f * (float)dir.m_122416_());
        }
        return array;
    }
}

