/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.render.outline;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Quaternionf;
import xfacthd.framedblocks.api.render.OutlineRenderer;
import xfacthd.framedblocks.api.render.Quaternions;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.render.outline.PrismOutlineRenderer;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CompoundDirection;

public class SlopedPrismOutlineRenderer
extends PrismOutlineRenderer {
    private static final Quaternionf[][] ZP_DIR = SlopedPrismOutlineRenderer.makeQuaternionArray();

    @Override
    public void drawCenterAndTriangle(PoseStack pstack, VertexConsumer builder) {
        OutlineRenderer.drawLine(builder, pstack, 0.5, 0.5, 0.5, 0.5, 0.5, 1.0);
        OutlineRenderer.drawLine(builder, pstack, 0.0, 0.0, 0.0, 0.5, 0.5, 0.5);
        OutlineRenderer.drawLine(builder, pstack, 0.5, 0.5, 0.5, 1.0, 0.0, 0.0);
    }

    @Override
    public void rotateMatrix(PoseStack pstack, BlockState state) {
        CompoundDirection cmpDir = (CompoundDirection)((Object)state.m_61143_(PropertyHolder.FACING_DIR));
        Direction facing = cmpDir.direction();
        Direction orientation = cmpDir.orientation();
        if (Utils.isY(facing)) {
            if (orientation != Direction.SOUTH) {
                pstack.m_252781_(YN_DIR[orientation.m_122416_()]);
            }
            if (facing == Direction.DOWN) {
                pstack.m_252781_(Quaternions.ZP_180);
            }
        } else {
            if (facing != Direction.SOUTH) {
                pstack.m_252781_(YN_DIR[facing.m_122416_()]);
            }
            if (orientation != Direction.DOWN) {
                pstack.m_252781_(ZP_DIR[facing.m_122416_()][orientation.ordinal()]);
            }
            pstack.m_252781_(Quaternions.XP_90);
        }
    }

    private static Quaternionf[][] makeQuaternionArray() {
        Quaternionf[][] array = new Quaternionf[4][6];
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            array[dir.m_122416_()] = new Quaternionf[6];
            for (Direction orientation : Direction.values()) {
                int mult = 2;
                if (orientation == dir.m_122428_()) {
                    mult = 1;
                } else if (orientation == dir.m_122427_()) {
                    mult = 3;
                }
                array[dir.m_122416_()][orientation.ordinal()] = Axis.f_252403_.m_252961_(1.5707964f * (float)mult);
            }
        }
        return array;
    }
}

