/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slope;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.item.VerticalAndWallBlockItem;

public class FramedHalfSlopeBlock
extends FramedBlock {
    public static final VoxelShape SHAPE_BOTTOM_LEFT = Shapes.m_83124_((VoxelShape)FramedHalfSlopeBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)0.5, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedHalfSlopeBlock.m_49796_((double)0.0, (double)0.5, (double)0.0, (double)8.0, (double)4.0, (double)15.5), FramedHalfSlopeBlock.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)8.0, (double)8.0, (double)12.0), FramedHalfSlopeBlock.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)12.0, (double)8.0), FramedHalfSlopeBlock.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)8.0, (double)15.5, (double)4.0), FramedHalfSlopeBlock.m_49796_((double)0.0, (double)15.5, (double)0.0, (double)8.0, (double)16.0, (double)0.5)}).m_83296_();
    public static final VoxelShape SHAPE_BOTTOM_RIGHT = Shapes.m_83124_((VoxelShape)FramedHalfSlopeBlock.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedHalfSlopeBlock.m_49796_((double)8.0, (double)0.5, (double)0.0, (double)16.0, (double)4.0, (double)15.5), FramedHalfSlopeBlock.m_49796_((double)8.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)12.0), FramedHalfSlopeBlock.m_49796_((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)8.0), FramedHalfSlopeBlock.m_49796_((double)8.0, (double)12.0, (double)0.0, (double)16.0, (double)15.5, (double)4.0), FramedHalfSlopeBlock.m_49796_((double)8.0, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)0.5)}).m_83296_();
    public static final VoxelShape SHAPE_TOP_LEFT = Shapes.m_83124_((VoxelShape)FramedHalfSlopeBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)0.5, (double)0.5), (VoxelShape[])new VoxelShape[]{FramedHalfSlopeBlock.m_49796_((double)0.0, (double)0.5, (double)0.0, (double)8.0, (double)4.0, (double)4.0), FramedHalfSlopeBlock.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0), FramedHalfSlopeBlock.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)12.0, (double)12.0), FramedHalfSlopeBlock.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)8.0, (double)15.5, (double)15.5), FramedHalfSlopeBlock.m_49796_((double)0.0, (double)15.5, (double)0.0, (double)8.0, (double)16.0, (double)16.0)}).m_83296_();
    public static final VoxelShape SHAPE_TOP_RIGHT = Shapes.m_83124_((VoxelShape)FramedHalfSlopeBlock.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)0.5), (VoxelShape[])new VoxelShape[]{FramedHalfSlopeBlock.m_49796_((double)8.0, (double)0.5, (double)0.0, (double)16.0, (double)4.0, (double)4.0), FramedHalfSlopeBlock.m_49796_((double)8.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0), FramedHalfSlopeBlock.m_49796_((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)12.0), FramedHalfSlopeBlock.m_49796_((double)8.0, (double)12.0, (double)0.0, (double)16.0, (double)15.5, (double)15.5), FramedHalfSlopeBlock.m_49796_((double)8.0, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)16.0)}).m_83296_();

    public FramedHalfSlopeBlock() {
        super(BlockType.FRAMED_HALF_SLOPE);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PropertyHolder.RIGHT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, FramedProperties.TOP, PropertyHolder.RIGHT, BlockStateProperties.f_61362_, FramedProperties.Y_SLOPE});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction side = context.m_43719_();
        Vec3 hitVec = context.m_43720_();
        Direction dir = context.m_8125_();
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)dir);
        boolean right = Utils.fractionInDir(hitVec, dir.m_122427_()) > 0.5;
        state = (BlockState)state.m_61124_((Property)PropertyHolder.RIGHT, (Comparable)Boolean.valueOf(right));
        state = FramedHalfSlopeBlock.withTop(state, side, hitVec);
        return FramedHalfSlopeBlock.withWater(state, (LevelReader)context.m_43725_(), context.m_8083_());
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        if (rot == Rotation.NONE) {
            return state;
        }
        Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        if (Utils.isY(face) || face == facing.m_122424_()) {
            return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_(facing));
        }
        if (face == facing) {
            return (BlockState)state.m_61122_((Property)PropertyHolder.RIGHT);
        }
        return (BlockState)state.m_61122_((Property)FramedProperties.TOP);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return this.rotate(state, Direction.UP, rotation);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        if (mirror == Mirror.NONE) {
            return state;
        }
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        if (mirror == Mirror.FRONT_BACK && Utils.isX(dir) || mirror == Mirror.LEFT_RIGHT && Utils.isZ(dir)) {
            state = (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)dir.m_122424_());
        }
        return (BlockState)state.m_61122_((Property)PropertyHolder.RIGHT);
    }

    @Override
    public BlockItem createBlockItem() {
        return new VerticalAndWallBlockItem(this, (Block)FBContent.blockFramedVerticalHalfSlope.get(), new Item.Properties());
    }

    public static ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            boolean right = (Boolean)state.m_61143_((Property)PropertyHolder.RIGHT);
            VoxelShape shape = top ? (right ? SHAPE_TOP_RIGHT : SHAPE_TOP_LEFT) : (right ? SHAPE_BOTTOM_RIGHT : SHAPE_BOTTOM_LEFT);
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR), shape));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

