/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.datagen.providers;

import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;
import org.joml.Vector3f;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.util.ClientUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.loader.overlay.OverlayLoaderBuilder;
import xfacthd.framedblocks.client.model.cube.FramedMarkedCubeModel;
import xfacthd.framedblocks.client.model.interactive.FramedMarkedPressurePlateModel;
import xfacthd.framedblocks.client.model.rail.FramedFancyRailModel;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;

public final class FramedBlockStateProvider
extends BlockStateProvider {
    private final ResourceLocation TEXTURE = this.modLoc("block/framed_block");

    public FramedBlockStateProvider(PackOutput output, ExistingFileHelper fileHelper) {
        super(output, "framedblocks", fileHelper);
    }

    protected void registerStatesAndModels() {
        ModelBuilder cube = ((BlockModelBuilder)this.models().cubeAll("framed_cube", this.TEXTURE)).renderType("cutout");
        BlockModelBuilder stoneCube = this.makeUnderlayedCube("framed_stone_cube", this.mcLoc("block/stone"));
        BlockModelBuilder obsidianCube = this.makeUnderlayedCube("framed_obsidian_cube", this.mcLoc("block/obsidian"));
        BlockModelBuilder ironCube = this.makeUnderlayedCube("framed_iron_cube", this.mcLoc("block/iron_block"));
        BlockModelBuilder goldCube = this.makeUnderlayedCube("framed_gold_cube", this.mcLoc("block/gold_block"));
        this.simpleBlockWithItem(FBContent.blockFramedSlope, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedCornerSlope, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedInnerCornerSlope, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedPrismCorner, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedInnerPrismCorner, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedThreewayCorner, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedInnerThreewayCorner, (ModelFile)cube, "cutout");
        this.simpleBlock((Block)FBContent.blockFramedSlabEdge.get(), (ModelFile)cube);
        this.simpleBlock((Block)FBContent.blockFramedSlabCorner.get(), (ModelFile)cube);
        this.simpleBlock((Block)FBContent.blockFramedDividedSlab.get(), (ModelFile)cube);
        this.simpleBlock((Block)FBContent.blockFramedPanel.get(), (ModelFile)cube);
        this.simpleBlock((Block)FBContent.blockFramedCornerPillar.get(), (ModelFile)cube);
        this.simpleBlock((Block)FBContent.blockFramedDividedPanelHor.get(), (ModelFile)cube);
        this.simpleBlock((Block)FBContent.blockFramedDividedPanelVert.get(), (ModelFile)cube);
        this.simpleBlock((Block)FBContent.blockFramedIronTrapDoor.get(), (ModelFile)ironCube);
        this.simpleBlock((Block)FBContent.blockFramedStoneButton.get(), (ModelFile)stoneCube);
        this.simpleBlock((Block)FBContent.blockFramedWallSign.get(), (ModelFile)cube);
        this.simpleBlock((Block)FBContent.blockFramedLattice.get(), (ModelFile)cube);
        this.simpleBlock((Block)FBContent.blockFramedVerticalStairs.get(), (ModelFile)cube);
        this.simpleBlockWithItem(FBContent.blockFramedDoubleSlab, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedDoublePanel, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem((Block)FBContent.blockFramedDoubleSlope.get(), (ModelFile)cube);
        this.simpleBlockWithItem(FBContent.blockFramedDoubleCorner, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedDoublePrismCorner, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedDoubleThreewayCorner, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedRailSlope, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedPoweredRailSlope, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedDetectorRailSlope, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedActivatorRailSlope, (ModelFile)cube, "cutout");
        this.simpleBlock((Block)FBContent.blockFramedPillar.get(), (ModelFile)cube);
        this.simpleBlock((Block)FBContent.blockFramedHalfPillar.get(), (ModelFile)cube);
        this.simpleBlock((Block)FBContent.blockFramedPost.get(), (ModelFile)cube);
        this.simpleBlock((Block)FBContent.blockFramedHalfStairs.get(), (ModelFile)cube);
        this.simpleBlock((Block)FBContent.blockFramedDividedStairs.get(), (ModelFile)cube);
        this.simpleBlockWithItem(FBContent.blockFramedPrism, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedInnerPrism, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedDoublePrism, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedSlopedPrism, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedInnerSlopedPrism, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedDoubleSlopedPrism, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedSlopeSlab, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedElevatedSlopeSlab, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedDoubleSlopeSlab, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedInverseDoubleSlopeSlab, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedElevatedDoubleSlopeSlab, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedStackedSlopeSlab, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedFlatSlopeSlabCorner, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedFlatInnerSlopeSlabCorner, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedFlatElevatedSlopeSlabCorner, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedFlatElevatedInnerSlopeSlabCorner, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedFlatDoubleSlopeSlabCorner, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedFlatInverseDoubleSlopeSlabCorner, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedFlatElevatedDoubleSlopeSlabCorner, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedFlatElevatedInnerDoubleSlopeSlabCorner, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedFlatStackedSlopeSlabCorner, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedFlatStackedInnerSlopeSlabCorner, (ModelFile)cube, "cutout");
        this.simpleBlock((Block)FBContent.blockFramedVerticalHalfStairs.get(), (ModelFile)cube);
        this.simpleBlock((Block)FBContent.blockFramedVerticalDividedStairs.get(), (ModelFile)cube);
        this.simpleBlockWithItem(FBContent.blockFramedSlopePanel, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedExtendedSlopePanel, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedDoubleSlopePanel, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedInverseDoubleSlopePanel, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedExtendedDoubleSlopePanel, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedStackedSlopePanel, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedFlatSlopePanelCorner, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedFlatInnerSlopePanelCorner, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedFlatExtendedSlopePanelCorner, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedFlatExtendedInnerSlopePanelCorner, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedFlatDoubleSlopePanelCorner, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedFlatInverseDoubleSlopePanelCorner, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedFlatExtendedDoubleSlopePanelCorner, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedFlatExtendedInnerDoubleSlopePanelCorner, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedFlatStackedSlopePanelCorner, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedFlatStackedInnerSlopePanelCorner, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedDoubleStairs, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedVerticalDoubleStairs, (ModelFile)cube, "cutout");
        this.simpleBlock((Block)FBContent.blockFramedWallBoard.get(), (ModelFile)cube);
        this.simpleBlockWithItem(FBContent.blockFramedPyramid, (ModelFile)cube);
        this.simpleBlockWithItem(FBContent.blockFramedPyramidSlab, (ModelFile)cube);
        this.simpleBlock((Block)FBContent.blockFramedHorizontalPane.get(), (ModelFile)cube);
        this.simpleBlock((Block)FBContent.blockFramedLargeButton.get(), (ModelFile)cube);
        this.simpleBlock((Block)FBContent.blockFramedLargeStoneButton.get(), (ModelFile)stoneCube);
        this.simpleBlock((Block)FBContent.blockFramedGate.get(), (ModelFile)cube);
        this.simpleBlock((Block)FBContent.blockFramedIronGate.get(), (ModelFile)ironCube);
        this.simpleBlockWithItem(FBContent.blockFramedFancyRailSlope, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedFancyPoweredRailSlope, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedFancyDetectorRailSlope, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedFancyActivatorRailSlope, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedHalfSlope, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedVerticalHalfSlope, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedDividedSlope, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedDoubleHalfSlope, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedVerticalDoubleHalfSlope, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedSlopedStairs, (ModelFile)cube, "cutout");
        this.simpleBlockWithItem(FBContent.blockFramedVerticalSlopedStairs, (ModelFile)cube, "cutout");
        this.registerFramedCube((ModelFile)cube);
        this.registerFramedSlab((ModelFile)cube);
        this.registerFramedStairs((ModelFile)cube);
        this.registerFramedWall((ModelFile)cube);
        this.registerFramedFence((ModelFile)cube);
        this.registerFramedFenceGate((ModelFile)cube);
        this.registerFramedDoor((ModelFile)cube);
        this.registerFramedIronDoor((ModelFile)ironCube);
        this.registerFramedTrapDoor((ModelFile)cube);
        this.registerFramedPressurePlate((ModelFile)cube);
        this.registerFramedStonePressurePlate((ModelFile)stoneCube);
        this.registerFramedObsidianPressurePlate((ModelFile)obsidianCube);
        this.registerFramedGoldPressurePlate((ModelFile)goldCube);
        this.registerFramedIronPressurePlate((ModelFile)ironCube);
        this.registerFramedLadder();
        this.registerFramedButton((ModelFile)cube);
        this.registerFramedLever();
        this.registerFramedSign((ModelFile)cube);
        this.registerFramedTorch();
        this.registerFramedWallTorch();
        this.registerFramedSoulTorch();
        this.registerFramedSoulWallTorch();
        this.registerFramedRedstoneTorch();
        this.registerFramedRedstoneWallTorch();
        this.registerFramedFloorBoard((ModelFile)cube);
        this.registerFramedChest();
        this.registerFramedBarsBlock((ModelFile)cube);
        this.registerFramedPaneBlock((ModelFile)cube);
        this.registerFramedFlowerPotBlock((ModelFile)cube);
        this.registerFramedCollapsibleBlock();
        this.registerFramedBouncyBlock();
        this.registerFramedSecretStorage();
        this.registerFramedRedstoneBlock();
        this.registerFramedGlowingCube();
        this.registerFramedTarget((ModelFile)cube);
        this.registerFramedItemFrame();
        this.registerFramedFancyRail();
        this.registerFramedFancyPoweredRail();
        this.registerFramedFancyDetectorRail();
        this.registerFramedFancyActivatorRail();
        this.registerFramedMiniCube((ModelFile)cube);
        this.registerFramedOneWayWindow();
        this.registerFramingSaw();
    }

    private void registerFramedCube(ModelFile cube) {
        ModelBuilder altCube = ((BlockModelBuilder)this.models().cubeAll("framed_cube_alt", this.modLoc("block/framed_block_alt"))).renderType("cutout");
        ModelBuilder reinforcement = ((BlockModelBuilder)this.models().cubeAll("framed_reinforcement", this.modLoc("block/framed_reinforcement"))).renderType("cutout");
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)FBContent.blockFramedCube.get()).part().modelFile(cube).addModel()).condition((Property)FramedProperties.ALT, (Comparable[])new Boolean[]{false}).end().part().modelFile((ModelFile)altCube).addModel()).condition((Property)FramedProperties.ALT, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)reinforcement).addModel()).condition((Property)FramedProperties.REINFORCED, (Comparable[])new Boolean[]{true}).end();
        this.simpleBlockItem(FBContent.blockFramedCube, cube);
    }

    private void registerFramedSlab(ModelFile cube) {
        this.simpleBlock((Block)FBContent.blockFramedSlab.get(), cube);
        ((ItemModelBuilder)this.itemModels().slab("framed_slab", this.TEXTURE, this.TEXTURE, this.TEXTURE)).renderType("cutout");
    }

    private void registerFramedStairs(ModelFile cube) {
        this.simpleBlock((Block)FBContent.blockFramedStairs.get(), cube);
        ((ItemModelBuilder)this.itemModels().stairs("framed_stairs", this.TEXTURE, this.TEXTURE, this.TEXTURE)).renderType("cutout");
    }

    private void registerFramedWall(ModelFile cube) {
        this.simpleBlock((Block)FBContent.blockFramedWall.get(), cube);
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder("framed_wall")).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block/wall_inventory")))).texture("wall", this.TEXTURE)).renderType("cutout");
    }

    private void registerFramedFence(ModelFile cube) {
        this.getMultipartBuilder((Block)FBContent.blockFramedFence.get()).part().modelFile(cube).addModel();
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder("framed_fence")).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block/fence_inventory")))).texture("texture", this.TEXTURE)).renderType("cutout");
    }

    private void registerFramedFenceGate(ModelFile cube) {
        this.simpleBlock((Block)FBContent.blockFramedFenceGate.get(), cube);
        ((ItemModelBuilder)this.itemModels().fenceGate("framed_fence_gate", this.TEXTURE)).renderType("cutout");
    }

    private void registerFramedDoor(ModelFile cube) {
        this.simpleBlock((Block)FBContent.blockFramedDoor.get(), cube);
        this.simpleItem(FBContent.blockFramedDoor, "cutout");
    }

    private void registerFramedIronDoor(ModelFile cube) {
        this.simpleBlock((Block)FBContent.blockFramedIronDoor.get(), cube);
        this.simpleItem(FBContent.blockFramedIronDoor, "cutout");
    }

    private void registerFramedTrapDoor(ModelFile cube) {
        this.simpleBlock((Block)FBContent.blockFramedTrapDoor.get(), cube);
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().withExistingParent("framed_trapdoor", this.mcLoc("block/template_orientable_trapdoor_bottom"))).texture("texture", this.TEXTURE)).renderType("cutout");
    }

    private void registerFramedPressurePlate(ModelFile cube) {
        this.simpleBlock((Block)FBContent.blockFramedPressurePlate.get(), cube);
        this.simpleBlock((Block)FBContent.blockFramedWaterloggablePressurePlate.get(), cube);
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().withExistingParent("framed_pressure_plate", this.mcLoc("block/pressure_plate_up"))).texture("texture", this.TEXTURE)).renderType("cutout");
    }

    private void registerFramedStonePressurePlate(ModelFile cube) {
        this.simpleBlock((Block)FBContent.blockFramedStonePressurePlate.get(), cube);
        this.simpleBlock((Block)FBContent.blockFramedWaterloggableStonePressurePlate.get(), cube);
        this.makeOverlayModel(FramedMarkedPressurePlateModel.STONE_FRAME_LOCATION, this.modLoc("block/framed_pressure_plate_frame_up"), "texture", this.modLoc("block/stone_plate_frame"), new Vector3f(8.0f, 0.5f, 8.0f));
        this.makeOverlayModel(FramedMarkedPressurePlateModel.STONE_FRAME_DOWN_LOCATION, this.modLoc("block/framed_pressure_plate_frame_down"), "texture", this.modLoc("block/stone_plate_frame"), new Vector3f(8.0f, 0.25f, 8.0f));
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().withExistingParent("framed_stone_pressure_plate", this.modLoc("block/framed_pressure_plate_up"))).texture("background", this.mcLoc("block/stone"))).renderType("cutout");
    }

    private void registerFramedObsidianPressurePlate(ModelFile cube) {
        this.simpleBlock((Block)FBContent.blockFramedObsidianPressurePlate.get(), cube);
        this.simpleBlock((Block)FBContent.blockFramedWaterloggableObsidianPressurePlate.get(), cube);
        this.makeOverlayModel(FramedMarkedPressurePlateModel.OBSIDIAN_FRAME_LOCATION, this.modLoc("block/framed_pressure_plate_frame_up"), "texture", this.modLoc("block/obsidian_plate_frame"), new Vector3f(8.0f, 0.5f, 8.0f));
        this.makeOverlayModel(FramedMarkedPressurePlateModel.OBSIDIAN_FRAME_DOWN_LOCATION, this.modLoc("block/framed_pressure_plate_frame_down"), "texture", this.modLoc("block/obsidian_plate_frame"), new Vector3f(8.0f, 0.25f, 8.0f));
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().withExistingParent("framed_obsidian_pressure_plate", this.modLoc("block/framed_pressure_plate_up"))).texture("background", this.mcLoc("block/obsidian"))).renderType("cutout");
    }

    private void registerFramedGoldPressurePlate(ModelFile cube) {
        this.simpleBlock((Block)FBContent.blockFramedGoldPressurePlate.get(), cube);
        this.simpleBlock((Block)FBContent.blockFramedWaterloggableGoldPressurePlate.get(), cube);
        this.makeOverlayModel(FramedMarkedPressurePlateModel.GOLD_FRAME_LOCATION, this.modLoc("block/framed_pressure_plate_frame_up"), "texture", this.modLoc("block/gold_plate_frame"), new Vector3f(8.0f, 0.5f, 8.0f));
        this.makeOverlayModel(FramedMarkedPressurePlateModel.GOLD_FRAME_DOWN_LOCATION, this.modLoc("block/framed_pressure_plate_frame_down"), "texture", this.modLoc("block/gold_plate_frame"), new Vector3f(8.0f, 0.25f, 8.0f));
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().withExistingParent("framed_gold_pressure_plate", this.modLoc("block/framed_pressure_plate_up"))).texture("background", this.mcLoc("block/gold_block"))).renderType("cutout");
    }

    private void registerFramedIronPressurePlate(ModelFile cube) {
        this.simpleBlock((Block)FBContent.blockFramedIronPressurePlate.get(), cube);
        this.simpleBlock((Block)FBContent.blockFramedWaterloggableIronPressurePlate.get(), cube);
        this.makeOverlayModel(FramedMarkedPressurePlateModel.IRON_FRAME_LOCATION, this.modLoc("block/framed_pressure_plate_frame_up"), "texture", this.modLoc("block/iron_plate_frame"), new Vector3f(8.0f, 0.5f, 8.0f));
        this.makeOverlayModel(FramedMarkedPressurePlateModel.IRON_FRAME_DOWN_LOCATION, this.modLoc("block/framed_pressure_plate_frame_down"), "texture", this.modLoc("block/iron_plate_frame"), new Vector3f(8.0f, 0.25f, 8.0f));
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().withExistingParent("framed_iron_pressure_plate", this.modLoc("block/framed_pressure_plate_up"))).texture("background", this.mcLoc("block/iron_block"))).renderType("cutout");
    }

    private void registerFramedLadder() {
        ModelBuilder ladder = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("framed_ladder", this.mcLoc("block/cube"))).texture("0", this.TEXTURE)).texture("particle", this.TEXTURE)).element().face(Direction.NORTH).texture("#0").end().face(Direction.SOUTH).texture("#0").end().end();
        this.simpleBlockWithItem(FBContent.blockFramedLadder, (ModelFile)ladder, "cutout");
    }

    private void registerFramedButton(ModelFile cube) {
        this.simpleBlock((Block)FBContent.blockFramedButton.get(), cube);
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder("framed_button")).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block/button_inventory")))).texture("texture", this.TEXTURE)).renderType("cutout");
    }

    private void registerFramedLever() {
        ModelBuilder lever = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("framed_lever", this.mcLoc("block/lever"))).texture("base", ClientUtils.DUMMY_TEXTURE)).texture("particle", this.TEXTURE);
        ModelBuilder leverOn = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("framed_lever_on", this.mcLoc("block/lever_on"))).texture("base", ClientUtils.DUMMY_TEXTURE)).texture("particle", this.TEXTURE);
        this.getVariantBuilder((Block)FBContent.blockFramedLever.get()).forAllStatesExcept(arg_0 -> FramedBlockStateProvider.lambda$registerFramedLever$0((ModelFile)leverOn, (ModelFile)lever, arg_0), new Property[]{FramedProperties.GLOWING});
        this.simpleItem(FBContent.blockFramedLever, "cutout");
    }

    private void registerFramedSign(ModelFile cube) {
        this.simpleBlock((Block)FBContent.blockFramedSign.get(), cube);
        this.simpleItem(FBContent.blockFramedSign, "cutout");
    }

    private void registerFramedTorch() {
        ModelFile.ExistingModelFile torch = this.models().getExistingFile(this.modLoc("framed_torch"));
        this.simpleBlock((Block)FBContent.blockFramedTorch.get(), (ModelFile)torch);
        this.simpleItem(FBContent.blockFramedTorch, "block/framed_torch", "cutout");
    }

    private void registerFramedWallTorch() {
        ModelFile.ExistingModelFile wallTorch = this.models().getExistingFile(this.modLoc("framed_wall_torch"));
        this.getVariantBuilder((Block)FBContent.blockFramedWallTorch.get()).forAllStatesExcept(arg_0 -> FramedBlockStateProvider.lambda$registerFramedWallTorch$1((ModelFile)wallTorch, arg_0), new Property[]{FramedProperties.GLOWING});
    }

    private void registerFramedSoulTorch() {
        ModelBuilder torch = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("framed_soul_torch", this.modLoc("framed_torch"))).texture("particle", this.modLoc("block/framed_soul_torch"))).texture("top", this.mcLoc("block/soul_torch"));
        this.simpleBlock((Block)FBContent.blockFramedSoulTorch.get(), (ModelFile)torch);
        this.simpleItem(FBContent.blockFramedSoulTorch, "block/framed_soul_torch", "cutout");
    }

    private void registerFramedSoulWallTorch() {
        ModelBuilder wallTorch = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("framed_soul_wall_torch", this.modLoc("framed_wall_torch"))).texture("particle", this.modLoc("block/framed_soul_torch"))).texture("top", this.mcLoc("block/soul_torch"));
        this.getVariantBuilder((Block)FBContent.blockFramedSoulWallTorch.get()).forAllStatesExcept(arg_0 -> FramedBlockStateProvider.lambda$registerFramedSoulWallTorch$2((ModelFile)wallTorch, arg_0), new Property[]{FramedProperties.GLOWING});
    }

    private void registerFramedRedstoneTorch() {
        ModelFile.ExistingModelFile torch = this.models().getExistingFile(this.modLoc("framed_redstone_torch"));
        ModelBuilder torchOff = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("framed_redstone_torch_off", this.modLoc("framed_torch"))).texture("particle", this.modLoc("block/framed_redstone_torch_off"))).texture("top", this.mcLoc("block/redstone_torch_off"));
        this.getVariantBuilder((Block)FBContent.blockFramedRedstoneTorch.get()).forAllStatesExcept(arg_0 -> FramedBlockStateProvider.lambda$registerFramedRedstoneTorch$3((ModelFile)torch, (ModelFile)torchOff, arg_0), new Property[]{FramedProperties.GLOWING});
        this.simpleItem(FBContent.blockFramedRedstoneTorch, "block/framed_redstone_torch", "cutout");
    }

    private void registerFramedRedstoneWallTorch() {
        ModelFile.ExistingModelFile wallTorch = this.models().getExistingFile(this.modLoc("framed_redstone_wall_torch"));
        ModelBuilder wallTorchOff = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("framed_redstone_wall_torch_off", this.modLoc("framed_wall_torch"))).texture("particle", this.modLoc("block/framed_redstone_torch_off"))).texture("top", this.mcLoc("block/redstone_torch_off"));
        this.getVariantBuilder((Block)FBContent.blockFramedRedstoneWallTorch.get()).forAllStatesExcept(arg_0 -> FramedBlockStateProvider.lambda$registerFramedRedstoneWallTorch$4((ModelFile)wallTorch, (ModelFile)wallTorchOff, arg_0), new Property[]{FramedProperties.GLOWING});
    }

    private void registerFramedFloorBoard(ModelFile cube) {
        this.simpleBlock((Block)FBContent.blockFramedFloor.get(), cube);
        ((ItemModelBuilder)this.itemModels().carpet("framed_floor_board", this.TEXTURE)).renderType("cutout");
    }

    private void registerFramedChest() {
        ModelFile.ExistingModelFile chest = this.models().getExistingFile(this.modLoc("block/framed_chest"));
        this.getVariantBuilder((Block)FBContent.blockFramedChest.get()).forAllStatesExcept(arg_0 -> FramedBlockStateProvider.lambda$registerFramedChest$5((ModelFile)chest, arg_0), new Property[]{BlockStateProperties.f_61362_, PropertyHolder.LATCH_TYPE, FramedProperties.GLOWING});
        this.simpleBlockItem(FBContent.blockFramedChest, (ModelFile)chest, "cutout");
    }

    private void registerFramedBarsBlock(ModelFile cube) {
        this.simpleBlock((Block)FBContent.blockFramedBars.get(), cube);
        this.simpleItem(FBContent.blockFramedBars, "cutout");
    }

    private void registerFramedPaneBlock(ModelFile cube) {
        this.simpleBlock((Block)FBContent.blockFramedPane.get(), cube);
        this.simpleItem(FBContent.blockFramedPane, this.TEXTURE.m_135815_(), "cutout");
    }

    private void registerFramedFlowerPotBlock(ModelFile cube) {
        this.simpleBlock((Block)FBContent.blockFramedFlowerPot.get(), cube);
        this.simpleItem(FBContent.blockFramedFlowerPot, "cutout");
    }

    private void registerFramedCollapsibleBlock() {
        ModelBuilder block = this.makeUnderlayedCube("framed_collapsible_block", this.mcLoc("block/oak_planks")).renderType("cutout");
        this.simpleBlockWithItem(FBContent.blockFramedCollapsibleBlock, (ModelFile)block, "cutout");
    }

    private void registerFramedBouncyBlock() {
        BlockModelBuilder block = this.makeUnderlayedCube("framed_bouncy_cube", this.mcLoc("block/slime_block"));
        this.simpleBlockWithItem(FBContent.blockFramedBouncyCube, (ModelFile)block, "cutout");
        this.makeOverlayModel(FramedMarkedCubeModel.SLIME_FRAME_LOCATION, this.mcLoc("block/cube_all"), "all", this.modLoc("block/slime_frame"));
    }

    private void registerFramedSecretStorage() {
        ModelBuilder block = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("framed_secret_storage", "block/block")).element().cube("#barrel").face(Direction.UP).texture("#barrel_top").end().face(Direction.DOWN).texture("#barrel_bottom").end().end()).element().cube("#frame").end()).texture("barrel", this.mcLoc("block/barrel_side"))).texture("barrel_top", this.mcLoc("block/barrel_top"))).texture("barrel_bottom", this.mcLoc("block/barrel_bottom"))).texture("frame", this.TEXTURE)).texture("particle", this.TEXTURE);
        this.simpleBlockWithItem(FBContent.blockFramedSecretStorage, (ModelFile)block, "cutout");
    }

    private void registerFramedRedstoneBlock() {
        BlockModelBuilder block = this.makeUnderlayedCube("framed_redstone_block", this.mcLoc("block/redstone_block"));
        this.simpleBlockWithItem(FBContent.blockFramedRedstoneBlock, (ModelFile)block, "cutout");
        this.makeOverlayModel(FramedMarkedCubeModel.REDSTONE_FRAME_LOCATION, this.mcLoc("block/cube_all"), "all", this.modLoc("block/redstone_frame"));
    }

    private void registerFramedGlowingCube() {
        BlockModelBuilder block = this.makeUnderlayedCube("framed_glowing_cube", new ResourceLocation("forge", "white"));
        this.simpleBlockWithItem(FBContent.blockFramedGlowingCube, (ModelFile)block);
    }

    private void registerFramedTarget(ModelFile cube) {
        this.simpleBlockWithItem(FBContent.blockFramedTarget, cube, "cutout");
        ((OverlayLoaderBuilder)((BlockModelBuilder)this.models().getBuilder("target_overlay")).customLoader(OverlayLoaderBuilder::new)).model((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)this.models().getExistingFile(this.mcLoc("block/block")))).element().cube("#overlay").faces((dir, face) -> face.tintindex(1024)).end()).texture("overlay", this.modLoc("block/target_overlay"))).renderType("cutout"));
    }

    private void registerFramedItemFrame() {
        ModelBuilder normalFrame = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("framed_item_frame", this.modLoc("block/template_framed_item_frame"))).texture("front", this.mcLoc("block/item_frame"))).texture("back", ClientUtils.DUMMY_TEXTURE)).texture("wood", ClientUtils.DUMMY_TEXTURE)).texture("particle", this.TEXTURE);
        ModelBuilder normalMapFrame = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("framed_item_frame_map", this.modLoc("block/template_framed_item_frame_map"))).texture("front", this.mcLoc("block/item_frame"))).texture("back", ClientUtils.DUMMY_TEXTURE)).texture("wood", ClientUtils.DUMMY_TEXTURE)).texture("particle", this.TEXTURE);
        ModelBuilder glowFrame = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("framed_glow_item_frame", this.modLoc("block/template_framed_item_frame"))).texture("front", this.mcLoc("block/glow_item_frame"))).texture("back", ClientUtils.DUMMY_TEXTURE)).texture("wood", ClientUtils.DUMMY_TEXTURE)).texture("particle", this.TEXTURE);
        ModelBuilder glowMapFrame = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("framed_glow_item_frame_map", this.modLoc("block/template_framed_item_frame_map"))).texture("front", this.mcLoc("block/glow_item_frame"))).texture("back", ClientUtils.DUMMY_TEXTURE)).texture("wood", ClientUtils.DUMMY_TEXTURE)).texture("particle", this.TEXTURE);
        BiFunction<ModelFile, ModelFile, Function> mapper = (frame, mapFrame) -> state -> {
            int xRot = 0;
            int yRot = 0;
            Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            if (Utils.isY(dir)) {
                xRot = dir == Direction.UP ? 90 : -90;
            } else {
                yRot = (int)dir.m_122435_();
            }
            boolean map = (Boolean)state.m_61143_((Property)PropertyHolder.MAP_FRAME);
            return ConfiguredModel.builder().modelFile(map ? mapFrame : frame).rotationX(xRot).rotationY(yRot).build();
        };
        this.getVariantBuilder((Block)FBContent.blockFramedItemFrame.get()).forAllStatesExcept(mapper.apply((ModelFile)normalFrame, (ModelFile)normalMapFrame), new Property[]{PropertyHolder.LEATHER, FramedProperties.GLOWING});
        this.getVariantBuilder((Block)FBContent.blockFramedGlowingItemFrame.get()).forAllStatesExcept(mapper.apply((ModelFile)glowFrame, (ModelFile)glowMapFrame), new Property[]{PropertyHolder.LEATHER, FramedProperties.GLOWING});
        this.simpleItem(FBContent.blockFramedItemFrame, "cutout");
        this.simpleItem(FBContent.blockFramedGlowingItemFrame, "cutout");
    }

    private static Function<BlockState, ConfiguredModel[]> railStates(EnumProperty<RailShape> shapeProp, Function<BlockState, ModelFile> normalRail, Function<BlockState, ModelFile> ascendingRail, Function<BlockState, ModelFile> curvedRail) {
        return state -> {
            ModelFile model;
            RailShape shape = (RailShape)state.m_61143_((Property)shapeProp);
            int rotY = (int)FramedFancyRailModel.getDirectionFromRailShape(shape).m_122435_();
            if (shape.m_61745_()) {
                model = (ModelFile)ascendingRail.apply((BlockState)state);
                rotY = (rotY + 180) % 360;
            } else if (shape == RailShape.NORTH_SOUTH || shape == RailShape.EAST_WEST) {
                model = (ModelFile)normalRail.apply((BlockState)state);
            } else {
                model = (ModelFile)curvedRail.apply((BlockState)state);
                rotY = shape == RailShape.NORTH_EAST || shape == RailShape.SOUTH_WEST ? (rotY + 180) % 360 : (rotY + 90) % 360;
            }
            return ConfiguredModel.builder().rotationY(rotY).modelFile(model).build();
        };
    }

    private void registerFramedFancyRail() {
        ModelFile normalRail = this.existingBlock(FBContent.blockFramedFancyRail);
        ModelFile ascendingRail = this.existingBlock(FBContent.blockFramedFancyRail, "ascending");
        ModelFile curvedRail = this.existingBlock(FBContent.blockFramedFancyRail, "curved");
        this.getVariantBuilder((Block)FBContent.blockFramedFancyRail.get()).forAllStatesExcept(FramedBlockStateProvider.railStates((EnumProperty<RailShape>)BlockStateProperties.f_61403_, state -> normalRail, state -> ascendingRail, state -> curvedRail), new Property[]{BlockStateProperties.f_61362_, FramedProperties.GLOWING});
    }

    private void registerFramedFancyPoweredRail() {
        ModelFile normalRail = this.existingBlock(FBContent.blockFramedFancyPoweredRail);
        ModelBuilder normalRailOn = ((BlockModelBuilder)((BlockModelBuilder)this.block(FBContent.blockFramedFancyPoweredRail, "on").parent(normalRail)).texture("texture", this.mcLoc("block/powered_rail_on"))).texture("particle", this.mcLoc("block/powered_rail_on"));
        ModelFile ascendingRail = this.existingBlock(FBContent.blockFramedFancyPoweredRail, "ascending");
        ModelBuilder ascendingRailOn = ((BlockModelBuilder)((BlockModelBuilder)this.block(FBContent.blockFramedFancyPoweredRail, "ascending_on").parent(ascendingRail)).texture("texture", this.mcLoc("block/powered_rail_on"))).texture("particle", this.mcLoc("block/powered_rail_on"));
        this.getVariantBuilder((Block)FBContent.blockFramedFancyPoweredRail.get()).forAllStatesExcept(FramedBlockStateProvider.railStates((EnumProperty<RailShape>)BlockStateProperties.f_61404_, arg_0 -> FramedBlockStateProvider.lambda$registerFramedFancyPoweredRail$13((ModelFile)normalRailOn, normalRail, arg_0), arg_0 -> FramedBlockStateProvider.lambda$registerFramedFancyPoweredRail$14((ModelFile)ascendingRailOn, ascendingRail, arg_0), state -> null), new Property[]{BlockStateProperties.f_61362_, FramedProperties.GLOWING});
    }

    private void registerFramedFancyDetectorRail() {
        ModelFile normalRail = this.existingBlock(FBContent.blockFramedFancyDetectorRail);
        ModelBuilder normalRailOn = ((BlockModelBuilder)((BlockModelBuilder)this.block(FBContent.blockFramedFancyDetectorRail, "on").parent(normalRail)).texture("texture", this.mcLoc("block/detector_rail_on"))).texture("particle", this.mcLoc("block/detector_rail_on"));
        ModelFile ascendingRail = this.existingBlock(FBContent.blockFramedFancyDetectorRail, "ascending");
        ModelBuilder ascendingRailOn = ((BlockModelBuilder)((BlockModelBuilder)this.block(FBContent.blockFramedFancyDetectorRail, "ascending_on").parent(ascendingRail)).texture("texture", this.mcLoc("block/detector_rail_on"))).texture("particle", this.mcLoc("block/detector_rail_on"));
        this.getVariantBuilder((Block)FBContent.blockFramedFancyDetectorRail.get()).forAllStatesExcept(FramedBlockStateProvider.railStates((EnumProperty<RailShape>)BlockStateProperties.f_61404_, arg_0 -> FramedBlockStateProvider.lambda$registerFramedFancyDetectorRail$16((ModelFile)normalRailOn, normalRail, arg_0), arg_0 -> FramedBlockStateProvider.lambda$registerFramedFancyDetectorRail$17((ModelFile)ascendingRailOn, ascendingRail, arg_0), state -> null), new Property[]{BlockStateProperties.f_61362_, FramedProperties.GLOWING});
    }

    private void registerFramedFancyActivatorRail() {
        ModelFile normalRail = this.existingBlock(FBContent.blockFramedFancyActivatorRail);
        ModelBuilder normalRailOn = ((BlockModelBuilder)((BlockModelBuilder)this.block(FBContent.blockFramedFancyActivatorRail, "on").parent(normalRail)).texture("texture", this.mcLoc("block/activator_rail_on"))).texture("particle", this.mcLoc("block/activator_rail_on"));
        ModelFile ascendingRail = this.existingBlock(FBContent.blockFramedFancyActivatorRail, "ascending");
        ModelBuilder ascendingRailOn = ((BlockModelBuilder)((BlockModelBuilder)this.block(FBContent.blockFramedFancyActivatorRail, "ascending_on").parent(ascendingRail)).texture("texture", this.mcLoc("block/activator_rail_on"))).texture("particle", this.mcLoc("block/activator_rail_on"));
        this.getVariantBuilder((Block)FBContent.blockFramedFancyActivatorRail.get()).forAllStatesExcept(FramedBlockStateProvider.railStates((EnumProperty<RailShape>)BlockStateProperties.f_61404_, arg_0 -> FramedBlockStateProvider.lambda$registerFramedFancyActivatorRail$19((ModelFile)normalRailOn, normalRail, arg_0), arg_0 -> FramedBlockStateProvider.lambda$registerFramedFancyActivatorRail$20((ModelFile)ascendingRailOn, ascendingRail, arg_0), state -> null), new Property[]{BlockStateProperties.f_61362_, FramedProperties.GLOWING});
    }

    private void registerFramedMiniCube(ModelFile cube) {
        this.simpleBlock((Block)FBContent.blockFramedMiniCube.get(), cube);
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.itemModels().withExistingParent("framed_mini_cube", this.mcLoc("block/block"))).element().from(4.0f, 0.0f, 4.0f).to(12.0f, 8.0f, 12.0f).allFaces((d, f) -> f.uvs(0.0f, 0.0f, 16.0f, 16.0f)).textureAll("#all").end()).texture("all", this.TEXTURE)).renderType("cutout");
    }

    private void registerFramedOneWayWindow() {
        BlockModelBuilder model = this.makeUnderlayedCube("framed_one_way_window", this.mcLoc("block/moss_block"));
        this.simpleBlockWithItem(FBContent.blockFramedOneWayWindow, (ModelFile)model);
    }

    private void registerFramingSaw() {
        ModelFile.ExistingModelFile model = this.models().getExistingFile(this.modLoc("block/framing_saw"));
        this.getVariantBuilder((Block)FBContent.blockFramingSaw.get()).forAllStates(arg_0 -> FramedBlockStateProvider.lambda$registerFramingSaw$23((ModelFile)model, arg_0));
        this.simpleBlockItem(FBContent.blockFramingSaw, (ModelFile)model);
    }

    private BlockModelBuilder block(RegistryObject<Block> block) {
        return this.block(block, "");
    }

    private BlockModelBuilder block(RegistryObject<Block> block, String suffix) {
        String name = block.getId().m_135815_();
        String path = "block/" + name;
        if (!suffix.isBlank()) {
            path = path + "_" + suffix;
        }
        return (BlockModelBuilder)this.models().getBuilder(path);
    }

    private ModelFile existingBlock(RegistryObject<Block> block) {
        return this.existingBlock(block, "");
    }

    private ModelFile existingBlock(RegistryObject<Block> block, String suffix) {
        ResourceLocation name = block.getId();
        String path = "block/" + name.m_135815_();
        if (!suffix.isBlank()) {
            path = path + "_" + suffix;
        }
        return this.models().getExistingFile(new ResourceLocation(name.m_135827_(), path));
    }

    private ItemModelBuilder simpleBlockWithItem(RegistryObject<Block> block, ModelFile model, String itemRenderType) {
        return (ItemModelBuilder)this.simpleBlockWithItem(block, model).renderType(itemRenderType);
    }

    private ItemModelBuilder simpleBlockWithItem(RegistryObject<Block> block, ModelFile model) {
        this.simpleBlock((Block)block.get(), model);
        return this.simpleBlockItem(block, model);
    }

    private ItemModelBuilder simpleBlockItem(RegistryObject<Block> block, ModelFile model, String renderType) {
        return (ItemModelBuilder)this.simpleBlockItem(block, model).renderType(renderType);
    }

    private ItemModelBuilder simpleBlockItem(RegistryObject<Block> block, ModelFile model) {
        return (ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(block.getId().m_135815_())).parent(model);
    }

    private ItemModelBuilder simpleItem(RegistryObject<Block> block, String renderType) {
        return this.simpleItem(block.getId().m_135815_(), renderType);
    }

    private ItemModelBuilder simpleItem(RegistryObject<Block> block, String texture, String renderType) {
        return this.simpleItem(block.getId().m_135815_(), texture, renderType);
    }

    private ItemModelBuilder simpleItem(String name, String renderType) {
        return this.simpleItem(name, "item/" + name, renderType);
    }

    private ItemModelBuilder simpleItem(String name, String texture, String renderType) {
        return (ItemModelBuilder)((ItemModelBuilder)this.itemModels().singleTexture(name, this.mcLoc("item/generated"), "layer0", this.modLoc(texture))).renderType(renderType);
    }

    private BlockModelBuilder makeUnderlayedCube(String name, ResourceLocation underlayTex) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, "block/block")).element().cube("#underlay").end()).element().cube("#frame").end()).texture("frame", this.TEXTURE)).texture("underlay", underlayTex)).texture("particle", this.TEXTURE)).renderType("cutout");
    }

    private void makeOverlayModel(ResourceLocation name, ResourceLocation parent, String textureKey, ResourceLocation texture) {
        this.makeOverlayModel(name, parent, textureKey, texture, null);
    }

    private void makeOverlayModel(ResourceLocation name, ResourceLocation parent, String textureKey, ResourceLocation texture, Vector3f center) {
        OverlayLoaderBuilder builder = ((OverlayLoaderBuilder)((BlockModelBuilder)this.models().getBuilder(name.m_135815_())).customLoader(OverlayLoaderBuilder::new)).model((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)this.models().getExistingFile(parent))).texture(textureKey, texture));
        if (center != null) {
            builder.center(center);
        }
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerFramingSaw$23(ModelFile model, BlockState state) {
        int rotY = (int)((Direction)state.m_61143_((Property)FramedProperties.FACING_HOR)).m_122435_();
        return ConfiguredModel.builder().rotationY(rotY).modelFile(model).build();
    }

    private static /* synthetic */ ModelFile lambda$registerFramedFancyActivatorRail$20(ModelFile ascendingRailOn, ModelFile ascendingRail, BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_) != false ? ascendingRailOn : ascendingRail;
    }

    private static /* synthetic */ ModelFile lambda$registerFramedFancyActivatorRail$19(ModelFile normalRailOn, ModelFile normalRail, BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_) != false ? normalRailOn : normalRail;
    }

    private static /* synthetic */ ModelFile lambda$registerFramedFancyDetectorRail$17(ModelFile ascendingRailOn, ModelFile ascendingRail, BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_) != false ? ascendingRailOn : ascendingRail;
    }

    private static /* synthetic */ ModelFile lambda$registerFramedFancyDetectorRail$16(ModelFile normalRailOn, ModelFile normalRail, BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_) != false ? normalRailOn : normalRail;
    }

    private static /* synthetic */ ModelFile lambda$registerFramedFancyPoweredRail$14(ModelFile ascendingRailOn, ModelFile ascendingRail, BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_) != false ? ascendingRailOn : ascendingRail;
    }

    private static /* synthetic */ ModelFile lambda$registerFramedFancyPoweredRail$13(ModelFile normalRailOn, ModelFile normalRail, BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_) != false ? normalRailOn : normalRail;
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerFramedChest$5(ModelFile chest, BlockState state) {
        Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        int rotY = ((int)dir.m_122435_() + 180) % 360;
        return ConfiguredModel.builder().modelFile(chest).rotationY(rotY).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerFramedRedstoneWallTorch$4(ModelFile wallTorch, ModelFile wallTorchOff, BlockState state) {
        Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        int rotY = ((int)dir.m_122435_() + 90) % 360;
        ModelFile model = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? wallTorch : wallTorchOff;
        return ConfiguredModel.builder().modelFile(model).rotationY(rotY).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerFramedRedstoneTorch$3(ModelFile torch, ModelFile torchOff, BlockState state) {
        ModelFile model = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? torch : torchOff;
        return ConfiguredModel.builder().modelFile(model).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerFramedSoulWallTorch$2(ModelFile wallTorch, BlockState state) {
        Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        int rotY = ((int)dir.m_122435_() + 90) % 360;
        return ConfiguredModel.builder().modelFile(wallTorch).rotationY(rotY).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerFramedWallTorch$1(ModelFile wallTorch, BlockState state) {
        Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        int rotY = ((int)dir.m_122435_() + 90) % 360;
        return ConfiguredModel.builder().modelFile(wallTorch).rotationY(rotY).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerFramedLever$0(ModelFile leverOn, ModelFile lever, BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        AttachFace face = (AttachFace)state.m_61143_((Property)FaceAttachedHorizontalDirectionalBlock.f_53179_);
        boolean powered = (Boolean)state.m_61143_((Property)LeverBlock.f_54622_);
        int rotY = (int)(facing.m_122435_() + 180.0f) % 360;
        int rotX = face.ordinal() * 90;
        ModelFile model = powered ? leverOn : lever;
        return ConfiguredModel.builder().modelFile(model).rotationX(rotX).rotationY(rotY).build();
    }
}

