/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.menu;

import java.util.Arrays;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.crafting.FramingSawRecipe;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeCache;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeCalculation;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeMatchResult;
import xfacthd.framedblocks.common.util.FramedUtils;

public class FramingSawMenu
extends AbstractContainerMenu {
    public static final int SLOT_INPUT = 0;
    private static final int SLOT_ADDITIVE_FIRST = 1;
    public static final int SLOT_RESULT = 4;
    public static final int SLOT_INV_FIRST = 5;
    public static final int INV_SLOT_COUNT = 36;
    public static final int TOTAL_SLOT_COUNT = 41;
    private final Level level;
    private final Slot inputSlot;
    private final Slot[] additiveSlots;
    private final Slot resultSlot;
    private final ContainerLevelAccess levelAccess;
    private final Container inputContainer = new FrameCrafterContainer(this);
    private final ResultContainer resultContainer = new ResultContainer();
    private final DataSlot selectedRecipeIdx = DataSlot.m_39401_();
    private final FramingSawRecipeCache cache;
    private final List<RecipeHolder> recipes;
    private final ItemStack[] lastAdditives;
    private ItemStack lastInput = ItemStack.f_41583_;
    private FramingSawRecipe selectedRecipe = null;
    private boolean recipeChanged = false;

    public FramingSawMenu(int containerId, Inventory inv, ContainerLevelAccess levelAccess) {
        super((MenuType)FBContent.menuTypeFramingSaw.get(), containerId);
        this.level = inv.f_35978_.f_19853_;
        this.levelAccess = levelAccess;
        this.inputSlot = this.m_38897_(new Slot(this.inputContainer, 0, 20, 28));
        this.additiveSlots = new Slot[3];
        for (int i = 0; i < this.additiveSlots.length; ++i) {
            int y = 64 + i * 18;
            this.additiveSlots[i] = this.m_38897_(new Slot(this.inputContainer, 1 + i, 20, y));
        }
        this.resultSlot = this.m_38897_(new ResultSlot(this, (Container)this.resultContainer, 0, 223, 64));
        this.lastAdditives = new ItemStack[3];
        Arrays.fill(this.lastAdditives, ItemStack.f_41583_);
        FramedUtils.addPlayerInvSlots(x$0 -> this.m_38897_((Slot)x$0), inv, 48, 151);
        this.m_38895_(this.selectedRecipeIdx);
        this.cache = FramingSawRecipeCache.get(this.level.m_5776_());
        this.recipes = this.cache.getRecipes().stream().map(RecipeHolder::new).toList();
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack remainder = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            remainder = stack.m_41777_();
            if (index == 4) {
                stack.m_41720_().m_7836_(stack, player.f_19853_, player);
                if (!this.m_38903_(stack, 5, this.f_38839_.size(), true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(stack, remainder);
            } else if (index < 5 ? !this.m_38903_(stack, 5, this.f_38839_.size(), true) : (this.cache.getMaterialValue(stack.m_41720_()) > 0 ? !this.m_38903_(stack, 0, 1, false) : !this.m_38903_(stack, 1, 4, false))) {
                return ItemStack.f_41583_;
            }
            if (stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stack.m_41613_() == remainder.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, stack);
            this.m_38946_();
        }
        return remainder;
    }

    public boolean m_6366_(Player player, int id) {
        if (this.isValidRecipeIndex(id)) {
            this.selectedRecipeIdx.m_6422_(id);
            this.selectedRecipe = this.recipes.get((int)id).recipe;
            this.setupResultSlot();
            this.recipeChanged = true;
        }
        return true;
    }

    public void m_6199_(Container inventory) {
        boolean changed = false;
        ItemStack input = this.inputSlot.m_7993_();
        if (!input.m_150930_(this.lastInput.m_41720_()) || input.m_41613_() != this.lastInput.m_41613_()) {
            this.lastInput = input.m_41777_();
            changed = true;
        }
        for (int i = 0; i < this.additiveSlots.length; ++i) {
            ItemStack additive = this.additiveSlots[i].m_7993_();
            if (additive.m_150930_(this.lastAdditives[i].m_41720_()) && additive.m_41613_() == this.lastAdditives[i].m_41613_()) continue;
            this.lastAdditives[i] = additive.m_41777_();
            changed = true;
        }
        if (changed) {
            for (RecipeHolder holder : this.recipes) {
                holder.matchResult = holder.recipe.matchWithResult(this.inputContainer, this.level);
            }
            this.setupResultSlot();
        }
    }

    private void setupResultSlot() {
        if (this.isValidRecipeIndex(this.selectedRecipeIdx.m_6501_())) {
            RecipeHolder holder = this.recipes.get(this.selectedRecipeIdx.m_6501_());
            if (holder.matchResult.success()) {
                FramingSawRecipe recipe = holder.recipe;
                FramingSawRecipeCalculation calc = recipe.makeCraftingCalculation(this.inputContainer, this.level.m_5776_());
                ItemStack result = recipe.m_5874_(this.inputContainer, this.level.m_9598_());
                result.m_41764_(calc.getOutputCount());
                this.resultContainer.m_6029_((Recipe)recipe);
                this.resultSlot.m_5852_(result);
                this.selectedRecipe = recipe;
                this.m_38946_();
                return;
            }
        }
        this.resultSlot.m_5852_(ItemStack.f_41583_);
        this.selectedRecipe = null;
        this.m_38946_();
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        return slot.f_40219_ != 4 && super.m_5882_(stack, slot);
    }

    public boolean m_6875_(Player player) {
        return FramingSawMenu.m_38889_((ContainerLevelAccess)this.levelAccess, (Player)player, (Block)((Block)FBContent.blockFramingSaw.get()));
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.resultContainer.m_8016_(1);
        this.levelAccess.m_39292_((level, pos) -> this.m_150411_(player, this.inputContainer));
    }

    public Container getInputContainer() {
        return this.inputContainer;
    }

    public ItemStack getInputStack() {
        return this.inputSlot.m_7993_();
    }

    public ItemStack getAdditiveStack(int slot) {
        return this.additiveSlots[slot].m_7993_();
    }

    public List<RecipeHolder> getRecipes() {
        return this.recipes;
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipeIdx.m_6501_();
    }

    public boolean hasRecipeChanged() {
        boolean changed = this.recipeChanged;
        this.recipeChanged = false;
        return changed;
    }

    public boolean isValidRecipeIndex(int idx) {
        return idx >= 0 && idx < this.recipes.size();
    }

    private static class FrameCrafterContainer
    extends SimpleContainer {
        private final FramingSawMenu menu;

        FrameCrafterContainer(FramingSawMenu menu) {
            super(4);
            this.menu = menu;
        }

        public void m_6596_() {
            super.m_6596_();
            this.menu.m_6199_((Container)this);
        }
    }

    private static class ResultSlot
    extends Slot {
        private final FramingSawMenu menu;

        ResultSlot(FramingSawMenu menu, Container container, int index, int x, int y) {
            super(container, index, x, y);
            this.menu = menu;
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            return false;
        }

        public void m_142406_(Player player, ItemStack stack) {
            stack.m_41678_(player.f_19853_, player, stack.m_41613_());
            this.menu.resultContainer.m_8015_(player);
            FramingSawRecipeCalculation calc = this.menu.selectedRecipe.makeCraftingCalculation(this.menu.inputContainer, this.menu.level.m_5776_());
            int additiveCount = this.menu.selectedRecipe.getAdditives().size();
            this.menu.inputSlot.m_6201_(calc.getInputCount());
            for (int i = 0; i < additiveCount; ++i) {
                this.menu.additiveSlots[i].m_6201_(calc.getAdditiveCount(i));
            }
            super.m_142406_(player, stack);
        }
    }

    public static class RecipeHolder {
        private final FramingSawRecipe recipe;
        private FramingSawRecipeMatchResult matchResult = FramingSawRecipeMatchResult.MATERIAL_VALUE;

        private RecipeHolder(FramingSawRecipe recipe) {
            this.recipe = recipe;
        }

        public FramingSawRecipe getRecipe() {
            return this.recipe;
        }

        public FramingSawRecipeMatchResult getMatchResult() {
            return this.matchResult;
        }
    }
}

