/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.util;

import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.SlopeType;

public final class FramedUtils {
    public static boolean isFramedRailSlope(BlockState state) {
        Block block = state.m_60734_();
        if (block instanceof BaseRailBlock && block instanceof IFramedBlock) {
            return state.m_61138_(PropertyHolder.ASCENDING_RAIL_SHAPE);
        }
        return false;
    }

    public static boolean isRailItem(Item item) {
        return item == Items.f_41964_ || item == Items.f_41860_ || item == Items.f_41861_ || item == Items.f_42161_ || item == ((Block)FBContent.blockFramedFancyRail.get()).m_5456_() || item == ((Block)FBContent.blockFramedFancyPoweredRail.get()).m_5456_() || item == ((Block)FBContent.blockFramedFancyDetectorRail.get()).m_5456_() || item == ((Block)FBContent.blockFramedFancyActivatorRail.get()).m_5456_();
    }

    public static Block getRailSlopeBlock(Item item) {
        if (item == Items.f_41964_) {
            return (Block)FBContent.blockFramedRailSlope.get();
        }
        if (item == Items.f_41860_) {
            return (Block)FBContent.blockFramedPoweredRailSlope.get();
        }
        if (item == Items.f_41861_) {
            return (Block)FBContent.blockFramedDetectorRailSlope.get();
        }
        if (item == Items.f_42161_) {
            return (Block)FBContent.blockFramedActivatorRailSlope.get();
        }
        if (item == ((Block)FBContent.blockFramedFancyRail.get()).m_5456_()) {
            return (Block)FBContent.blockFramedFancyRailSlope.get();
        }
        if (item == ((Block)FBContent.blockFramedFancyPoweredRail.get()).m_5456_()) {
            return (Block)FBContent.blockFramedFancyPoweredRailSlope.get();
        }
        if (item == ((Block)FBContent.blockFramedFancyDetectorRail.get()).m_5456_()) {
            return (Block)FBContent.blockFramedFancyDetectorRailSlope.get();
        }
        if (item == ((Block)FBContent.blockFramedFancyActivatorRail.get()).m_5456_()) {
            return (Block)FBContent.blockFramedFancyActivatorRailSlope.get();
        }
        throw new IllegalStateException("Invalid rail item: " + item);
    }

    public static Direction getSlopeBlockFacing(BlockState state) {
        if (FramedUtils.isFramedRailSlope(state)) {
            return FramedUtils.getDirectionFromAscendingRailShape((RailShape)state.m_61143_(PropertyHolder.ASCENDING_RAIL_SHAPE));
        }
        return (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
    }

    public static SlopeType getSlopeType(BlockState state) {
        if (FramedUtils.isFramedRailSlope(state)) {
            return SlopeType.BOTTOM;
        }
        return (SlopeType)((Object)state.m_61143_(PropertyHolder.SLOPE_TYPE));
    }

    public static RailShape getAscendingRailShapeFromDirection(Direction dir) {
        return switch (dir) {
            case Direction.NORTH -> RailShape.ASCENDING_NORTH;
            case Direction.EAST -> RailShape.ASCENDING_EAST;
            case Direction.SOUTH -> RailShape.ASCENDING_SOUTH;
            case Direction.WEST -> RailShape.ASCENDING_WEST;
            default -> throw new IllegalArgumentException("Invalid facing " + dir);
        };
    }

    public static Direction getDirectionFromAscendingRailShape(RailShape shape) {
        return switch (shape) {
            case RailShape.ASCENDING_NORTH -> Direction.NORTH;
            case RailShape.ASCENDING_EAST -> Direction.EAST;
            case RailShape.ASCENDING_SOUTH -> Direction.SOUTH;
            case RailShape.ASCENDING_WEST -> Direction.WEST;
            default -> throw new IllegalArgumentException("Invalid shape " + shape);
        };
    }

    public static void enqueueImmediateTask(LevelAccessor level, Runnable task, boolean allowClient) {
        if (level.m_5776_() && allowClient) {
            task.run();
        } else {
            FramedUtils.enqueueTask(level, task, 0);
        }
    }

    public static void enqueueTask(LevelAccessor level, Runnable task, int delay) {
        if (!(level instanceof ServerLevel)) {
            throw new IllegalArgumentException("Utils#enqueueTask() called with a non-ServerWorld");
        }
        ServerLevel slevel = (ServerLevel)level;
        MinecraftServer server = slevel.m_7654_();
        server.m_6937_((Runnable)new TickTask(server.m_129921_() + delay, task));
    }

    public static void addPlayerInvSlots(Consumer<Slot> slotConsumer, Inventory playerInv, int x, int y) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                slotConsumer.accept(new Slot((Container)playerInv, col + row * 9 + 9, x + col * 18, y));
            }
            y += 18;
        }
        for (int col = 0; col < 9; ++col) {
            slotConsumer.accept(new Slot((Container)playerInv, col, x + col * 18, y + 4));
        }
    }

    private FramedUtils() {
    }
}

