/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.util;

import java.util.Collection;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;

public final class AttributeHelper {
    public static double getAttackDamage(ItemStack stack) {
        return AttributeHelper.calculateValue(stack, Attributes.f_22281_, EquipmentSlot.MAINHAND);
    }

    public static double getAttackSpeed(ItemStack stack) {
        return AttributeHelper.calculateValue(stack, Attributes.f_22283_, EquipmentSlot.MAINHAND);
    }

    public static double getAttackKnockback(ItemStack stack) {
        return AttributeHelper.calculateValue(stack, Attributes.f_22282_, EquipmentSlot.MAINHAND);
    }

    public static double calculateValue(ItemStack stack, Attribute attribute, EquipmentSlot slot) {
        return AttributeHelper.calculateValue(attribute, stack.m_41638_(slot).get((Object)attribute));
    }

    public static double calculateValue(Attribute attribute, Collection<AttributeModifier> modifiers) {
        return attribute.m_6740_(AttributeHelper.calculateValue(modifiers, attribute.m_22082_()));
    }

    public static double calculateValue(Collection<AttributeModifier> modifiers, double baseValue) {
        double baseTotal = baseValue;
        for (AttributeModifier modifier : modifiers) {
            if (modifier.m_22217_() != AttributeModifier.Operation.ADDITION) continue;
            baseTotal += modifier.m_22218_();
        }
        double modifiedValue = baseTotal;
        for (AttributeModifier modifier : modifiers) {
            if (modifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE) continue;
            modifiedValue += baseTotal * modifier.m_22218_();
        }
        for (AttributeModifier modifier : modifiers) {
            if (modifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL) continue;
            modifiedValue *= 1.0 + modifier.m_22218_();
        }
        return modifiedValue;
    }
}

