/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Logger;

public final class BlockUtils {
    private BlockUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static Collection<ResourceLocation> getMissingLootTables(String modId, ServerLevel world) {
        LootTables lootTableManager = world.m_7654_().m_129898_();
        ArrayList<ResourceLocation> missing = new ArrayList<ResourceLocation>();
        for (Block block : ForgeRegistries.BLOCKS.getValues()) {
            ResourceLocation lootTable = block.m_60589_();
            if (!lootTable.m_135827_().equals(modId) || block instanceof AirBlock || lootTableManager.m_79195_().contains(lootTable)) continue;
            missing.add(lootTable);
        }
        return missing;
    }

    @Nullable
    public static Component checkAndReportMissingLootTables(String modId, ServerLevel world, @Nullable Logger logger) {
        LootTables lootTableManager = world.m_7654_().m_129898_();
        Collection<ResourceLocation> missing = BlockUtils.getMissingLootTables(modId, world);
        if (!missing.isEmpty()) {
            if (logger != null) {
                missing.forEach(id -> logger.error("Missing block loot table '{}'", id));
            }
            String list = missing.stream().map(ResourceLocation::toString).collect(Collectors.joining(", "));
            return Component.m_237113_((String)("The following block loot tables are missing: " + list)).m_130940_(ChatFormatting.RED);
        }
        return null;
    }
}

