/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.firstperson.mixins;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.tr7zw.firstperson.FirstPersonModelCore;
import dev.tr7zw.firstperson.access.AgeableListModelAccess;
import dev.tr7zw.firstperson.access.PlayerAccess;
import dev.tr7zw.firstperson.access.PlayerModelAccess;
import dev.tr7zw.firstperson.versionless.mixinbase.ModelPartBase;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.VillagerHeadModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntityRenderer.class})
public abstract class LivingEntityRendererMixin {
    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/model/EntityModel;setupAnim(Lnet/minecraft/world/entity/Entity;FFFFF)V", shift=At.Shift.AFTER)}, cancellable=true)
    public void renderPostAnim(LivingEntity livingEntity, float f, float g, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, CallbackInfo info) {
        PlayerAccess playerAccess;
        if (!FirstPersonModelCore.instance.isRenderingPlayer()) {
            return;
        }
        if (livingEntity instanceof Shulker) {
            return;
        }
        EntityModel<LivingEntity> model = this.m_7200_();
        boolean headShouldBeHidden = false;
        if (model instanceof AgeableListModelAccess) {
            AgeableListModelAccess agable = (AgeableListModelAccess)model;
            agable.firstPersonHeadPartsGetter().forEach(part -> ((ModelPartBase)part).setHidden());
            headShouldBeHidden = true;
        }
        if (model instanceof HeadedModel) {
            HeadedModel headed = (HeadedModel)model;
            ((ModelPartBase)headed.m_5585_()).setHidden();
            headShouldBeHidden = true;
        }
        if (model instanceof HumanoidModel) {
            HumanoidModel humanModel = (HumanoidModel)model;
            if (livingEntity instanceof PlayerAccess) {
                playerAccess = (PlayerAccess)livingEntity;
                if (FirstPersonModelCore.instance.getLogicHandler().showVanillaHands(playerAccess.getInventory().m_36056_(), (ItemStack)playerAccess.getInventory().f_35976_.get(0))) {
                    ((ModelPartBase)humanModel.f_102812_).setHidden();
                    ((ModelPartBase)humanModel.f_102811_).setHidden();
                }
            }
        }
        if (model instanceof VillagerHeadModel) {
            VillagerHeadModel villaterHead = (VillagerHeadModel)model;
            villaterHead.m_7491_(false);
        }
        if (model instanceof PlayerModel) {
            PlayerModel playerModel = (PlayerModel)model;
            headShouldBeHidden = true;
            ((ModelPartBase)playerModel.f_102809_).setHidden();
            if (livingEntity instanceof PlayerAccess) {
                playerAccess = (PlayerAccess)livingEntity;
                if (FirstPersonModelCore.instance.getLogicHandler().showVanillaHands(playerAccess.getInventory().m_36056_(), (ItemStack)playerAccess.getInventory().f_35976_.get(0))) {
                    ((ModelPartBase)playerModel.f_103374_).setHidden();
                    ((ModelPartBase)playerModel.f_103375_).setHidden();
                }
            }
        }
        if (livingEntity instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)livingEntity;
            EntityModel<LivingEntity> entityModel = model;
            if (entityModel instanceof PlayerModel) {
                PlayerModel playerModel = (PlayerModel)entityModel;
                if (FirstPersonModelCore.instance.getLogicHandler().isSwimming((Player)player)) {
                    ((ModelPartBase)playerModel.f_102810_).setHidden();
                    ((ModelPartBase)((PlayerModelAccess)model).getCloak()).setHidden();
                }
            }
        }
        if (!headShouldBeHidden) {
            matrixStack.m_85849_();
            info.cancel();
        }
    }

    @Inject(method={"render"}, at={@At(value="RETURN")})
    public void renderReturn(LivingEntity livingEntity, float f, float g, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, CallbackInfo info) {
        EntityModel<LivingEntity> entityModel;
        PlayerModel playerModel;
        if (!FirstPersonModelCore.instance.isRenderingPlayer()) {
            return;
        }
        EntityModel<LivingEntity> model = this.m_7200_();
        if (model instanceof AgeableListModelAccess) {
            AgeableListModelAccess agable = (AgeableListModelAccess)model;
            agable.firstPersonHeadPartsGetter().forEach(part -> ((ModelPartBase)part).showAgain());
        }
        if (model instanceof HeadedModel) {
            HeadedModel headed = (HeadedModel)model;
            ((ModelPartBase)headed.m_5585_()).showAgain();
        }
        if (model instanceof HumanoidModel) {
            HumanoidModel humanModel = (HumanoidModel)model;
            if (FirstPersonModelCore.instance.getLogicHandler().showVanillaHands()) {
                ((ModelPartBase)humanModel.f_102812_).showAgain();
                ((ModelPartBase)humanModel.f_102811_).showAgain();
            }
        }
        if (model instanceof VillagerHeadModel) {
            VillagerHeadModel villaterHead = (VillagerHeadModel)model;
            villaterHead.m_7491_(false);
        }
        if (model instanceof PlayerModel) {
            playerModel = (PlayerModel)model;
            ((ModelPartBase)playerModel.f_102809_).showAgain();
            if (FirstPersonModelCore.instance.getLogicHandler().showVanillaHands()) {
                ((ModelPartBase)playerModel.f_103374_).showAgain();
                ((ModelPartBase)playerModel.f_103375_).showAgain();
            }
        }
        if ((entityModel = model) instanceof PlayerModel) {
            playerModel = (PlayerModel)entityModel;
            ((ModelPartBase)playerModel.f_102810_).showAgain();
            ((ModelPartBase)((PlayerModelAccess)model).getCloak()).showAgain();
        }
        FirstPersonModelCore.instance.setRenderingPlayer(false);
    }

    @Shadow
    public abstract EntityModel<LivingEntity> m_7200_();
}

