/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_backpacks.recipe;

import com.google.common.collect.Lists;
import info.u_team.u_team_core.api.dye.DyeableItem;
import info.u_team.u_team_core.recipeserializer.UShapedRecipeSerializer;
import info.u_team.u_team_core.util.ColorUtil;
import info.u_team.useful_backpacks.init.UsefulBackpacksRecipeSerializers;
import info.u_team.useful_backpacks.item.BackpackItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;

public class BackpackCraftingRecipe
extends ShapedRecipe {
    public BackpackCraftingRecipe(ResourceLocation id, String group, CraftingBookCategory category, int width, int height, NonNullList<Ingredient> ingredients, ItemStack output, boolean showNotification) {
        super(id, group, category, width, height, ingredients, output, showNotification);
    }

    public ItemStack m_5874_(CraftingContainer inventory, RegistryAccess registryAccess) {
        ItemStack backpackItem = super.m_5874_(inventory, registryAccess);
        ArrayList dyeList = Lists.newArrayList();
        boolean backpackPresent = false;
        for (int index = 0; index < inventory.m_6643_(); ++index) {
            DyeColor color2;
            ItemStack slotStack = inventory.m_8020_(index);
            if (slotStack.m_41619_()) continue;
            Item item = slotStack.m_41720_();
            if (item instanceof BackpackItem) {
                if (backpackPresent) {
                    return ItemStack.f_41583_;
                }
                backpackPresent = true;
                if (!slotStack.m_41782_()) continue;
                backpackItem.m_41751_(slotStack.m_41783_().m_6426_());
                continue;
            }
            if (!slotStack.m_204117_(ItemTags.f_13167_) || (color2 = ColorUtil.getColorFromWool((Item)item)) == null) continue;
            dyeList.add(color2);
        }
        if (!dyeList.isEmpty() && !dyeList.parallelStream().allMatch(color -> color == DyeColor.WHITE)) {
            return DyeableItem.colorStack((ItemStack)backpackItem, (List)dyeList);
        }
        return backpackItem;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)UsefulBackpacksRecipeSerializers.BACKPACK.get();
    }

    public static class Serializer
    extends UShapedRecipeSerializer<BackpackCraftingRecipe> {
        protected BackpackCraftingRecipe createRecipe(ResourceLocation location, String group, CraftingBookCategory category, int recipeWidth, int recipeHeight, NonNullList<Ingredient> ingredients, ItemStack output, boolean showNotification) {
            return new BackpackCraftingRecipe(location, group, category, recipeWidth, recipeHeight, ingredients, output, showNotification);
        }
    }
}

