/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.blocks;

import com.google.common.collect.ImmutableList;
import einstein.jmc.blocks.BaseCakeBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FireChargeItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BaseCandleCakeBlock
extends AbstractCandleBlock {
    public static final BooleanProperty LIT = AbstractCandleBlock.f_151895_;
    protected static final VoxelShape SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.m_49796_((double)7.0, (double)8.0, (double)7.0, (double)9.0, (double)14.0, (double)9.0));
    private final BaseCakeBlock originalCake;

    public BaseCandleCakeBlock(BaseCakeBlock originalCake, BlockBehaviour.Properties properties) {
        super(properties);
        this.originalCake = originalCake;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected Iterable<Vec3> m_142199_(BlockState state) {
        return ImmutableList.of((Object)new Vec3(0.5, 1.0, 0.5));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!itemstack.m_150930_(Items.f_42409_) && !itemstack.m_150930_(Items.f_42613_)) {
            if (this.candleHit(hitResult) && player.m_21120_(hand).m_41619_() && ((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
                BaseCandleCakeBlock.m_151899_((Player)player, (BlockState)state, (LevelAccessor)level, (BlockPos)pos);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            InteractionResult interactionresult = this.originalCake.eat(level, pos, this.originalCake.m_49966_(), player);
            if (interactionresult.m_19077_()) {
                BaseCandleCakeBlock.m_49950_((BlockState)state, (Level)level, (BlockPos)pos);
            }
            return interactionresult;
        }
        if (!((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            level.m_5594_(player, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.4f + 0.8f);
            level.m_7731_(pos, (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)), 11);
            level.m_142346_((Entity)player, GameEvent.f_157797_, pos);
            itemstack.m_41622_(1, (LivingEntity)player, player1 -> player1.m_21190_(player.m_7655_()));
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        Item heldItem = player.m_21205_().m_41720_();
        if (heldItem instanceof FlintAndSteelItem || heldItem instanceof FireChargeItem) {
            return heldItem.m_6225_(new UseOnContext(player, hand, hitResult));
        }
        return InteractionResult.PASS;
    }

    protected boolean candleHit(BlockHitResult hitResult) {
        return hitResult.m_82450_().f_82480_ - (double)hitResult.m_82425_().m_123342_() > this.getCandleHeight();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIT});
    }

    public ItemStack m_7397_(BlockGetter getter, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)this.originalCake.m_5456_());
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor accessor, BlockPos pos, BlockPos neighborPos) {
        return direction == Direction.DOWN && !state.m_60710_((LevelReader)accessor, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, neighborState, accessor, pos, neighborPos);
    }

    public boolean m_7898_(BlockState state, LevelReader reader, BlockPos pos) {
        return reader.m_8055_(pos.m_7495_()).m_60767_().m_76333_();
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return 14;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public boolean m_7357_(BlockState state, BlockGetter getter, BlockPos pos, PathComputationType computation) {
        return false;
    }

    protected double getCandleHeight() {
        return 0.5;
    }

    public BaseCakeBlock getOriginalCake() {
        return this.originalCake;
    }
}

