/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.compat.rei;

import einstein.jmc.compat.rei.REIPlugin;
import einstein.jmc.item.crafting.CakeOvenRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.SimpleGridMenuDisplay;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.registry.RecipeManagerContext;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public class CakeOvenDisplay
extends BasicDisplay
implements SimpleGridMenuDisplay {
    private final float experience;
    private final int cookingTime;

    public CakeOvenDisplay(CakeOvenRecipe recipe) {
        this(EntryIngredients.ofIngredients(recipe.m_7527_()), Collections.singletonList(EntryIngredients.of((ItemStack)recipe.m_8043_(CakeOvenDisplay.registryAccess()))), recipe, recipe.getExperience(), recipe.getCookingTime());
    }

    public CakeOvenDisplay(List<EntryIngredient> ingredients, List<EntryIngredient> results, CompoundTag tag) {
        this(ingredients, results, (CakeOvenRecipe)RecipeManagerContext.getInstance().byId(tag, "location"), tag.m_128457_("experience"), tag.m_128451_("cookingTime"));
    }

    public CakeOvenDisplay(List<EntryIngredient> ingredients, List<EntryIngredient> results, CakeOvenRecipe recipe, float experience, int cookingTime) {
        super(CakeOvenDisplay.fillWithEmpty(ingredients), results, Optional.ofNullable(recipe).map(CakeOvenRecipe::m_6423_));
        this.experience = experience;
        this.cookingTime = cookingTime;
    }

    private static List<EntryIngredient> fillWithEmpty(List<EntryIngredient> inputs) {
        if (inputs.size() == 4) {
            return inputs;
        }
        ArrayList<EntryIngredient> ingredients = new ArrayList<EntryIngredient>(inputs);
        for (int i = 0; i < 4 - inputs.size(); ++i) {
            ingredients.add(EntryIngredients.of((ItemStack)ItemStack.f_41583_));
        }
        return ingredients;
    }

    public int getWidth() {
        return 2;
    }

    public int getHeight() {
        return 2;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return REIPlugin.CAKE_OVEN;
    }

    public float getExperience() {
        return this.experience;
    }

    public int getCookingTime() {
        return this.cookingTime;
    }

    public static BasicDisplay.Serializer<CakeOvenDisplay> serializer() {
        return BasicDisplay.Serializer.ofRecipeLess(CakeOvenDisplay::new, (display, tag) -> {
            tag.m_128350_("experience", display.getExperience());
            tag.m_128405_("cookingTime", display.getCookingTime());
        });
    }
}

