/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.data.providers;

import einstein.jmc.blocks.BaseCakeBlock;
import einstein.jmc.init.ModItems;
import einstein.jmc.util.CakeBuilder;
import einstein.jmc.util.Util;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ModItemModelProvider
extends ItemModelProvider {
    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "jmc", existingFileHelper);
    }

    protected void registerModels() {
        this.generatedItem(this.getItemName(ModItems.CUPCAKE), this.modLoc("item/" + this.getItemName(ModItems.CUPCAKE)));
        this.generatedItem(this.getItemName(ModItems.CREAM_CHEESE), this.modLoc("item/" + this.getItemName(ModItems.CREAM_CHEESE)));
        this.generatedItem("poison_cake", this.mcLoc("item/cake"));
        this.generatedItem("tnt_cake", this.mcLoc("item/cake"));
        ((ItemModelBuilder)this.getBuilder("encasing_ice")).parent((ModelFile)this.getExistingFile(this.mcLoc("block/ice")));
        ((ItemModelBuilder)this.getBuilder("cake_oven")).parent((ModelFile)this.getExistingFile(this.modLoc("block/cake_oven")));
        for (Supplier<BaseCakeBlock> cake : CakeBuilder.BUILDER_BY_CAKE.keySet()) {
            if (cake.get().getBuilder().hasCustomItemModel()) continue;
            this.generatedItem(this.getItemName(cake), this.modLoc("item/" + Util.getItemId(cake.get().m_5456_()).m_135815_()));
        }
    }

    private ItemModelBuilder generatedItem(String name, ResourceLocation ... layers) {
        ItemModelBuilder model = (ItemModelBuilder)this.withExistingParent(name, "item/generated");
        for (int i = 0; i < layers.length; ++i) {
            model = (ItemModelBuilder)model.texture("layer" + i, layers[i]);
        }
        return model;
    }

    private String getItemName(Supplier<? extends ItemLike> item) {
        return Util.getItemId(item.get().m_5456_()).m_135815_();
    }
}

