/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.item.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import einstein.jmc.item.crafting.CakeOvenRecipe;
import einstein.jmc.util.CakeOvenConstants;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;

public class CakeOvenRecipeSerializer<T extends CakeOvenRecipe>
implements RecipeSerializer<T>,
CakeOvenConstants {
    private final int defaultCookingTime;
    private final CakeOvenFactory<T> factory;

    public CakeOvenRecipeSerializer(CakeOvenFactory<T> factory, int defaultCooingTime) {
        this.defaultCookingTime = defaultCooingTime;
        this.factory = factory;
    }

    public T fromJson(ResourceLocation recipeId, JsonObject json) {
        ItemStack resultStack;
        NonNullList<Ingredient> ingredients = CakeOvenRecipeSerializer.itemsFromJson(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
        if (ingredients.isEmpty()) {
            throw new JsonParseException("No ingredients for cake oven recipe");
        }
        if (ingredients.size() > 4) {
            throw new JsonParseException("Too many ingredients for cake oven recipe. The max is 4");
        }
        String r = "result";
        if (!json.has(r)) {
            throw new JsonSyntaxException("Missing result, expected to find a string or object");
        }
        if (json.get(r).isJsonObject()) {
            resultStack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)r));
        } else {
            String resultString = GsonHelper.m_13906_((JsonObject)json, (String)r);
            ResourceLocation resourceLocation = new ResourceLocation(resultString);
            resultStack = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_6612_(resourceLocation).orElseThrow(() -> new IllegalStateException("Item: " + resultString + " does not exist")));
        }
        float experience = GsonHelper.m_13820_((JsonObject)json, (String)"experience", (float)0.0f);
        int cookingTime = GsonHelper.m_13824_((JsonObject)json, (String)"cookingTime", (int)this.defaultCookingTime);
        return this.factory.create(recipeId, ingredients, resultStack, experience, cookingTime);
    }

    private static NonNullList<Ingredient> itemsFromJson(JsonArray array) {
        NonNullList nonNullList = NonNullList.m_122779_();
        for (int i = 0; i < array.size(); ++i) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)array.get(i));
            if (ingredient.m_43947_()) continue;
            nonNullList.add((Object)ingredient);
        }
        return nonNullList;
    }

    public T fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buf) {
        ItemStack resultStack = buf.m_130267_();
        float experience = buf.readFloat();
        int cookTime = buf.m_130242_();
        int ingredientCount = buf.readByte();
        NonNullList ingredients = NonNullList.m_122780_((int)ingredientCount, (Object)Ingredient.f_43901_);
        for (int i = 0; i < ingredientCount; ++i) {
            ingredients.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
        }
        return this.factory.create(recipeId, (NonNullList<Ingredient>)ingredients, resultStack, experience, cookTime);
    }

    public void toNetwork(FriendlyByteBuf buf, T recipe) {
        buf.m_130055_(((CakeOvenRecipe)recipe).result);
        buf.writeFloat(((CakeOvenRecipe)recipe).experience);
        buf.m_130130_(((CakeOvenRecipe)recipe).cookingTime);
        buf.writeByte(((CakeOvenRecipe)recipe).ingredients.size());
        ((CakeOvenRecipe)recipe).ingredients.forEach(ingredient -> ingredient.m_43923_(buf));
    }

    public static interface CakeOvenFactory<T extends CakeOvenRecipe> {
        public T create(ResourceLocation var1, NonNullList<Ingredient> var2, ItemStack var3, float var4, int var5);
    }
}

