/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.data.trait;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gear.api.ApiConst;
import net.silentchaos512.gear.api.data.trait.TraitBuilder;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.api.util.DataResource;

public class AttributeTraitBuilder
extends TraitBuilder {
    private final Map<String, List<Modifier>> modifiers = new LinkedHashMap<String, List<Modifier>>();

    public AttributeTraitBuilder(DataResource<ITrait> trait, int maxLevel) {
        this(trait.getId(), maxLevel);
    }

    public AttributeTraitBuilder(ResourceLocation traitId, int maxLevel) {
        super(traitId, maxLevel, ApiConst.ATTRIBUTE_TRAIT_ID);
    }

    public AttributeTraitBuilder addModifier(GearType gearType, EquipmentSlot slot, Attribute attribute, AttributeModifier.Operation operation, float ... values) {
        return this.addModifier(gearType, slot.m_20751_(), attribute, operation, values);
    }

    public AttributeTraitBuilder addModifier(GearType gearType, String slot, Attribute attribute, AttributeModifier.Operation operation, float ... values) {
        this.modifiers.computeIfAbsent(AttributeTraitBuilder.makeKey(gearType, slot), str -> new ArrayList()).add(new Modifier(ForgeRegistries.ATTRIBUTES.getKey((Object)attribute), operation, values));
        return this;
    }

    public AttributeTraitBuilder addArmorModifier(Attribute attribute, AttributeModifier.Operation operation, float ... values) {
        this.addModifier(GearType.ARMOR, EquipmentSlot.HEAD, attribute, operation, values);
        this.addModifier(GearType.ARMOR, EquipmentSlot.CHEST, attribute, operation, values);
        this.addModifier(GearType.ARMOR, EquipmentSlot.LEGS, attribute, operation, values);
        this.addModifier(GearType.ARMOR, EquipmentSlot.FEET, attribute, operation, values);
        return this;
    }

    public AttributeTraitBuilder addModifiersEitherHand(GearType gearType, Attribute attribute, AttributeModifier.Operation operation, float ... values) {
        this.addModifier(gearType, EquipmentSlot.MAINHAND, attribute, operation, values);
        this.addModifier(gearType, EquipmentSlot.OFFHAND, attribute, operation, values);
        return this;
    }

    public AttributeTraitBuilder addModifierAnySlot(GearType gearType, Attribute attribute, AttributeModifier.Operation operation, float ... values) {
        return this.addModifier(gearType, "", attribute, operation, values);
    }

    private static String makeKey(GearType gearType, String slot) {
        if (slot.isEmpty()) {
            return gearType.getName();
        }
        return gearType.getName() + "/" + slot;
    }

    @Override
    public JsonObject serialize() {
        if (this.modifiers.isEmpty()) {
            throw new IllegalStateException("Attribute trait '" + this.getTraitId() + "' has no modifiers");
        }
        JsonObject json = super.serialize();
        JsonObject modsJson = new JsonObject();
        this.modifiers.forEach((key, mods) -> {
            JsonArray array = new JsonArray();
            mods.forEach(e -> array.add((JsonElement)e.serialize()));
            modsJson.add(key, (JsonElement)array);
        });
        json.add("attribute_modifiers", (JsonElement)modsJson);
        return json;
    }

    public record Modifier(ResourceLocation name, AttributeModifier.Operation operation, float[] values) {
        public JsonObject serialize() {
            JsonObject json = new JsonObject();
            json.addProperty("attribute", this.name.toString());
            json.addProperty("operation", (Number)this.operation.m_22235_());
            JsonArray array = new JsonArray();
            for (float f : this.values) {
                array.add((Number)Float.valueOf(f));
            }
            json.add("value", (JsonElement)array);
            return json;
        }
    }
}

