/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe;

import com.google.gson.JsonObject;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.init.SgRecipes;
import net.silentchaos512.gear.item.FragmentItem;
import net.silentchaos512.gear.item.RepairKitItem;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.lib.collection.StackList;

public class FillRepairKitRecipe
extends CustomRecipe {
    public FillRepairKitRecipe(ResourceLocation idIn, CraftingBookCategory bookCategory) {
        super(idIn, bookCategory);
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        boolean kitFound = false;
        int matsFound = 0;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof RepairKitItem) {
                if (kitFound) {
                    return false;
                }
                kitFound = true;
                continue;
            }
            if (FillRepairKitRecipe.isRepairMaterial(stack)) {
                ++matsFound;
                continue;
            }
            return false;
        }
        return kitFound && matsFound > 0;
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        StackList list = StackList.from((Container)inv);
        ItemStack repairKit = list.uniqueOfType(RepairKitItem.class).m_41777_();
        repairKit.m_41764_(1);
        RepairKitItem repairKitItem = (RepairKitItem)repairKit.m_41720_();
        for (ItemStack mat : list.allMatches(FillRepairKitRecipe::isRepairMaterial)) {
            if (repairKitItem.addMaterial(repairKit, mat)) continue;
            return ItemStack.f_41583_;
        }
        return repairKit;
    }

    private static boolean isRepairMaterial(ItemStack stack) {
        if (stack.m_41720_() instanceof FragmentItem) {
            IMaterialInstance material = FragmentItem.getMaterial(stack);
            return material != null && FillRepairKitRecipe.isRepairMaterial(material);
        }
        MaterialInstance material = MaterialInstance.from(stack);
        return material != null && FillRepairKitRecipe.isRepairMaterial(material);
    }

    private static boolean isRepairMaterial(IMaterialInstance material) {
        float durability = material.getStat(PartType.MAIN, ItemStats.DURABILITY);
        float armorDurability = material.getStat(PartType.MAIN, ItemStats.ARMOR_DURABILITY);
        IMaterial mat = (IMaterial)material.get();
        return mat != null && mat.allowedInPart(material, PartType.MAIN) && (durability > 0.0f || armorDurability > 0.0f);
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public ResourceLocation m_6423_() {
        return Const.FILL_REPAIR_KIT;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)SgRecipes.FILL_REPAIR_KIT.get();
    }

    public static final class Serializer
    implements RecipeSerializer<FillRepairKitRecipe> {
        public FillRepairKitRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            return new FillRepairKitRecipe(recipeId, CraftingBookCategory.MISC);
        }

        public FillRepairKitRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            return new FillRepairKitRecipe(recipeId, CraftingBookCategory.MISC);
        }

        public void toNetwork(FriendlyByteBuf buffer, FillRepairKitRecipe recipe) {
        }
    }
}

