/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe;

import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.init.SgRecipes;
import net.silentchaos512.gear.item.ModKitItem;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.lib.collection.StackList;

public class ModKitRemovePartRecipe
extends CustomRecipe {
    public ModKitRemovePartRecipe(ResourceLocation idIn, CraftingBookCategory bookCategory) {
        super(idIn, bookCategory);
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        ItemStack gear = ItemStack.f_41583_;
        boolean foundModKit = false;
        PartType type = PartType.NONE;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (gear.m_41619_() && stack.m_41720_() instanceof ICoreItem) {
                gear = stack;
                continue;
            }
            if (!foundModKit && stack.m_41720_() instanceof ModKitItem) {
                type = ModKitItem.getSelectedType(stack);
                if (type == PartType.NONE) {
                    return false;
                }
                foundModKit = true;
                continue;
            }
            return false;
        }
        return !gear.m_41619_() && foundModKit && GearData.hasPartOfType(gear, type);
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        PartType type;
        StackList list = StackList.from((Container)inv);
        ItemStack gear = list.uniqueOfType(ICoreItem.class);
        ItemStack modKit = list.uniqueOfType(ModKitItem.class);
        if (gear.m_41619_() || modKit.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack result = gear.m_41777_();
        if (GearData.removeFirstPartOfType(result, type = ModKitItem.getSelectedType(modKit))) {
            GearData.recalculateStats(result, ForgeHooks.getCraftingPlayer());
        }
        return result;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList list = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        ItemStack gear = StackList.from((Container)inv).uniqueOfType(ICoreItem.class);
        ItemStack modKit = StackList.from((Container)inv).uniqueOfType(ModKitItem.class);
        PartType type = ModKitItem.getSelectedType(modKit);
        PartData part = GearData.getPartOfType(gear, type);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41720_() instanceof ICoreItem) {
                list.set(i, (Object)(part != null ? part.getItem() : ItemStack.f_41583_));
                continue;
            }
            if (!stack.hasCraftingRemainingItem()) continue;
            list.set(i, (Object)stack.getCraftingRemainingItem());
        }
        return list;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)SgRecipes.MOD_KIT_REMOVE_PART.get();
    }
}

