/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data.recipes;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.crafting.ingredient.GearPartIngredient;
import net.silentchaos512.gear.crafting.ingredient.PartMaterialIngredient;
import net.silentchaos512.gear.init.SgRecipes;
import net.silentchaos512.lib.util.NameUtils;

public class GearSmithingRecipeBuilder {
    private final RecipeSerializer<?> serializer;
    private final Item gearItem;
    private final Ingredient addition;

    public GearSmithingRecipeBuilder(RecipeSerializer<?> serializer, Item gearItem, Ingredient addition) {
        this.serializer = serializer;
        this.gearItem = gearItem;
        this.addition = addition;
    }

    public static GearSmithingRecipeBuilder coating(ItemLike gearItem) {
        return new GearSmithingRecipeBuilder((RecipeSerializer)SgRecipes.SMITHING_COATING.get(), gearItem.m_5456_(), PartMaterialIngredient.of(PartType.COATING));
    }

    public static GearSmithingRecipeBuilder upgrade(ItemLike gearItem, PartType partType) {
        return new GearSmithingRecipeBuilder((RecipeSerializer)SgRecipes.SMITHING_UPGRADE.get(), gearItem.m_5456_(), GearPartIngredient.of(partType));
    }

    public void build(Consumer<FinishedRecipe> consumer) {
        this.build(consumer, new ResourceLocation(NameUtils.fromRecipeSerializer(this.serializer) + "/" + NameUtils.fromItem((ItemLike)this.gearItem).m_135815_()));
    }

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation recipeId) {
        consumer.accept(new Result(recipeId, this));
    }

    public class Result
    implements FinishedRecipe {
        private final ResourceLocation recipeId;
        private final GearSmithingRecipeBuilder builder;

        public Result(ResourceLocation recipeId, GearSmithingRecipeBuilder builder) {
            this.recipeId = recipeId;
            this.builder = builder;
        }

        public void m_7917_(JsonObject json) {
            json.add("gear", Ingredient.m_43929_((ItemLike[])new ItemLike[]{this.builder.gearItem}).m_43942_());
            json.add("addition", this.builder.addition.m_43942_());
        }

        public ResourceLocation m_6445_() {
            return this.recipeId;
        }

        public RecipeSerializer<?> m_6637_() {
            return this.builder.serializer;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

