/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.init;

import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.silentchaos512.gear.block.charger.ChargerContainer;
import net.silentchaos512.gear.block.charger.ChargerScreen;
import net.silentchaos512.gear.block.compounder.CompounderBlock;
import net.silentchaos512.gear.block.compounder.CompounderContainer;
import net.silentchaos512.gear.block.compounder.MetalAlloyerScreen;
import net.silentchaos512.gear.block.compounder.RecrystallizerScreen;
import net.silentchaos512.gear.block.compounder.RefabricatorScreen;
import net.silentchaos512.gear.block.grader.GraderContainer;
import net.silentchaos512.gear.block.grader.GraderScreen;
import net.silentchaos512.gear.block.press.MetalPressContainer;
import net.silentchaos512.gear.block.press.MetalPressScreen;
import net.silentchaos512.gear.block.salvager.SalvagerContainer;
import net.silentchaos512.gear.block.salvager.SalvagerScreen;
import net.silentchaos512.gear.init.SgBlocks;
import net.silentchaos512.gear.item.blueprint.book.BlueprintBookContainer;
import net.silentchaos512.gear.item.blueprint.book.BlueprintBookContainerScreen;

public final class SgMenuTypes {
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"silentgear");
    public static final RegistryObject<MenuType<GraderContainer>> MATERIAL_GRADER = SgMenuTypes.register("material_grader", GraderContainer::new);
    public static final RegistryObject<MenuType<MetalPressContainer>> METAL_PRESS = SgMenuTypes.register("metal_press", MetalPressContainer::new);
    public static final RegistryObject<MenuType<CompounderContainer>> METAL_ALLOYER = SgMenuTypes.register("metal_alloyer", (id, playerInventory, buffer) -> new CompounderContainer(SgMenuTypes.getMetalAlloyer(), id, playerInventory, buffer, ((CompounderBlock)((Object)((Object)SgBlocks.METAL_ALLOYER.get()))).getCategories()));
    public static final RegistryObject<MenuType<CompounderContainer>> RECRYSTALLIZER = SgMenuTypes.register("recrystallizer", (id, playerInventory, buffer) -> new CompounderContainer(SgMenuTypes.getRecrystallizer(), id, playerInventory, buffer, ((CompounderBlock)((Object)((Object)SgBlocks.RECRYSTALLIZER.get()))).getCategories()));
    public static final RegistryObject<MenuType<CompounderContainer>> REFABRICATOR = SgMenuTypes.register("refabricator", (id, playerInventory, buffer) -> new CompounderContainer(SgMenuTypes.getRefabricator(), id, playerInventory, buffer, ((CompounderBlock)((Object)((Object)SgBlocks.REFABRICATOR.get()))).getCategories()));
    public static final RegistryObject<MenuType<SalvagerContainer>> SALVAGER = SgMenuTypes.register("salvager", SalvagerContainer::new);
    public static final RegistryObject<MenuType<ChargerContainer>> STARLIGHT_CHARGER = SgMenuTypes.register("starlight_charger", ChargerContainer::createStarlightCharger);
    public static final RegistryObject<MenuType<BlueprintBookContainer>> BLUEPRINT_BOOK = SgMenuTypes.register("blueprint_book", BlueprintBookContainer::new);

    private SgMenuTypes() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerScreens(FMLClientSetupEvent event) {
        MenuScreens.m_96206_((MenuType)((MenuType)MATERIAL_GRADER.get()), GraderScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)METAL_ALLOYER.get()), MetalAlloyerScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)METAL_PRESS.get()), MetalPressScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)RECRYSTALLIZER.get()), RecrystallizerScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)REFABRICATOR.get()), RefabricatorScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)SALVAGER.get()), SalvagerScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)STARLIGHT_CHARGER.get()), ChargerScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)BLUEPRINT_BOOK.get()), BlueprintBookContainerScreen::new);
    }

    private static <T extends AbstractContainerMenu> RegistryObject<MenuType<T>> register(String name, IContainerFactory<T> factory) {
        return MENU_TYPES.register(name, () -> IForgeMenuType.create((IContainerFactory)factory));
    }

    private static MenuType<?> getMetalAlloyer() {
        return (MenuType)METAL_ALLOYER.get();
    }

    private static MenuType<?> getRecrystallizer() {
        return (MenuType)RECRYSTALLIZER.get();
    }

    private static MenuType<?> getRefabricator() {
        return (MenuType)REFABRICATOR.get();
    }
}

