/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.network;

import java.util.Objects;
import java.util.regex.Pattern;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.HandshakeHandler;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.network.simple.SimpleChannel;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.gear.part.PartManager;
import net.silentchaos512.gear.gear.trait.TraitManager;
import net.silentchaos512.gear.network.ClientOutputCommandPacket;
import net.silentchaos512.gear.network.CompounderUpdatePacket;
import net.silentchaos512.gear.network.GearLeftClickPacket;
import net.silentchaos512.gear.network.KeyPressOnItemPacket;
import net.silentchaos512.gear.network.LoginPacket;
import net.silentchaos512.gear.network.OpenGuideBookPacket;
import net.silentchaos512.gear.network.ProspectingResultPacket;
import net.silentchaos512.gear.network.RecalculateStatsPacket;
import net.silentchaos512.gear.network.SelectBlueprintFromBookPacket;
import net.silentchaos512.gear.network.SyncGearCraftingItemsPacket;
import net.silentchaos512.gear.network.SyncGearPartsPacket;
import net.silentchaos512.gear.network.SyncMaterialCraftingItemsPacket;
import net.silentchaos512.gear.network.SyncMaterialsPacket;
import net.silentchaos512.gear.network.SyncTraitsPacket;
import net.silentchaos512.gear.util.MismatchedVersionsException;

public final class Network {
    public static final String VERSION = "sgear-net-14";
    private static final Pattern NET_VERSION_PATTERN = Pattern.compile("sgear-net-\\d+$");
    private static final Pattern MOD_VERSION_PATTERN = Pattern.compile("^\\d+\\.\\d+\\.\\d+$");
    public static SimpleChannel channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)SilentGear.getId("network")).clientAcceptedVersions(s -> Objects.equals(s, VERSION)).serverAcceptedVersions(s -> Objects.equals(s, VERSION)).networkProtocolVersion(() -> "sgear-net-14").simpleChannel();

    private Network() {
    }

    public static void init() {
    }

    static void writeModVersionInfoToNetwork(FriendlyByteBuf buffer) {
        buffer.m_130070_(VERSION);
        buffer.m_130070_(SilentGear.getVersion());
    }

    static void verifyNetworkVersion(FriendlyByteBuf buffer) {
        String serverNetVersion = Network.readNetworkVersion(buffer);
        String serverModVersion = Network.readModVersion(buffer);
        SilentGear.LOGGER.debug("Read Silent Gear server version as {} ({})", (Object)serverModVersion, (Object)serverNetVersion);
        if (!VERSION.equals(serverNetVersion)) {
            String msg = String.format("This server is running a different version of Silent Gear. Try updating Silent Gear on the client and/or server. Client version is %s (%s) and server version is %s (%s).", SilentGear.getVersion(), VERSION, serverModVersion, serverNetVersion);
            throw new MismatchedVersionsException(msg);
        }
    }

    private static String readNetworkVersion(FriendlyByteBuf buffer) {
        String str = buffer.m_130136_(16);
        if (!NET_VERSION_PATTERN.matcher(str).matches()) {
            return "UNKNOWN (received: " + str + ")";
        }
        return str;
    }

    private static String readModVersion(FriendlyByteBuf buffer) {
        String str = buffer.m_130136_(16);
        if (!"NONE".equals(str) && !MOD_VERSION_PATTERN.matcher(str).matches()) {
            return "UNKNOWN (received: " + str + ")";
        }
        return str;
    }

    static {
        channel.messageBuilder(SyncTraitsPacket.class, 1).loginIndex(LoginPacket::getLoginIndex, LoginPacket::setLoginIndex).decoder(SyncTraitsPacket::fromBytes).encoder(SyncTraitsPacket::toBytes).markAsLoginPacket().consumer(HandshakeHandler.biConsumerFor((hh, msg, ctx) -> {
            TraitManager.handleTraitSyncPacket(msg, ctx);
            channel.reply((Object)new LoginPacket.Reply(), (NetworkEvent.Context)ctx.get());
        })).add();
        channel.messageBuilder(SyncGearPartsPacket.class, 2).loginIndex(LoginPacket::getLoginIndex, LoginPacket::setLoginIndex).decoder(SyncGearPartsPacket::fromBytes).encoder(SyncGearPartsPacket::toBytes).markAsLoginPacket().consumer(HandshakeHandler.biConsumerFor((hh, msg, ctx) -> {
            PartManager.handlePartSyncPacket(msg, ctx);
            channel.reply((Object)new LoginPacket.Reply(), (NetworkEvent.Context)ctx.get());
        })).add();
        channel.messageBuilder(LoginPacket.Reply.class, 3).loginIndex(LoginPacket::getLoginIndex, LoginPacket::setLoginIndex).decoder(buffer -> new LoginPacket.Reply()).encoder((msg, buffer) -> {}).consumer(HandshakeHandler.indexFirst((hh, msg, ctx) -> msg.handle(ctx))).add();
        channel.messageBuilder(SyncGearCraftingItemsPacket.class, 4).encoder(SyncGearCraftingItemsPacket::toBytes).decoder(SyncGearCraftingItemsPacket::fromBytes).consumer(SyncGearCraftingItemsPacket::handle).add();
        channel.messageBuilder(SyncMaterialsPacket.class, 6).loginIndex(LoginPacket::getLoginIndex, LoginPacket::setLoginIndex).decoder(SyncMaterialsPacket::fromBytes).encoder(SyncMaterialsPacket::toBytes).markAsLoginPacket().consumer(HandshakeHandler.biConsumerFor((hh, msg, ctx) -> {
            MaterialManager.handleSyncPacket(msg, ctx);
            channel.reply((Object)new LoginPacket.Reply(), (NetworkEvent.Context)ctx.get());
        })).add();
        channel.messageBuilder(PlayMessages.SpawnEntity.class, 7).encoder(PlayMessages.SpawnEntity::encode).decoder(PlayMessages.SpawnEntity::decode).consumer(PlayMessages.SpawnEntity::handle).add();
        channel.messageBuilder(SyncMaterialCraftingItemsPacket.class, 8).decoder(SyncMaterialCraftingItemsPacket::decode).encoder(SyncMaterialCraftingItemsPacket::encode).consumer(SyncMaterialCraftingItemsPacket::handle).add();
        channel.messageBuilder(KeyPressOnItemPacket.class, 9, NetworkDirection.PLAY_TO_SERVER).decoder(KeyPressOnItemPacket::decode).encoder(KeyPressOnItemPacket::encode).consumer(KeyPressOnItemPacket::handle).add();
        channel.messageBuilder(SelectBlueprintFromBookPacket.class, 10, NetworkDirection.PLAY_TO_SERVER).decoder(SelectBlueprintFromBookPacket::decode).encoder(SelectBlueprintFromBookPacket::encode).consumer(SelectBlueprintFromBookPacket::handle).add();
        channel.messageBuilder(ProspectingResultPacket.class, 11, NetworkDirection.PLAY_TO_CLIENT).decoder(ProspectingResultPacket::decode).encoder(ProspectingResultPacket::encode).consumer(ProspectingResultPacket::handle).add();
        channel.messageBuilder(GearLeftClickPacket.class, 12, NetworkDirection.PLAY_TO_SERVER).decoder(GearLeftClickPacket::decode).encoder(GearLeftClickPacket::encode).consumer(GearLeftClickPacket::handle).add();
        channel.messageBuilder(ClientOutputCommandPacket.class, 13).encoder(ClientOutputCommandPacket::encode).decoder(ClientOutputCommandPacket::decode).consumer(ClientOutputCommandPacket::handle).add();
        channel.messageBuilder(CompounderUpdatePacket.class, 14, NetworkDirection.PLAY_TO_SERVER).encoder(CompounderUpdatePacket::encode).decoder(CompounderUpdatePacket::decode).consumer(CompounderUpdatePacket::handle).add();
        channel.messageBuilder(OpenGuideBookPacket.class, 15, NetworkDirection.PLAY_TO_CLIENT).encoder((pkt, buf) -> {}).decoder(buf -> new OpenGuideBookPacket()).consumer(OpenGuideBookPacket::handle).add();
        channel.messageBuilder(RecalculateStatsPacket.class, 16, NetworkDirection.PLAY_TO_SERVER).decoder(RecalculateStatsPacket::decode).encoder(RecalculateStatsPacket::encode).consumer(RecalculateStatsPacket::handle).add();
    }
}

