/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.network;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.stats.IItemStat;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;

public class RecalculateStatsPacket {
    private final int slot;
    private final IItemStat triggerStat;

    private RecalculateStatsPacket(int slot, IItemStat triggerStat) {
        this.slot = slot;
        this.triggerStat = triggerStat;
    }

    public RecalculateStatsPacket(Level level, ItemStack stack, IItemStat triggerStat) {
        this.slot = RecalculateStatsPacket.findSlotOnClientPlayer(level, stack);
        this.triggerStat = triggerStat;
    }

    private static int findSlotOnClientPlayer(Level level, ItemStack stack) {
        Player player;
        if (level instanceof ClientLevel && (player = SilentGear.PROXY.getClientPlayer()) != null) {
            return player.m_150109_().m_36030_(stack);
        }
        return -1;
    }

    public ItemStack getItem(Supplier<NetworkEvent.Context> context) {
        ServerPlayer player = context.get().getSender();
        if (player != null && this.slot >= 0 && this.slot < player.m_150109_().m_6643_()) {
            return player.m_150109_().m_8020_(this.slot);
        }
        return ItemStack.f_41583_;
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        ItemStack stack = this.getItem(context);
        if (GearHelper.isGear(stack)) {
            GearData.recalculateStats(stack, (Player)context.get().getSender());
            GearData.putStatInNbtIfMissing(stack, this.triggerStat);
        }
    }

    public static RecalculateStatsPacket decode(FriendlyByteBuf buffer) {
        int slot = buffer.m_130242_();
        ItemStat stat = ItemStats.byName(buffer.m_130281_());
        return new RecalculateStatsPacket(slot, Objects.requireNonNull(stat));
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.slot);
        buffer.m_130085_(this.triggerStat.getStatId());
    }
}

