/*
 * Decompiled with CFR 0.152.
 */
package jeresources.util;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class Font {
    public static final Font small = new Font(true);
    public static final Font normal = new Font(false);
    private boolean isSmall;
    private static final float SCALING = 0.75f;

    private Font(boolean small) {
        this.isSmall = small;
    }

    public void print(PoseStack poseStack, String line, int x, int y) {
        this.doTransform(poseStack, x, y);
        Minecraft.m_91087_().f_91062_.m_92883_(poseStack, line, 0.0f, 0.0f, 8);
        poseStack.m_85849_();
    }

    public void print(PoseStack poseStack, FormattedCharSequence line, int x, int y) {
        this.doTransform(poseStack, x, y);
        Minecraft.m_91087_().f_91062_.m_92877_(poseStack, line, 0.0f, 0.0f, 8);
        poseStack.m_85849_();
    }

    public void print(PoseStack poseStack, int number, int x, int y) {
        this.print(poseStack, String.valueOf(number), x, y);
    }

    public void splitPrint(PoseStack poseStack, String line, int x, int y, int maxWidth) {
        this.doTransform(poseStack, x, y);
        int scaledWidth = (int)((float)maxWidth * (this.isSmall ? 0.75f : 1.0f));
        List lines = Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)Component.m_237113_((String)line), scaledWidth);
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        int scaledLineHeight = (int)(9.0f * (this.isSmall ? 0.75f : 1.0f));
        for (int i = 0; i < lines.size(); ++i) {
            Minecraft.m_91087_().f_91062_.m_92877_(poseStack, (FormattedCharSequence)lines.get(i), 0.0f, (float)(i * scaledLineHeight), 8);
        }
        poseStack.m_85849_();
    }

    public void splitPrint(PoseStack poseStack, FormattedCharSequence line, int x, int y, int maxWidth) {
        this.splitPrint(poseStack, line.toString(), x, y, maxWidth);
    }

    public void print(PoseStack poseStack, FormattedCharSequence line, int x, int y, int color) {
        this.doTransform(poseStack, x, y);
        Minecraft.m_91087_().f_91062_.m_92877_(poseStack, line, 0.0f, 0.0f, color);
        poseStack.m_85849_();
    }

    public void print(PoseStack poseStack, FormattedCharSequence line, int x, int y, int color, boolean shadow) {
        this.doTransform(poseStack, x, y);
        if (shadow) {
            Minecraft.m_91087_().f_91062_.m_92744_(poseStack, line, 0.0f, 0.0f, color);
        } else {
            Minecraft.m_91087_().f_91062_.m_92877_(poseStack, line, 0.0f, 0.0f, color);
        }
        poseStack.m_85849_();
    }

    public int getStringWidth(FormattedCharSequence line) {
        int width = Minecraft.m_91087_().f_91062_.m_92724_(line);
        return (int)(this.isSmall ? (float)width * 0.75f : (float)width);
    }

    public int getStringWidth(String line) {
        int width = Minecraft.m_91087_().f_91062_.m_92895_(line);
        return (int)(this.isSmall ? (float)width * 0.75f : (float)width);
    }

    private void doTransform(PoseStack poseStack, int x, int y) {
        poseStack.m_85836_();
        poseStack.m_252880_((float)x, (float)y, 0.0f);
        if (this.isSmall) {
            poseStack.m_85841_(0.75f, 0.75f, 1.0f);
        }
    }
}

