/*
 * Decompiled with CFR 0.152.
 */
package jeresources.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Predicate;
import jeresources.entry.VillagerEntry;
import jeresources.entry.WanderingTraderEntry;
import jeresources.registry.VillagerRegistry;
import jeresources.util.LogHelper;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.level.block.state.BlockState;

public class VillagersHelper {
    public static void initRegistry(VillagerRegistry reg) {
        for (VillagerProfession profession : BuiltInRegistries.f_256735_) {
            try {
                reg.addVillagerEntry(new VillagerEntry(profession, VillagersHelper.getTrades(profession)));
            }
            catch (Exception e) {
                LogHelper.warn("Failed loading villager {} registered at {}", profession.toString(), profession.f_35600_());
                LogHelper.warn("Exception caught when registering villager", e);
            }
        }
        try {
            reg.addVillagerEntry(new WanderingTraderEntry(VillagersHelper.getWanderingTrades()));
        }
        catch (Exception e) {
            LogHelper.warn("Failed loading wandering trader", new Object[0]);
            LogHelper.warn("Exception caught when registering wandering traderr", e);
        }
    }

    private static Int2ObjectMap<VillagerTrades.ItemListing[]> getTrades(VillagerProfession profession) {
        return VillagerTrades.f_35627_.getOrDefault(profession, Int2ObjectMaps.emptyMap());
    }

    private static Int2ObjectMap<VillagerTrades.ItemListing[]> getWanderingTrades() {
        VillagerTrades.ItemListing[] allWanderingTrades = (VillagerTrades.ItemListing[])VillagerTrades.f_35628_.values().stream().flatMap(x -> Arrays.stream(x)).toArray(VillagerTrades.ItemListing[]::new);
        return new Int2ObjectOpenHashMap(new int[]{1}, (Object[])new VillagerTrades.ItemListing[][]{allWanderingTrades});
    }

    public static Set<BlockState> getPoiBlocks(PoiType poiType) {
        return poiType.f_27325_();
    }

    public static Set<BlockState> getPoiBlocks(Predicate<Holder<PoiType>> heldJobSite) {
        return VillagersHelper.getPoiBlocks((PoiType)((Holder.Reference)BuiltInRegistries.f_256941_.m_203611_().filter(heldJobSite).findFirst().get()).m_203334_());
    }
}

