/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.core.context;

import com.google.common.base.Preconditions;
import fuzs.puzzleslib.api.core.v1.context.CreativeModeTabContext;
import fuzs.puzzleslib.api.item.v2.CreativeModeTabConfigurator;
import fuzs.puzzleslib.impl.item.CreativeModeTabConfiguratorImpl;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public record CreativeModeTabContextForgeImpl(BiConsumer<ResourceLocation, Consumer<CreativeModeTab.Builder>> consumer) implements CreativeModeTabContext
{
    @Override
    public void registerCreativeModeTab(CreativeModeTabConfigurator configurator) {
        CreativeModeTabConfiguratorImpl configuratorImpl = (CreativeModeTabConfiguratorImpl)configurator;
        this.consumer.accept(configuratorImpl.getIdentifier(), builder -> this.finalizeCreativeModeTabBuilder((CreativeModeTab.Builder)builder, configuratorImpl));
    }

    private void finalizeCreativeModeTabBuilder(CreativeModeTab.Builder builder, final CreativeModeTabConfiguratorImpl configuratorImpl) {
        configuratorImpl.configure(builder);
        String translationKey = "itemGroup.%s.%s".formatted(configuratorImpl.getIdentifier().m_135827_(), configuratorImpl.getIdentifier().m_135815_());
        builder.m_257941_((Component)Component.m_237115_((String)translationKey));
        if (configuratorImpl.isHasSearchBar()) {
            builder.withSearchBar();
        }
        if (configuratorImpl.getIcons() != null) {
            builder.withTabFactory(other -> new CreativeModeTab((CreativeModeTab.Builder)other){
                @Nullable
                private ItemStack[] icons;

                public ItemStack m_40787_() {
                    if (this.icons == null) {
                        this.icons = configuratorImpl.getIcons().get();
                        Preconditions.checkPositionIndex((int)1, (int)this.icons.length, (String)"icons is empty");
                    }
                    int index = (int)(System.currentTimeMillis() / 2000L) % this.icons.length;
                    return this.icons[index];
                }
            });
        }
    }
}

