/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.item;

import com.google.common.base.Preconditions;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.item.v2.CreativeModeTabConfigurator;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public final class CreativeModeTabConfiguratorImpl
implements CreativeModeTabConfigurator {
    private static final Item[] POTION_ITEMS = new Item[]{Items.f_42589_, Items.f_42736_, Items.f_42739_, Items.f_42738_};
    private final ResourceLocation identifier;
    @Nullable
    private Supplier<ItemStack> icon;
    @Nullable
    private Supplier<ItemStack[]> icons;
    private CreativeModeTab.DisplayItemsGenerator displayItemsGenerator = (itemDisplayParameters, output) -> {};
    private boolean hasSearchBar;
    private boolean appendEnchantmentsAndPotions;

    public CreativeModeTabConfiguratorImpl(ResourceLocation identifier) {
        this.identifier = identifier;
    }

    public ResourceLocation getIdentifier() {
        return this.identifier;
    }

    public Supplier<ItemStack[]> getIcons() {
        return this.icons;
    }

    public boolean isHasSearchBar() {
        return this.hasSearchBar;
    }

    @Override
    public CreativeModeTabConfigurator icon(Supplier<ItemStack> icon) {
        this.icon = icon;
        return this;
    }

    @Override
    public CreativeModeTabConfigurator icons(Supplier<ItemStack[]> icons) {
        this.icons = icons;
        return this;
    }

    @Override
    public CreativeModeTabConfigurator displayItems(CreativeModeTab.DisplayItemsGenerator displayItemsGenerator) {
        this.displayItemsGenerator = displayItemsGenerator;
        return this;
    }

    @Override
    public CreativeModeTabConfigurator withSearchBar() {
        this.hasSearchBar = true;
        return this;
    }

    @Override
    public CreativeModeTabConfigurator appendEnchantmentsAndPotions() {
        this.appendEnchantmentsAndPotions = true;
        return this;
    }

    public void configure(CreativeModeTab.Builder builder) {
        if (this.icon != null) {
            builder.m_257737_(this.icon);
        } else {
            Objects.requireNonNull(this.icons, "both icon suppliers are null");
            if (!ModLoaderEnvironment.INSTANCE.isForge()) {
                builder.m_257737_(() -> {
                    ItemStack[] icons = this.icons.get();
                    Preconditions.checkPositionIndex((int)1, (int)icons.length, (String)"icons is empty");
                    return icons[0];
                });
            }
        }
        if (this.appendEnchantmentsAndPotions) {
            builder.m_257501_((itemDisplayParameters, output) -> {
                this.displayItemsGenerator.m_257865_(itemDisplayParameters, output);
                CreativeModeTabConfiguratorImpl.appendAllEnchantments(this.identifier.m_135827_(), itemDisplayParameters.f_268485_(), arg_0 -> ((CreativeModeTab.Output)output).m_246342_(arg_0));
                CreativeModeTabConfiguratorImpl.appendAllPotions(this.identifier.m_135827_(), itemDisplayParameters.f_268485_(), arg_0 -> ((CreativeModeTab.Output)output).m_246342_(arg_0));
            });
        } else {
            builder.m_257501_(this.displayItemsGenerator);
        }
    }

    private static void appendAllEnchantments(String namespace, HolderLookup.Provider holders, Consumer<ItemStack> itemStacks) {
        Comparator<Holder.Reference> comparator = Comparator.comparing(entry -> entry.m_205785_().m_135782_().m_135815_());
        holders.m_254861_(Registries.f_256762_).stream().flatMap(HolderLookup::m_214062_).filter(entry -> entry.m_205785_().m_135782_().m_135827_().equals(namespace)).sorted(comparator).map(Holder.Reference::m_203334_).forEach(enchantment -> itemStacks.accept(EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(enchantment, enchantment.m_6586_()))));
    }

    private static void appendAllPotions(String namespace, HolderLookup.Provider holders, Consumer<ItemStack> itemStacks) {
        Comparator<Potion> comparator = Comparator.comparing(potion -> {
            if (potion.m_43488_().isEmpty()) {
                throw new IllegalArgumentException("Cannot compare potions with empty effects!");
            }
            MobEffect effect = ((MobEffectInstance)potion.m_43488_().get(0)).m_19544_();
            ResourceLocation key = BuiltInRegistries.f_256974_.m_7981_((Object)effect);
            Objects.requireNonNull(key, "Mob effect key for class %s is null".formatted(effect.getClass()));
            return key.m_135815_();
        }).thenComparingInt(potion -> ((MobEffectInstance)potion.m_43488_().get(0)).m_19564_()).thenComparingInt(potion -> ((MobEffectInstance)potion.m_43488_().get(0)).m_19557_());
        Potion[] potions = (Potion[])holders.m_254861_(Registries.f_256973_).stream().flatMap(HolderLookup::m_214062_).filter(entry -> entry.m_205785_().m_135782_().m_135827_().equals(namespace)).map(Holder.Reference::m_203334_).filter(potion -> !potion.m_43488_().isEmpty()).sorted(comparator).toArray(Potion[]::new);
        for (Item item : POTION_ITEMS) {
            for (Potion potion2 : potions) {
                itemStacks.accept(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)item), (Potion)potion2));
            }
        }
    }
}

