/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky77.util.button;

import mod.lucky77.util.Vector2;
import mod.lucky77.util.button.FunctionActivator;
import mod.lucky77.util.button.FunctionCommand;

public class Button {
    public boolean isActive;
    public boolean isSwitched;
    public boolean isHighlighted;
    public Vector2 position;
    private final int ID;
    private final Vector2 size;
    private final Vector2 mapOFF;
    private final Vector2 mapON;
    private final Vector2 mapLIGHT;
    private final FunctionCommand command;
    private final FunctionActivator activator;
    private final int switchID;
    private int timer;

    public Button(int id, Vector2 position, Vector2 mapOFF, Vector2 mapON, Vector2 mapLIGHT, Vector2 size, int timerLength, FunctionActivator activator, FunctionCommand command) {
        this.ID = id;
        this.position = position;
        this.mapOFF = mapOFF;
        this.mapON = mapON;
        this.mapLIGHT = mapLIGHT;
        this.size = size;
        this.switchID = timerLength;
        this.activator = activator;
        this.command = command;
        this.isActive = true;
        this.isSwitched = false;
        this.timer = 0;
    }

    public void collideWithMouse(int left, int top, double mouseX, double mouseY) {
        if (this.isActive && (double)(left + this.position.X) < mouseX && mouseX < (double)(left + this.position.X + this.width()) && (double)(top + this.position.Y) < mouseY && mouseY < (double)(top + this.position.Y + this.height())) {
            this.command.run();
            if (this.switchID == 0) {
                boolean bl = this.isSwitched = !this.isSwitched;
            }
            if (this.switchID > 0) {
                this.isSwitched = true;
                this.timer = this.switchID;
            }
        }
    }

    public void update(int left, int top, double mouseX, double mouseY) {
        this.isActive = this.activator.run();
        if (this.isSwitched && this.switchID > 0) {
            --this.timer;
            if (this.timer == 0) {
                this.isSwitched = false;
            }
        }
        if (this.isActive) {
            this.isHighlighted = false;
            if ((double)(left + this.position.X) < mouseX && mouseX < (double)(left + this.position.X + this.width()) && (double)(top + this.position.Y) < mouseY && mouseY < (double)(top + this.position.Y + this.height())) {
                this.isHighlighted = true;
            }
        }
    }

    public void setSwitched(int compare, boolean flag) {
        if (this.ID == compare) {
            this.isSwitched = flag;
        }
    }

    public Vector2 map() {
        if (this.isSwitched) {
            return this.mapON;
        }
        return this.mapOFF;
    }

    public Vector2 highlight() {
        return this.mapLIGHT;
    }

    public int width() {
        return this.size.X;
    }

    public int height() {
        return this.size.Y;
    }
}

