/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky77.util.button;

import java.util.ArrayList;
import java.util.List;
import mod.lucky77.util.Vector2;
import mod.lucky77.util.button.Button;
import mod.lucky77.util.button.FunctionActivator;
import mod.lucky77.util.button.FunctionCommand;

public class ButtonSet {
    private List<Button> buttons = new ArrayList<Button>();
    private int index = -1;

    public void addButton(int id, Vector2 position, Vector2 map, Vector2 mapLIGHT, Vector2 size, FunctionActivator activator, FunctionCommand command) {
        this.buttons.add(new Button(id, position, map, map, mapLIGHT, size, -1, activator, command));
    }

    public void addButton(int id, Vector2 position, Vector2 mapOFF, Vector2 mapON, Vector2 mapLIGHT, Vector2 size, int timerStart, FunctionActivator activator, FunctionCommand command) {
        this.buttons.add(new Button(id, position, mapOFF, mapON, mapLIGHT, size, timerStart, activator, command));
    }

    public void interact(int left, int top, double mouseX, double mouseY) {
        for (Button b : this.buttons) {
            b.collideWithMouse(left, top, mouseX, mouseY);
        }
    }

    public void update(int left, int top, double mouseX, double mouseY) {
        for (Button b : this.buttons) {
            b.update(left, top, mouseX, mouseY);
        }
    }

    public void setToggle(int compare, boolean flag) {
        for (Button b : this.buttons) {
            b.setSwitched(compare, flag);
        }
    }

    public void releaseToggle() {
        for (Button b : this.buttons) {
            b.isSwitched = false;
        }
    }

    public boolean next() {
        ++this.index;
        if (this.index >= this.buttons.size()) {
            this.index = -1;
            return false;
        }
        return true;
    }

    public Vector2 pos() {
        return this.buttons.get((int)this.index).position;
    }

    public Vector2 map() {
        return this.buttons.get(this.index).map();
    }

    public int sizeX() {
        return this.buttons.get(this.index).width();
    }

    public int sizeY() {
        return this.buttons.get(this.index).height();
    }

    public Vector2 highlight() {
        return this.buttons.get(this.index).highlight();
    }

    public boolean isVisible() {
        return this.buttons.get((int)this.index).isActive;
    }

    public boolean isHighlighted() {
        return this.isVisible() && this.buttons.get((int)this.index).isHighlighted;
    }
}

