/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.client.block;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import noobanidus.mods.lootr.block.LootrBarrelBlock;
import noobanidus.mods.lootr.config.ConfigManager;

public class BarrelModel
implements IUnbakedGeometry<BarrelModel> {
    private final UnbakedModel opened;
    private final UnbakedModel unopened;
    private final UnbakedModel vanilla;

    public BarrelModel(UnbakedModel opened, UnbakedModel unopened, UnbakedModel vanilla) {
        this.opened = opened;
        this.unopened = unopened;
        this.vanilla = vanilla;
    }

    private static BakedModel buildModel(UnbakedModel entry, ModelState modelTransform, ModelBaker bakery, Function<Material, TextureAtlasSprite> spriteGetter, ResourceLocation modelLocation) {
        return entry.m_7611_(bakery, spriteGetter, modelTransform, modelLocation);
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        return new BarrelBakedModel(context.useAmbientOcclusion(), context.isGui3d(), context.useBlockLight(), spriteGetter.apply(context.getMaterial("particle")), overrides, BarrelModel.buildModel(this.opened, modelTransform, bakery, spriteGetter, modelLocation), BarrelModel.buildModel(this.unopened, modelTransform, bakery, spriteGetter, modelLocation), BarrelModel.buildModel(this.vanilla, modelTransform, bakery, spriteGetter, modelLocation), context.getTransforms());
    }

    public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
        this.opened.m_5500_(modelGetter);
        this.unopened.m_5500_(modelGetter);
        this.vanilla.m_5500_(modelGetter);
    }

    private static final class BarrelBakedModel
    implements IDynamicBakedModel {
        private final BakedModel opened;
        private final BakedModel unopened;
        private final BakedModel vanilla;
        private final ItemTransforms cameraTransforms;
        protected final boolean ambientOcclusion;
        protected final boolean gui3d;
        protected final boolean isSideLit;
        protected final TextureAtlasSprite particle;
        protected final ItemOverrides overrides;

        public BarrelBakedModel(boolean ambientOcclusion, boolean isGui3d, boolean isSideLit, TextureAtlasSprite particle, ItemOverrides overrides, BakedModel opened, BakedModel unopened, BakedModel vanilla, ItemTransforms cameraTransforms) {
            this.isSideLit = isSideLit;
            this.cameraTransforms = cameraTransforms;
            this.ambientOcclusion = ambientOcclusion;
            this.gui3d = isGui3d;
            this.particle = particle;
            this.overrides = overrides;
            this.opened = opened;
            this.unopened = unopened;
            this.vanilla = vanilla;
        }

        @Nonnull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, @Nonnull RenderType renderType) {
            BakedModel model = ConfigManager.isVanillaTextures() ? this.vanilla : (extraData.has(LootrBarrelBlock.OPENED) ? (extraData.get(LootrBarrelBlock.OPENED) == Boolean.TRUE ? this.opened : this.unopened) : this.unopened);
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll((Iterable)model.getQuads(state, side, rand, extraData, renderType));
            return builder.build();
        }

        public boolean m_7541_() {
            return this.ambientOcclusion;
        }

        public boolean m_7539_() {
            return this.gui3d;
        }

        public boolean m_7547_() {
            return this.isSideLit;
        }

        public boolean m_7521_() {
            return false;
        }

        public TextureAtlasSprite m_6160_() {
            return this.particle;
        }

        public TextureAtlasSprite getParticleIcon(@Nonnull ModelData data) {
            if (ConfigManager.isVanillaTextures()) {
                return this.vanilla.m_6160_();
            }
            if (data.get(LootrBarrelBlock.OPENED) == Boolean.TRUE) {
                return this.opened.m_6160_();
            }
            return this.unopened.m_6160_();
        }

        public ItemTransforms m_7442_() {
            return this.cameraTransforms;
        }

        public ItemOverrides m_7343_() {
            return ItemOverrides.f_111734_;
        }
    }

    public static final class Loader
    implements IGeometryLoader<BarrelModel> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        public BarrelModel read(JsonObject modelContents, JsonDeserializationContext deserializationContext) {
            UnbakedModel unopened = (UnbakedModel)deserializationContext.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)modelContents, (String)"unopened"), BlockModel.class);
            UnbakedModel opened = (UnbakedModel)deserializationContext.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)modelContents, (String)"opened"), BlockModel.class);
            UnbakedModel vanilla = (UnbakedModel)deserializationContext.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)modelContents, (String)"vanilla"), BlockModel.class);
            return new BarrelModel(opened, unopened, vanilla);
        }
    }
}

