/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.corgilib.math.blendingfunction;

import com.mojang.serialization.Codec;
import corgitaco.corgilib.core.CorgiLibRegistry;
import corgitaco.corgilib.math.blendingfunction.BlendingFunctions;
import corgitaco.corgilib.reg.RegistrationProvider;
import java.util.function.Function;
import net.minecraft.util.ExtraCodecs;

public interface BlendingFunction {
    public static final Codec<BlendingFunction> CODEC = ExtraCodecs.m_184415_(() -> CorgiLibRegistry.BLENDING_FUNCTION.get().m_194605_().dispatchStable(BlendingFunction::codec, Function.identity()));
    public static final RegistrationProvider<Codec<? extends BlendingFunction>> PROVIDER = RegistrationProvider.get(CorgiLibRegistry.BLENDING_FUNCTION_RESOURCE_KEY, "corgilib");

    public Codec<? extends BlendingFunction> codec();

    public double apply(double var1);

    default public double apply(double factor, double min, double max) {
        double range = max - min;
        return min + range * this.apply(factor);
    }

    public static void register() {
        BlendingFunction.register("ease_in_out_circ", EaseInOutCirc.CODEC);
        BlendingFunction.register("ease_out_bounce", EaseOutBounce.CODEC);
        BlendingFunction.register("ease_out_cubic", EaseOutCubic.CODEC);
        BlendingFunction.register("ease_out_elastic", EaseOutElastic.CODEC);
        BlendingFunction.register("ease_in_circ", EaseInCirc.CODEC);
        BlendingFunction.register("ease_out_quint", EaseOutQuint.CODEC);
    }

    private static void register(String name, Codec<? extends BlendingFunction> function) {
        PROVIDER.register(name, () -> function);
    }

    public record EaseInOutCirc() implements BlendingFunction
    {
        public static final EaseInOutCirc INSTANCE = new EaseInOutCirc();
        public static final Codec<EaseInOutCirc> CODEC = Codec.unit(() -> INSTANCE);

        @Override
        public double apply(double factor) {
            return BlendingFunctions.easeInOutCirc(factor);
        }

        @Override
        public Codec<? extends BlendingFunction> codec() {
            return CODEC;
        }
    }

    public record EaseOutBounce() implements BlendingFunction
    {
        public static final EaseOutBounce INSTANCE = new EaseOutBounce();
        public static final Codec<EaseOutBounce> CODEC = Codec.unit(() -> INSTANCE);

        @Override
        public double apply(double factor) {
            return BlendingFunctions.easeOutBounce(factor);
        }

        @Override
        public Codec<? extends BlendingFunction> codec() {
            return CODEC;
        }
    }

    public record EaseOutCubic() implements BlendingFunction
    {
        public static final EaseOutCubic INSTANCE = new EaseOutCubic();
        public static final Codec<EaseOutCubic> CODEC = Codec.unit(() -> INSTANCE);

        @Override
        public double apply(double factor) {
            return BlendingFunctions.easeOutCubic(factor);
        }

        @Override
        public Codec<? extends BlendingFunction> codec() {
            return CODEC;
        }
    }

    public record EaseOutElastic() implements BlendingFunction
    {
        public static final EaseOutElastic INSTANCE = new EaseOutElastic();
        public static final Codec<EaseOutElastic> CODEC = Codec.unit(() -> INSTANCE);

        @Override
        public double apply(double factor) {
            return BlendingFunctions.easeOutElastic(factor);
        }

        @Override
        public Codec<? extends BlendingFunction> codec() {
            return CODEC;
        }
    }

    public record EaseInCirc() implements BlendingFunction
    {
        public static final EaseInCirc INSTANCE = new EaseInCirc();
        public static final Codec<EaseInCirc> CODEC = Codec.unit(() -> INSTANCE);

        @Override
        public double apply(double factor) {
            return BlendingFunctions.easeInCirc(factor);
        }

        @Override
        public Codec<? extends BlendingFunction> codec() {
            return CODEC;
        }
    }

    public record EaseOutQuint() implements BlendingFunction
    {
        public static final EaseOutQuint INSTANCE = new EaseOutQuint();
        public static final Codec<EaseOutQuint> CODEC = Codec.unit(() -> INSTANCE);

        @Override
        public double apply(double factor) {
            return BlendingFunctions.easeOutQuint(factor);
        }

        @Override
        public Codec<? extends BlendingFunction> codec() {
            return CODEC;
        }
    }
}

