/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.corgilib.reg.forge;

import com.google.auto.service.AutoService;
import com.mojang.serialization.Codec;
import corgitaco.corgilib.reg.forge.ForgeRegistrationFactory;
import corgitaco.corgilib.reg.registries.DatapackRegistry;
import corgitaco.corgilib.reg.registries.DatapackRegistryBuilder;
import corgitaco.corgilib.reg.registries.DatapackRegistryBuilder$;
import corgitaco.corgilib.reg.util.DatapackRegistryGenerator;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.DataProvider;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraftforge.eventbus.api.IEventBus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.misc.Unsafe;

@ParametersAreNonnullByDefault
public class ForgeDatapackRegistryBuilder<T>
implements DatapackRegistryBuilder<T> {
    private static final Unsafe UNSAFE;
    private static final long offset$VANILLA_REGISTRIES;
    private final ResourceKey<Registry<T>> key;
    private Codec<T> elementCodec;
    @Nullable
    private Codec<T> networkCodec;
    @Nullable
    private RegistrySetBuilder.RegistryBootstrap<T> bootstrap;

    private ForgeDatapackRegistryBuilder(ResourceKey<Registry<T>> key) {
        this.key = Objects.requireNonNull(key, "registry key must not be null");
    }

    @Override
    public DatapackRegistryBuilder<T> withElementCodec(@NotNull Codec<T> codec) {
        this.elementCodec = Objects.requireNonNull(codec, "element codec must not be null");
        return this;
    }

    @Override
    public DatapackRegistryBuilder<T> withNetworkCodec(@Nullable Codec<T> codec) {
        this.networkCodec = codec;
        return this;
    }

    @Override
    public DatapackRegistryBuilder<T> withBootstrap(@Nullable RegistrySetBuilder.RegistryBootstrap<T> bootstrap) {
        this.bootstrap = bootstrap;
        return this;
    }

    @Override
    public DatapackRegistry<T> build() {
        IEventBus bus = ForgeRegistrationFactory.getBus(this.key.m_135782_().m_135827_());
        bus.addListener(event -> event.dataPackRegistry(this.key, Objects.requireNonNull(this.elementCodec, "element codec must not be null"), this.networkCodec));
        return new DatapackRegistry<T>(){

            @Override
            public ResourceKey<Registry<T>> key() {
                return ForgeDatapackRegistryBuilder.this.key;
            }

            @Override
            public DataProvider.Factory<DataProvider> bootstrapDataGenerator(CompletableFuture<HolderLookup.Provider> lookupProvider) {
                return out -> new DatapackRegistryGenerator(out, lookupProvider, registryData -> registryData.f_243794_() == this.key());
            }

            @Override
            public void addToSet(RegistrySetBuilder builder) {
                builder.m_254916_(ForgeDatapackRegistryBuilder.this.key, ForgeDatapackRegistryBuilder.this.bootstrap == null ? ctx -> {} : ForgeDatapackRegistryBuilder.this.bootstrap);
            }

            @Override
            public Registry<T> get(RegistryAccess registryAccess) {
                return registryAccess.m_175515_(ForgeDatapackRegistryBuilder.this.key);
            }
        };
    }

    static {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            UNSAFE = (Unsafe)field.get(null);
            offset$VANILLA_REGISTRIES = UNSAFE.staticFieldOffset(Stream.of(VanillaRegistries.class.getDeclaredFields()).filter(it -> it.getType() == RegistrySetBuilder.class).findFirst().orElseThrow());
        }
        catch (Exception ex) {
            throw new RuntimeException("Barf!", ex);
        }
    }

    @AutoService(value={DatapackRegistryBuilder$.Factory.class})
    public static final class Factory
    implements DatapackRegistryBuilder$.Factory {
        @Override
        public <T> DatapackRegistryBuilder<T> newBuilder(ResourceKey<Registry<T>> key) {
            return new ForgeDatapackRegistryBuilder<T>(key);
        }
    }
}

