/*
 * Decompiled with CFR 0.152.
 */
package com.dplayend.grindenc.handler;

import net.minecraftforge.common.ForgeConfigSpec;

public class HandlerConfigCommon {
    public static final ForgeConfigSpec.Builder CONFIG = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.EnumValue<costType> xpCostType;
    public static final ForgeConfigSpec.IntValue specificCostValue;
    public static final ForgeConfigSpec.IntValue damagePercentValue;
    public static final ForgeConfigSpec.BooleanValue allowCurses;
    public static final ForgeConfigSpec.BooleanValue taxFreeLevelsCompatibility;

    static {
        CONFIG.push("general");
        xpCostType = CONFIG.comment(new String[]{"choose between cost types:", "-NO_COST: there will be no cost to disenchant items", "-SPECIFIC_COST: determine a specific cost to disenchant items", "-VANILLA_COST: the costs of the levels will be similar to the anvil"}).defineEnum("xpCostType", (Enum)costType.VANILLA_COST);
        specificCostValue = CONFIG.comment("specifies the value of the levels the type SPECIFIC_COST must be selected for this value to work").defineInRange("specificCostValue", 3, 1, 1000);
        damagePercentValue = CONFIG.comment("specifies the value of the damage percent of the item when you use the grindstone").defineInRange("damagePercentValue", 10, 0, 100);
        allowCurses = CONFIG.comment("defines whether to allow transferring curses when using the grindstone").define("allowCurses", false);
        taxFreeLevelsCompatibility = CONFIG.comment("defines compatibility with the TaxFreeLevels mod (will work only if installed)").define("taxFreeLevelsCompatibility", true);
        CONFIG.pop();
        SPEC = CONFIG.build();
    }

    public static enum costType {
        NO_COST,
        SPECIFIC_COST,
        VANILLA_COST;

    }
}

