/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IColorHelper;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.subtypes.ISubtypeManager;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.category.extensions.IExtendableRecipeCategory;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.platform.IPlatformFluidHelperInternal;
import mezz.jei.common.platform.IPlatformRecipeHelper;
import mezz.jei.common.platform.IPlatformRegistry;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.StackHelper;
import mezz.jei.library.plugins.vanilla.InventoryEffectRendererGuiHandler;
import mezz.jei.library.plugins.vanilla.RecipeBookGuiHandler;
import mezz.jei.library.plugins.vanilla.anvil.AnvilRecipeCategory;
import mezz.jei.library.plugins.vanilla.anvil.AnvilRecipeMaker;
import mezz.jei.library.plugins.vanilla.anvil.SmithingRecipeCategory;
import mezz.jei.library.plugins.vanilla.brewing.BrewingRecipeCategory;
import mezz.jei.library.plugins.vanilla.brewing.PotionSubtypeInterpreter;
import mezz.jei.library.plugins.vanilla.compostable.CompostableRecipeCategory;
import mezz.jei.library.plugins.vanilla.compostable.CompostingRecipeMaker;
import mezz.jei.library.plugins.vanilla.cooking.BlastingCategory;
import mezz.jei.library.plugins.vanilla.cooking.CampfireCookingCategory;
import mezz.jei.library.plugins.vanilla.cooking.FurnaceSmeltingCategory;
import mezz.jei.library.plugins.vanilla.cooking.SmokingCategory;
import mezz.jei.library.plugins.vanilla.cooking.fuel.FuelRecipeMaker;
import mezz.jei.library.plugins.vanilla.cooking.fuel.FurnaceFuelCategory;
import mezz.jei.library.plugins.vanilla.crafting.CraftingCategoryExtension;
import mezz.jei.library.plugins.vanilla.crafting.CraftingRecipeCategory;
import mezz.jei.library.plugins.vanilla.crafting.VanillaRecipes;
import mezz.jei.library.plugins.vanilla.crafting.replacers.ShieldDecorationRecipeMaker;
import mezz.jei.library.plugins.vanilla.crafting.replacers.ShulkerBoxColoringRecipeMaker;
import mezz.jei.library.plugins.vanilla.crafting.replacers.SuspiciousStewRecipeMaker;
import mezz.jei.library.plugins.vanilla.crafting.replacers.TippedArrowRecipeMaker;
import mezz.jei.library.plugins.vanilla.ingredients.ItemStackHelper;
import mezz.jei.library.plugins.vanilla.ingredients.ItemStackListFactory;
import mezz.jei.library.plugins.vanilla.ingredients.fluid.FluidIngredientHelper;
import mezz.jei.library.plugins.vanilla.ingredients.fluid.FluidStackListFactory;
import mezz.jei.library.plugins.vanilla.stonecutting.StoneCuttingRecipeCategory;
import mezz.jei.library.render.FluidTankRenderer;
import mezz.jei.library.render.ItemStackRenderer;
import mezz.jei.library.transfer.PlayerRecipeTransferHandler;
import net.minecraft.client.gui.screens.inventory.AbstractFurnaceScreen;
import net.minecraft.client.gui.screens.inventory.AnvilScreen;
import net.minecraft.client.gui.screens.inventory.BlastFurnaceScreen;
import net.minecraft.client.gui.screens.inventory.BrewingStandScreen;
import net.minecraft.client.gui.screens.inventory.CraftingScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.gui.screens.inventory.FurnaceScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.inventory.SmithingScreen;
import net.minecraft.client.gui.screens.inventory.SmokerScreen;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.BlastFurnaceMenu;
import net.minecraft.world.inventory.BrewingStandMenu;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.FurnaceMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SmithingMenu;
import net.minecraft.world.inventory.SmokerMenu;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.ShieldDecorationRecipe;
import net.minecraft.world.item.crafting.ShulkerBoxColoring;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.item.crafting.SuspiciousStewRecipe;
import net.minecraft.world.item.crafting.TippedArrowRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public class VanillaPlugin
implements IModPlugin {
    private static final Logger LOGGER = LogManager.getLogger();
    @Nullable
    private CraftingRecipeCategory craftingCategory;
    @Nullable
    private IRecipeCategory<StonecutterRecipe> stonecuttingCategory;
    @Nullable
    private IRecipeCategory<SmeltingRecipe> furnaceCategory;
    @Nullable
    private IRecipeCategory<SmokingRecipe> smokingCategory;
    @Nullable
    private IRecipeCategory<BlastingRecipe> blastingCategory;
    @Nullable
    private IRecipeCategory<CampfireCookingRecipe> campfireCategory;
    @Nullable
    private IRecipeCategory<SmithingRecipe> smithingCategory;

    @Override
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("jei", "minecraft");
    }

    @Override
    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter(Items.f_42738_, PotionSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(Items.f_42589_, PotionSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(Items.f_42736_, PotionSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(Items.f_42739_, PotionSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(Items.f_42690_, (itemStack, context) -> {
            ArrayList enchantmentNames = new ArrayList();
            ListTag enchantments = EnchantedBookItem.m_41163_((ItemStack)itemStack);
            for (int i = 0; i < enchantments.size(); ++i) {
                CompoundTag compoundnbt = enchantments.m_128728_(i);
                String id = compoundnbt.m_128461_("id");
                IPlatformRegistry enchantmentRegistry = Services.PLATFORM.getRegistry(Registries.f_256762_);
                ResourceLocation resourceLocation = ResourceLocation.m_135820_((String)id);
                if (resourceLocation == null) continue;
                enchantmentRegistry.getValue(resourceLocation).map(enchantment -> enchantment.m_44704_() + ".lvl" + compoundnbt.m_128448_("lvl")).ifPresent(enchantmentNames::add);
            }
            enchantmentNames.sort(null);
            return ((Object)enchantmentNames).toString();
        });
    }

    @Override
    public void registerIngredients(IModIngredientRegistration registration) {
        ISubtypeManager subtypeManager = registration.getSubtypeManager();
        StackHelper stackHelper = new StackHelper(subtypeManager);
        List<ItemStack> itemStacks = ItemStackListFactory.create(stackHelper);
        IColorHelper colorHelper = registration.getColorHelper();
        ItemStackHelper itemStackHelper = new ItemStackHelper(stackHelper, colorHelper);
        ItemStackRenderer itemStackRenderer = new ItemStackRenderer();
        registration.register(VanillaTypes.ITEM_STACK, itemStacks, itemStackHelper, itemStackRenderer);
        IPlatformFluidHelperInternal<?> platformFluidHelper = Services.PLATFORM.getFluidHelper();
        this.registerFluidIngredients(registration, platformFluidHelper);
    }

    private <T> void registerFluidIngredients(IModIngredientRegistration registration, IPlatformFluidHelperInternal<T> platformFluidHelper) {
        ISubtypeManager subtypeManager = registration.getSubtypeManager();
        IColorHelper colorHelper = registration.getColorHelper();
        IPlatformRegistry<Fluid> registry = Services.PLATFORM.getRegistry(Registries.f_256808_);
        List<T> fluidIngredients = FluidStackListFactory.create(registry, platformFluidHelper);
        FluidIngredientHelper<T> fluidIngredientHelper = new FluidIngredientHelper<T>(subtypeManager, colorHelper, platformFluidHelper);
        FluidTankRenderer<T> fluidTankRenderer = new FluidTankRenderer<T>(platformFluidHelper);
        IIngredientTypeWithSubtypes fluidIngredientType = platformFluidHelper.getFluidIngredientType();
        registration.register(fluidIngredientType, fluidIngredients, fluidIngredientHelper, fluidTankRenderer);
    }

    @Override
    public void registerCategories(IRecipeCategoryRegistration registration) {
        Textures textures = Internal.getTextures();
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        IRecipeCategory[] iRecipeCategoryArray = new IRecipeCategory[11];
        this.craftingCategory = new CraftingRecipeCategory(guiHelper);
        iRecipeCategoryArray[0] = this.craftingCategory;
        this.stonecuttingCategory = new StoneCuttingRecipeCategory(guiHelper);
        iRecipeCategoryArray[1] = this.stonecuttingCategory;
        this.furnaceCategory = new FurnaceSmeltingCategory(guiHelper);
        iRecipeCategoryArray[2] = this.furnaceCategory;
        this.smokingCategory = new SmokingCategory(guiHelper);
        iRecipeCategoryArray[3] = this.smokingCategory;
        this.blastingCategory = new BlastingCategory(guiHelper);
        iRecipeCategoryArray[4] = this.blastingCategory;
        this.campfireCategory = new CampfireCookingCategory(guiHelper);
        iRecipeCategoryArray[5] = this.campfireCategory;
        this.smithingCategory = new SmithingRecipeCategory(guiHelper);
        iRecipeCategoryArray[6] = this.smithingCategory;
        iRecipeCategoryArray[7] = new CompostableRecipeCategory(guiHelper);
        iRecipeCategoryArray[8] = new FurnaceFuelCategory(guiHelper, textures);
        iRecipeCategoryArray[9] = new BrewingRecipeCategory(guiHelper);
        iRecipeCategoryArray[10] = new AnvilRecipeCategory(guiHelper);
        registration.addRecipeCategories(iRecipeCategoryArray);
    }

    @Override
    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
        IExtendableRecipeCategory<CraftingRecipe, ICraftingCategoryExtension> craftingCategory = registration.getCraftingCategory();
        craftingCategory.addCategoryExtension(CraftingRecipe.class, r -> !r.m_5598_(), CraftingCategoryExtension::new);
    }

    @Override
    public void registerRecipes(IRecipeRegistration registration) {
        ErrorUtil.checkNotNull(this.craftingCategory, "craftingCategory");
        ErrorUtil.checkNotNull(this.stonecuttingCategory, "stonecuttingCategory");
        ErrorUtil.checkNotNull(this.furnaceCategory, "furnaceCategory");
        ErrorUtil.checkNotNull(this.smokingCategory, "smokingCategory");
        ErrorUtil.checkNotNull(this.blastingCategory, "blastingCategory");
        ErrorUtil.checkNotNull(this.campfireCategory, "campfireCategory");
        ErrorUtil.checkNotNull(this.smithingCategory, "smithingCategory");
        IIngredientManager ingredientManager = registration.getIngredientManager();
        IVanillaRecipeFactory vanillaRecipeFactory = registration.getVanillaRecipeFactory();
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IStackHelper stackHelper = jeiHelpers.getStackHelper();
        VanillaRecipes vanillaRecipes = new VanillaRecipes(ingredientManager);
        Map<Boolean, List<CraftingRecipe>> craftingRecipes = vanillaRecipes.getCraftingRecipes(this.craftingCategory);
        List<CraftingRecipe> handledCraftingRecipes = craftingRecipes.get(true);
        List<CraftingRecipe> unhandledCraftingRecipes = craftingRecipes.get(false);
        List<CraftingRecipe> specialCraftingRecipes = VanillaPlugin.replaceSpecialCraftingRecipes(unhandledCraftingRecipes, stackHelper);
        registration.addRecipes(RecipeTypes.CRAFTING, handledCraftingRecipes);
        registration.addRecipes(RecipeTypes.CRAFTING, specialCraftingRecipes);
        registration.addRecipes(RecipeTypes.STONECUTTING, vanillaRecipes.getStonecuttingRecipes(this.stonecuttingCategory));
        registration.addRecipes(RecipeTypes.SMELTING, vanillaRecipes.getFurnaceRecipes(this.furnaceCategory));
        registration.addRecipes(RecipeTypes.SMOKING, vanillaRecipes.getSmokingRecipes(this.smokingCategory));
        registration.addRecipes(RecipeTypes.BLASTING, vanillaRecipes.getBlastingRecipes(this.blastingCategory));
        registration.addRecipes(RecipeTypes.CAMPFIRE_COOKING, vanillaRecipes.getCampfireCookingRecipes(this.campfireCategory));
        registration.addRecipes(RecipeTypes.FUELING, FuelRecipeMaker.getFuelRecipes(ingredientManager));
        registration.addRecipes(RecipeTypes.ANVIL, AnvilRecipeMaker.getAnvilRecipes(vanillaRecipeFactory, ingredientManager));
        registration.addRecipes(RecipeTypes.SMITHING, vanillaRecipes.getSmithingRecipes(this.smithingCategory));
        registration.addRecipes(RecipeTypes.COMPOSTING, CompostingRecipeMaker.getRecipes(ingredientManager));
        IPlatformRecipeHelper recipeHelper = Services.PLATFORM.getRecipeHelper();
        List<IJeiBrewingRecipe> brewingRecipes = recipeHelper.getBrewingRecipes(ingredientManager, vanillaRecipeFactory);
        brewingRecipes.sort(Comparator.comparingInt(IJeiBrewingRecipe::getBrewingSteps));
        registration.addRecipes(RecipeTypes.BREWING, brewingRecipes);
    }

    @Override
    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(CraftingScreen.class, 88, 32, 28, 23, RecipeTypes.CRAFTING);
        registration.addRecipeClickArea(InventoryScreen.class, 137, 29, 10, 13, RecipeTypes.CRAFTING);
        registration.addRecipeClickArea(BrewingStandScreen.class, 97, 16, 14, 30, RecipeTypes.BREWING);
        registration.addRecipeClickArea(FurnaceScreen.class, 78, 32, 28, 23, RecipeTypes.SMELTING, RecipeTypes.FUELING);
        registration.addRecipeClickArea(SmokerScreen.class, 78, 32, 28, 23, RecipeTypes.SMOKING, RecipeTypes.FUELING);
        registration.addRecipeClickArea(BlastFurnaceScreen.class, 78, 32, 28, 23, RecipeTypes.BLASTING, RecipeTypes.FUELING);
        registration.addRecipeClickArea(AnvilScreen.class, 102, 48, 22, 15, RecipeTypes.ANVIL);
        registration.addRecipeClickArea(SmithingScreen.class, 102, 48, 22, 15, RecipeTypes.SMITHING);
        registration.addGenericGuiContainerHandler(EffectRenderingInventoryScreen.class, new InventoryEffectRendererGuiHandler());
        registration.addGuiContainerHandler(CraftingScreen.class, new RecipeBookGuiHandler());
        registration.addGuiContainerHandler(InventoryScreen.class, new RecipeBookGuiHandler());
        registration.addGuiContainerHandler(AbstractFurnaceScreen.class, new RecipeBookGuiHandler());
    }

    @Override
    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(CraftingMenu.class, MenuType.f_39968_, RecipeTypes.CRAFTING, 1, 9, 10, 36);
        registration.addRecipeTransferHandler(FurnaceMenu.class, MenuType.f_39970_, RecipeTypes.SMELTING, 0, 1, 3, 36);
        registration.addRecipeTransferHandler(FurnaceMenu.class, MenuType.f_39970_, RecipeTypes.FUELING, 1, 1, 3, 36);
        registration.addRecipeTransferHandler(SmokerMenu.class, MenuType.f_39978_, RecipeTypes.SMOKING, 0, 1, 3, 36);
        registration.addRecipeTransferHandler(SmokerMenu.class, MenuType.f_39978_, RecipeTypes.FUELING, 1, 1, 3, 36);
        registration.addRecipeTransferHandler(BlastFurnaceMenu.class, MenuType.f_39966_, RecipeTypes.BLASTING, 0, 1, 3, 36);
        registration.addRecipeTransferHandler(BlastFurnaceMenu.class, MenuType.f_39966_, RecipeTypes.FUELING, 1, 1, 3, 36);
        registration.addRecipeTransferHandler(BrewingStandMenu.class, MenuType.f_39967_, RecipeTypes.BREWING, 0, 4, 5, 36);
        registration.addRecipeTransferHandler(AnvilMenu.class, MenuType.f_39964_, RecipeTypes.ANVIL, 0, 2, 3, 36);
        registration.addRecipeTransferHandler(SmithingMenu.class, MenuType.f_39977_, RecipeTypes.SMITHING, 0, 2, 3, 36);
        IRecipeTransferHandlerHelper transferHelper = registration.getTransferHelper();
        PlayerRecipeTransferHandler recipeTransferHandler = new PlayerRecipeTransferHandler(transferHelper);
        registration.addRecipeTransferHandler(recipeTransferHandler, RecipeTypes.CRAFTING);
    }

    @Override
    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.f_50091_), RecipeTypes.CRAFTING);
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.f_50679_), RecipeTypes.STONECUTTING);
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.f_50094_), RecipeTypes.SMELTING, RecipeTypes.FUELING);
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.f_50619_), RecipeTypes.SMOKING, RecipeTypes.FUELING);
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.f_50620_), RecipeTypes.BLASTING, RecipeTypes.FUELING);
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.f_50683_), RecipeTypes.CAMPFIRE_COOKING);
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.f_50684_), RecipeTypes.CAMPFIRE_COOKING);
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.f_50255_), RecipeTypes.BREWING);
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.f_50322_), RecipeTypes.ANVIL);
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.f_50625_), RecipeTypes.SMITHING);
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.f_50715_), RecipeTypes.COMPOSTING);
    }

    public Optional<CraftingRecipeCategory> getCraftingCategory() {
        return Optional.ofNullable(this.craftingCategory);
    }

    private static List<CraftingRecipe> replaceSpecialCraftingRecipes(List<CraftingRecipe> unhandledCraftingRecipes, IStackHelper stackHelper) {
        IdentityHashMap<Class, Supplier<List>> replacers = new IdentityHashMap<Class, Supplier<List>>();
        replacers.put(TippedArrowRecipe.class, () -> TippedArrowRecipeMaker.createRecipes(stackHelper));
        replacers.put(ShulkerBoxColoring.class, ShulkerBoxColoringRecipeMaker::createRecipes);
        replacers.put(SuspiciousStewRecipe.class, SuspiciousStewRecipeMaker::createRecipes);
        replacers.put(ShieldDecorationRecipe.class, ShieldDecorationRecipeMaker::createRecipes);
        return unhandledCraftingRecipes.stream().map(Object::getClass).distinct().filter(replacers::containsKey).limit(replacers.size()).flatMap(recipeClass -> {
            Supplier supplier = (Supplier)replacers.get(recipeClass);
            try {
                List results = (List)supplier.get();
                return results.stream();
            }
            catch (RuntimeException e) {
                LOGGER.error("Failed to create JEI recipes for {}", recipeClass, (Object)e);
                return Stream.of(new CraftingRecipe[0]);
            }
        }).toList();
    }
}

