/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.waveycapes.support;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.tr7zw.waveycapes.CapeRenderer;
import dev.tr7zw.waveycapes.NMSUtil;
import dev.tr7zw.waveycapes.support.ModSupport;
import dev.tr7zw.waveycapes.versionless.ModBase;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftcapes.config.MinecraftCapesConfig;
import net.minecraftcapes.player.PlayerHandler;

public class MinecraftCapesSupport
implements ModSupport {
    private MinecraftCapesRenderer render = new MinecraftCapesRenderer();
    private Function<AbstractClientPlayer, PlayerHandler> getCape = null;

    private void init(AbstractClientPlayer test) {
        try {
            PlayerHandler.get((Player)test).getCapeLocation();
            this.getCape = PlayerHandler::get;
            ModBase.LOGGER.info("Using 'get(Player)' method for MinecraftCapes.");
            return;
        }
        catch (Throwable throwable) {
            try {
                PlayerHandler.get((UUID)test.m_20148_()).getCapeLocation();
                this.getCape = player -> PlayerHandler.get((UUID)player.m_20148_());
                ModBase.LOGGER.info("Using 'get(UUID)' method for MinecraftCapes.");
                return;
            }
            catch (Throwable throwable2) {
                for (Method m : PlayerHandler.class.getMethods()) {
                    try {
                        if (m.getReturnType() != PlayerHandler.class && m.getParameterCount() == 1 && m.getParameterTypes()[0] != UUID.class) continue;
                        m.invoke(null, test);
                        this.getCape = player -> {
                            try {
                                return (PlayerHandler)m.invoke(null, player);
                            }
                            catch (IllegalAccessException | InvocationTargetException e) {
                                return null;
                            }
                        };
                        ModBase.LOGGER.info("Using '" + m.getName() + "' method for MinecraftCapes.");
                        return;
                    }
                    catch (Throwable throwable3) {
                        // empty catch block
                    }
                }
                this.getCape = player -> null;
                ModBase.LOGGER.info("Unable to find a method for MinecraftCapes.");
                return;
            }
        }
    }

    @Override
    public boolean shouldBeUsed(AbstractClientPlayer player) {
        PlayerHandler handler;
        if (!MinecraftCapesConfig.isCapeVisible()) {
            return false;
        }
        if (this.getCape == null) {
            this.init(player);
        }
        return (handler = this.getCape.apply(player)) != null && handler.getCapeLocation() != null;
    }

    @Override
    public CapeRenderer getRenderer() {
        return this.render;
    }

    @Override
    public boolean blockFeatureRenderer(Object feature) {
        return false;
    }

    private class MinecraftCapesRenderer
    implements CapeRenderer {
        private MinecraftCapesRenderer() {
        }

        @Override
        public void render(AbstractClientPlayer player, int part, ModelPart model, PoseStack poseStack, MultiBufferSource multiBufferSource, int light, int overlay) {
            PlayerHandler playerHandler = MinecraftCapesSupport.this.getCape.apply(player);
            VertexConsumer vertexConsumer = MinecraftCapesConfig.isCapeVisible() && playerHandler.getCapeLocation() != null ? ItemRenderer.m_115184_((MultiBufferSource)multiBufferSource, (RenderType)RenderType.m_110431_((ResourceLocation)playerHandler.getCapeLocation()), (boolean)false, (boolean)playerHandler.getHasCapeGlint()) : ItemRenderer.m_115184_((MultiBufferSource)multiBufferSource, (RenderType)RenderType.m_110431_((ResourceLocation)NMSUtil.getPlayerCape(player)), (boolean)false, (boolean)false);
            model.m_104301_(poseStack, vertexConsumer, light, OverlayTexture.f_118083_);
        }

        @Override
        public VertexConsumer getVertexConsumer(MultiBufferSource multiBufferSource, AbstractClientPlayer player) {
            PlayerHandler playerHandler = MinecraftCapesSupport.this.getCape.apply(player);
            if (MinecraftCapesConfig.isCapeVisible() && playerHandler.getCapeLocation() != null) {
                return ItemRenderer.m_115184_((MultiBufferSource)multiBufferSource, (RenderType)RenderType.m_110431_((ResourceLocation)playerHandler.getCapeLocation()), (boolean)false, (boolean)playerHandler.getHasCapeGlint());
            }
            return ItemRenderer.m_115184_((MultiBufferSource)multiBufferSource, (RenderType)RenderType.m_110431_((ResourceLocation)NMSUtil.getPlayerCape(player)), (boolean)false, (boolean)false);
        }

        @Override
        public boolean vanillaUvValues() {
            return true;
        }
    }
}

